/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.gateway.hdfs;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.gateway.Gateway;
import org.elasticsearch.gateway.hdfs.HdfsGateway;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.gateway.IndexGateway;
import org.elasticsearch.index.gateway.IndexShardGateway;
import org.elasticsearch.index.gateway.hdfs.HdfsIndexShardGateway;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.util.inject.Inject;
import org.elasticsearch.util.settings.Settings;

public class HdfsIndexGateway
extends AbstractIndexComponent
implements IndexGateway {
    private final FileSystem fileSystem;
    private final Path indexPath;

    @Inject
    public HdfsIndexGateway(Index index, @IndexSettings Settings indexSettings, Gateway gateway) {
        super(index, indexSettings);
        Path path = null;
        String pathSetting = this.componentSettings.get("path");
        if (pathSetting != null) {
            path = new Path(pathSetting);
        }
        if (gateway instanceof HdfsGateway) {
            HdfsGateway hdfsGateway = (HdfsGateway)gateway;
            this.fileSystem = hdfsGateway.fileSystem();
            if (path == null) {
                path = hdfsGateway.path();
            }
        } else {
            throw new ElasticSearchIllegalArgumentException("Must configure an hdfs gateway to use index hdfs gateway");
        }
        this.indexPath = new Path(new Path(path, "indices"), index.name());
    }

    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    public Path indexPath() {
        return this.indexPath;
    }

    public Class<? extends IndexShardGateway> shardGatewayClass() {
        return HdfsIndexShardGateway.class;
    }

    public void close(boolean delete) throws ElasticSearchException {
        if (delete) {
            try {
                this.fileSystem.delete(this.indexPath, true);
            }
            catch (IOException e) {
                this.logger.warn("Failed to delete [{}]", (Throwable)e, new Object[]{this.indexPath});
            }
        }
    }
}

