/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.gateway.Gateway;
import org.elasticsearch.gateway.GatewayException;
import org.elasticsearch.gateway.hdfs.HdfsIndexGatewayModule;
import org.elasticsearch.util.component.AbstractLifecycleComponent;
import org.elasticsearch.util.inject.Inject;
import org.elasticsearch.util.inject.Module;
import org.elasticsearch.util.settings.Settings;
import org.elasticsearch.util.xcontent.ToXContent;
import org.elasticsearch.util.xcontent.XContentFactory;
import org.elasticsearch.util.xcontent.XContentParser;
import org.elasticsearch.util.xcontent.XContentType;
import org.elasticsearch.util.xcontent.builder.BinaryXContentBuilder;
import org.elasticsearch.util.xcontent.builder.XContentBuilder;

public class HdfsGateway
extends AbstractLifecycleComponent<Gateway>
implements Gateway {
    private final boolean closeFileSystem;
    private final FileSystem fileSystem;
    private final String uri;
    private final Path path;
    private final Path metaDataPath;
    private volatile int currentIndex;

    @Inject
    public HdfsGateway(Settings settings, ClusterName clusterName) throws IOException {
        super(settings);
        this.closeFileSystem = this.componentSettings.getAsBoolean("close_fs", Boolean.valueOf(true));
        this.uri = this.componentSettings.get("uri");
        if (this.uri == null) {
            throw new ElasticSearchIllegalArgumentException("hdfs gateway requires the 'uri' setting to be set");
        }
        String path = this.componentSettings.get("path");
        if (path == null) {
            throw new ElasticSearchIllegalArgumentException("hdfs gateway requires the 'path' path setting to be set");
        }
        this.path = new Path(new Path(path), clusterName.value());
        this.logger.debug("Using uri [{}], path [{}]", new Object[]{this.uri, this.path});
        this.metaDataPath = new Path(this.path, "metadata");
        Configuration conf = new Configuration();
        Settings hdfsSettings = settings.getByPrefix("hdfs.conf.");
        for (Map.Entry entry : hdfsSettings.getAsMap().entrySet()) {
            conf.set((String)entry.getKey(), (String)entry.getValue());
        }
        this.fileSystem = FileSystem.get((URI)URI.create(this.uri), (Configuration)conf);
        this.fileSystem.mkdirs(this.metaDataPath);
        this.currentIndex = this.findLatestIndex();
        this.logger.debug("Latest metadata found at index [" + this.currentIndex + "]", new Object[0]);
    }

    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    public Path path() {
        return this.path;
    }

    protected void doStart() throws ElasticSearchException {
    }

    protected void doStop() throws ElasticSearchException {
    }

    protected void doClose() throws ElasticSearchException {
        if (this.closeFileSystem) {
            try {
                this.fileSystem.close();
            }
            catch (IOException e) {
                this.logger.warn("Failed to close file system {}", new Object[]{this.fileSystem});
            }
        }
    }

    public void write(MetaData metaData) throws GatewayException {
        try {
            final Path file = new Path(this.metaDataPath, "metadata-" + (this.currentIndex + 1));
            BinaryXContentBuilder builder = XContentFactory.contentBinaryBuilder((XContentType)XContentType.JSON);
            builder.prettyPrint();
            builder.startObject();
            MetaData.Builder.toXContent((MetaData)metaData, (XContentBuilder)builder, (ToXContent.Params)ToXContent.EMPTY_PARAMS);
            builder.endObject();
            FSDataOutputStream fileStream = this.fileSystem.create(file, true);
            fileStream.write(builder.unsafeBytes(), 0, builder.unsafeBytesLength());
            fileStream.flush();
            fileStream.sync();
            fileStream.close();
            ++this.currentIndex;
            FileStatus[] oldFiles = this.fileSystem.listStatus(this.metaDataPath, new PathFilter(){

                public boolean accept(Path path) {
                    return path.getName().startsWith("metadata-") && !path.getName().equals(file.getName());
                }
            });
            if (oldFiles != null) {
                for (FileStatus oldFile : oldFiles) {
                    this.fileSystem.delete(oldFile.getPath(), false);
                }
            }
        }
        catch (IOException e) {
            throw new GatewayException("can't write new metadata file into the gateway", (Throwable)e);
        }
    }

    public MetaData read() throws GatewayException {
        try {
            if (this.currentIndex == -1) {
                return null;
            }
            Path file = new Path(this.metaDataPath, "metadata-" + this.currentIndex);
            return this.readMetaData(file);
        }
        catch (GatewayException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GatewayException("can't read metadata file from the gateway", (Throwable)e);
        }
    }

    public Class<? extends Module> suggestIndexGateway() {
        return HdfsIndexGatewayModule.class;
    }

    public void reset() throws IOException {
        this.fileSystem.delete(this.path, true);
    }

    private int findLatestIndex() throws IOException {
        FileStatus[] files = this.fileSystem.listStatus(this.metaDataPath, new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().startsWith("metadata-");
            }
        });
        if (files == null || files.length == 0) {
            return -1;
        }
        int index = -1;
        for (FileStatus file : files) {
            String name;
            int fileIndex;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[findLatestMetadata]: Processing file [" + file + "]", new Object[0]);
            }
            if ((fileIndex = Integer.parseInt((name = file.getPath().getName()).substring(name.indexOf(45) + 1))) < index) continue;
            try {
                this.readMetaData(file.getPath());
                index = fileIndex;
            }
            catch (Exception e) {
                this.logger.warn("[findLatestMetadata]: Failed to read metadata from [" + file + "], ignoring...", (Throwable)e, new Object[0]);
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaData readMetaData(Path file) throws IOException {
        FSDataInputStream fileStream = this.fileSystem.open(file);
        XContentParser parser = null;
        try {
            parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser((InputStream)fileStream);
            MetaData metaData = MetaData.Builder.fromXContent((XContentParser)parser, (Settings)this.settings);
            return metaData;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            try {
                fileStream.close();
            }
            catch (Exception e) {}
        }
    }
}

