/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.grok;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.elasticsearch.grok.GrokCaptureConfig;
import org.elasticsearch.grok.GrokCaptureExtracter;
import org.joni.Region;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum GrokCaptureType {
    STRING{

        @Override
        <T> T nativeExtracter(int[] backRefs, GrokCaptureConfig.NativeExtracterMap<T> map) {
            return map.forString(emit -> this.rawExtracter(backRefs, (Consumer<? super String>)emit));
        }
    }
    ,
    INTEGER{

        @Override
        <T> T nativeExtracter(int[] backRefs, GrokCaptureConfig.NativeExtracterMap<T> map) {
            return map.forInt(emit -> this.rawExtracter(backRefs, str -> emit.accept(Integer.parseInt(str))));
        }
    }
    ,
    LONG{

        @Override
        <T> T nativeExtracter(int[] backRefs, GrokCaptureConfig.NativeExtracterMap<T> map) {
            return map.forLong(emit -> this.rawExtracter(backRefs, str -> emit.accept(Long.parseLong(str))));
        }
    }
    ,
    FLOAT{

        @Override
        <T> T nativeExtracter(int[] backRefs, GrokCaptureConfig.NativeExtracterMap<T> map) {
            return map.forFloat(emit -> this.rawExtracter(backRefs, str -> emit.accept(Float.parseFloat(str))));
        }
    }
    ,
    DOUBLE{

        @Override
        <T> T nativeExtracter(int[] backRefs, GrokCaptureConfig.NativeExtracterMap<T> map) {
            return map.forDouble(emit -> this.rawExtracter(backRefs, str -> emit.accept(Double.parseDouble(str))));
        }
    }
    ,
    BOOLEAN{

        @Override
        <T> T nativeExtracter(int[] backRefs, GrokCaptureConfig.NativeExtracterMap<T> map) {
            return map.forBoolean(emit -> this.rawExtracter(backRefs, str -> emit.accept(Boolean.parseBoolean(str))));
        }
    };


    abstract <T> T nativeExtracter(int[] var1, GrokCaptureConfig.NativeExtracterMap<T> var2);

    static GrokCaptureType fromString(String str) {
        return switch (str) {
            case "string" -> STRING;
            case "int" -> INTEGER;
            case "long" -> LONG;
            case "float" -> FLOAT;
            case "double" -> DOUBLE;
            case "boolean" -> BOOLEAN;
            default -> STRING;
        };
    }

    protected final GrokCaptureExtracter rawExtracter(final int[] backRefs, final Consumer<? super String> emit) {
        return new GrokCaptureExtracter(){

            @Override
            void extract(byte[] utf8Bytes, int offset, Region region) {
                for (int number : backRefs) {
                    if (region.beg[number] < 0) continue;
                    int matchOffset = offset + region.beg[number];
                    int matchLength = region.end[number] - region.beg[number];
                    emit.accept(new String(utf8Bytes, matchOffset, matchLength, StandardCharsets.UTF_8));
                    return;
                }
            }
        };
    }
}

