/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc.mult;

import java.util.Arrays;
import org.ejml.UtilEjml;
import org.ejml.data.FMatrix1Row;
import org.ejml.data.FMatrixD1;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.FMatrixSparseCSC;
import org.ejml.data.Matrix;
import org.ejml.dense.row.MatrixFeatures_FDRM;

public class MatrixVectorMult_FSCC {
    public static void mult(FMatrixSparseCSC A, float[] b, int offsetB, float[] c, int offsetC) {
        Arrays.fill(c, offsetC, offsetC + A.numRows, 0.0f);
        MatrixVectorMult_FSCC.multAdd(A, b, offsetB, c, offsetC);
    }

    public static void multAdd(FMatrixSparseCSC A, float[] b, int offsetB, float[] c, int offsetC) {
        if (b.length - offsetB < A.numCols) {
            throw new IllegalArgumentException("Length of 'b' isn't long enough");
        }
        if (c.length - offsetC < A.numRows) {
            throw new IllegalArgumentException("Length of 'c' isn't long enough");
        }
        for (int k = 0; k < A.numCols; ++k) {
            int idx0 = A.col_idx[k];
            int idx1 = A.col_idx[k + 1];
            for (int indexA = idx0; indexA < idx1; ++indexA) {
                int n = offsetC + A.nz_rows[indexA];
                c[n] = c[n] + A.nz_values[indexA] * b[offsetB + k];
            }
        }
    }

    public static void mult(float[] a, int offsetA, FMatrixSparseCSC B, float[] c, int offsetC) {
        if (a.length - offsetA < B.numRows) {
            throw new IllegalArgumentException("Length of 'a' isn't long enough");
        }
        if (c.length - offsetC < B.numCols) {
            throw new IllegalArgumentException("Length of 'c' isn't long enough");
        }
        for (int k = 0; k < B.numCols; ++k) {
            int idx0 = B.col_idx[k];
            int idx1 = B.col_idx[k + 1];
            float sum = 0.0f;
            for (int indexB = idx0; indexB < idx1; ++indexB) {
                sum += a[offsetA + B.nz_rows[indexB]] * B.nz_values[indexB];
            }
            c[offsetC + k] = sum;
        }
    }

    public static float innerProduct(float[] a, int offsetA, FMatrixSparseCSC B, float[] c, int offsetC) {
        if (a.length - offsetA < B.numRows) {
            throw new IllegalArgumentException("Length of 'a' isn't long enough");
        }
        if (c.length - offsetC < B.numCols) {
            throw new IllegalArgumentException("Length of 'c' isn't long enough");
        }
        float output = 0.0f;
        for (int k = 0; k < B.numCols; ++k) {
            int idx0 = B.col_idx[k];
            int idx1 = B.col_idx[k + 1];
            float sum = 0.0f;
            for (int indexB = idx0; indexB < idx1; ++indexB) {
                sum += a[offsetA + B.nz_rows[indexB]] * B.nz_values[indexB];
            }
            output += sum * c[offsetC + k];
        }
        return output;
    }

    private static void checkInnerProductArguments(FMatrixSparseCSC A, FMatrix1Row B, FMatrixSparseCSC C) {
        UtilEjml.assertTrue((boolean)MatrixFeatures_FDRM.isVector((Matrix)A), (String)"'A' must be a vector");
        UtilEjml.assertEq((int)1, (int)A.numCols, (String)"'A' must be a column vector");
        UtilEjml.assertShape((int)A.getNumElements(), (int)B.numRows, (String)"Length of 'A' vector not equal to number of rows in 'B' matrix");
        UtilEjml.assertTrue((boolean)MatrixFeatures_FDRM.isVector((Matrix)C), (String)"'C' must be a vector");
        UtilEjml.assertEq((int)1, (int)C.numCols, (String)"'C' must be a column vector");
        UtilEjml.assertShape((int)C.getNumElements(), (int)B.numCols, (String)"Length of 'C' vector not equal to number of columns in 'B' matrix");
    }

    public static float innerProduct(FMatrixSparseCSC A, FMatrixRMaj B, FMatrixSparseCSC C) {
        MatrixVectorMult_FSCC.checkInnerProductArguments(A, (FMatrix1Row)B, C);
        float output = 0.0f;
        for (int i = 0; i < A.nz_length; ++i) {
            int b_offset = A.nz_rows[i] * B.numCols;
            float sum = 0.0f;
            for (int j = 0; j < C.nz_length; ++j) {
                sum += C.nz_values[j] * B.data[b_offset + C.nz_rows[j]];
            }
            output += A.nz_values[i] * sum;
        }
        return output;
    }

    private static void checkInnerProductSelfSymmetricalArguments(FMatrixSparseCSC A, FMatrix1Row B) {
        UtilEjml.assertTrue((boolean)MatrixFeatures_FDRM.isVector((Matrix)A), (String)"'A' must be a vector");
        UtilEjml.assertEq((int)1, (int)A.numCols, (String)"'A' must be a column vector");
        UtilEjml.assertTrue((boolean)MatrixFeatures_FDRM.isSquare((FMatrixD1)B), (String)"'B' must be a square matrix");
        UtilEjml.assertShape((int)A.getNumElements(), (int)B.numRows, (String)"Length of 'A' vector not equal to number of rows / columns in 'B' matrix");
    }

    public static float innerProductSelfSymmetrical(FMatrixSparseCSC A, FMatrixRMaj B) {
        MatrixVectorMult_FSCC.checkInnerProductSelfSymmetricalArguments(A, (FMatrix1Row)B);
        float output = 0.0f;
        for (int i = 0; i < A.nz_length; ++i) {
            int index1 = A.nz_rows[i];
            float value1 = A.nz_values[i];
            int b_offset = index1 * B.numCols;
            float diagonalValue = B.data[b_offset + index1];
            float sum = 0.0f;
            for (int j = i + 1; j < A.nz_length; ++j) {
                sum += A.nz_values[j] * B.data[b_offset + A.nz_rows[j]];
            }
            output += value1 * value1 * diagonalValue + value1 * (sum + sum);
        }
        return output;
    }
}

