/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml.service;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheEventListenerConfigurationBuilder;
import org.ehcache.core.spi.service.ServiceUtils;
import org.ehcache.event.EventFiring;
import org.ehcache.event.EventOrdering;
import org.ehcache.impl.config.event.DefaultCacheEventListenerConfiguration;
import org.ehcache.xml.CoreServiceConfigurationParser;
import org.ehcache.xml.XmlConfiguration;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.ehcache.xml.model.CacheTemplate;
import org.ehcache.xml.model.CacheType;
import org.ehcache.xml.model.EventFiringType;
import org.ehcache.xml.model.EventOrderingType;
import org.ehcache.xml.model.EventType;
import org.ehcache.xml.model.ListenersConfig;
import org.ehcache.xml.model.ListenersType;

public class DefaultCacheEventListenerConfigurationParser
implements CoreServiceConfigurationParser {
    @Override
    public <K, V> CacheConfigurationBuilder<K, V> parseServiceConfiguration(CacheTemplate cacheDefinition, ClassLoader cacheClassLoader, CacheConfigurationBuilder<K, V> cacheBuilder) throws ClassNotFoundException {
        ListenersConfig listenersConfig = cacheDefinition.listenersConfig();
        if (listenersConfig != null && listenersConfig.listeners() != null) {
            for (ListenersType.Listener listener : listenersConfig.listeners()) {
                Set eventSetToFireOn = listener.getEventsToFireOn().stream().map(EventType::value).map(org.ehcache.event.EventType::valueOf).collect(Collectors.toSet());
                Class<?> cacheEventListenerClass = XmlConfiguration.getClassForName(listener.getClazz(), cacheClassLoader);
                CacheEventListenerConfigurationBuilder listenerBuilder = CacheEventListenerConfigurationBuilder.newEventListenerConfiguration(cacheEventListenerClass, eventSetToFireOn).firingMode(EventFiring.valueOf((String)listener.getEventFiringMode().value())).eventOrdering(EventOrdering.valueOf((String)listener.getEventOrderingMode().value()));
                cacheBuilder = (CacheConfigurationBuilder)cacheBuilder.withService((Builder)listenerBuilder);
            }
        }
        return cacheBuilder;
    }

    @Override
    public CacheType unparseServiceConfiguration(CacheConfiguration<?, ?> cacheConfiguration, CacheType cacheType) {
        Collection serviceConfigs = ServiceUtils.findAmongst(DefaultCacheEventListenerConfiguration.class, (Collection)cacheConfiguration.getServiceConfigurations());
        if (!serviceConfigs.isEmpty()) {
            ListenersType listenersType = cacheType.getListeners();
            if (listenersType == null) {
                listenersType = new ListenersType();
                cacheType.setListeners(listenersType);
            }
            Set<ListenersType.Listener> listeners = serviceConfigs.stream().map(serviceConfig -> {
                ListenersType.Listener listener = new ListenersType.Listener();
                if (serviceConfig.getInstance() == null) {
                    return listener.withClazz(serviceConfig.getClazz().getName()).withEventFiringMode(EventFiringType.fromValue(serviceConfig.firingMode().name())).withEventOrderingMode(EventOrderingType.fromValue(serviceConfig.orderingMode().name())).withEventsToFireOn(serviceConfig.fireOn().stream().map(eventType -> EventType.fromValue(eventType.name())).collect(Collectors.toSet()));
                }
                throw new XmlConfigurationException("XML translation for instance based initialization for DefaultCacheEventListenerConfiguration is not supported");
            }).collect(Collectors.toSet());
            cacheType.withListeners(listenersType.withListener(listeners));
        }
        return cacheType;
    }
}

