/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml.service;

import java.util.Collection;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.core.spi.service.ServiceUtils;
import org.ehcache.impl.config.copy.DefaultCopierConfiguration;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.xml.CoreServiceConfigurationParser;
import org.ehcache.xml.XmlConfiguration;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.ehcache.xml.model.CacheTemplate;
import org.ehcache.xml.model.CacheType;

public class DefaultCopierConfigurationParser
implements CoreServiceConfigurationParser {
    @Override
    public <K, V> CacheConfigurationBuilder<K, V> parseServiceConfiguration(CacheTemplate cacheDefinition, ClassLoader cacheClassLoader, CacheConfigurationBuilder<K, V> cacheBuilder) throws ClassNotFoundException {
        if (cacheDefinition.keyCopier() != null) {
            Class<?> keyCopier = XmlConfiguration.getClassForName(cacheDefinition.keyCopier(), cacheClassLoader);
            cacheBuilder = cacheBuilder.add((ServiceConfiguration)new DefaultCopierConfiguration(keyCopier, DefaultCopierConfiguration.Type.KEY));
        }
        if (cacheDefinition.valueCopier() != null) {
            Class<?> valueCopier = XmlConfiguration.getClassForName(cacheDefinition.valueCopier(), cacheClassLoader);
            cacheBuilder = cacheBuilder.add((ServiceConfiguration)new DefaultCopierConfiguration(valueCopier, DefaultCopierConfiguration.Type.VALUE));
        }
        return cacheBuilder;
    }

    @Override
    public CacheType unparseServiceConfiguration(CacheConfiguration<?, ?> cacheConfiguration, CacheType cacheType) {
        Collection copierConfigs = ServiceUtils.findAmongst(DefaultCopierConfiguration.class, (Collection)cacheConfiguration.getServiceConfigurations());
        for (DefaultCopierConfiguration copierConfig : copierConfigs) {
            if (copierConfig.getInstance() == null) {
                if (copierConfig.getType() == DefaultCopierConfiguration.Type.KEY) {
                    cacheType.getKeyType().setCopier(copierConfig.getClazz().getName());
                    continue;
                }
                cacheType.getValueType().setCopier(copierConfig.getClazz().getName());
                continue;
            }
            throw new XmlConfigurationException("XML translation for instance based initialization for DefaultCopierConfiguration is not supported");
        }
        return cacheType;
    }
}

