/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml.service;

import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.core.spi.service.ServiceUtils;
import org.ehcache.impl.internal.classes.ClassInstanceConfiguration;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.xml.CoreServiceConfigurationParser;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.ehcache.xml.model.CacheTemplate;
import org.ehcache.xml.model.CacheType;

class SimpleCoreServiceConfigurationParser<IN, OUT, U extends ServiceConfiguration<?>>
implements CoreServiceConfigurationParser {
    private final Function<CacheTemplate, IN> extractor;
    private final Parser<IN, U> parser;
    private final Class<U> configType;
    private final Function<CacheType, OUT> getter;
    private final BiConsumer<CacheType, OUT> setter;
    private final Function<U, OUT> unparser;
    private final BinaryOperator<OUT> merger;

    public static void checkNoConcreteInstance(ClassInstanceConfiguration<?> classInstanceConfiguration) {
        if (classInstanceConfiguration.getInstance() != null) {
            throw new XmlConfigurationException("XML translation for instance based initialization for " + classInstanceConfiguration.getClass().getSimpleName() + " is not supported");
        }
    }

    SimpleCoreServiceConfigurationParser(Class<U> configType, Function<CacheTemplate, IN> extractor, Function<IN, U> parser, Function<CacheType, OUT> getter, BiConsumer<CacheType, OUT> setter, Function<U, OUT> unparser) {
        this(configType, extractor, (IN config, ClassLoader loader) -> (ServiceConfiguration)parser.apply(config), getter, setter, unparser, (a, b) -> {
            throw new IllegalStateException();
        });
    }

    SimpleCoreServiceConfigurationParser(Class<U> configType, Function<CacheTemplate, IN> extractor, Function<IN, U> parser, Function<CacheType, OUT> getter, BiConsumer<CacheType, OUT> setter, Function<U, OUT> unparser, BinaryOperator<OUT> merger) {
        this(configType, extractor, (IN config, ClassLoader loader) -> (ServiceConfiguration)parser.apply(config), getter, setter, unparser, merger);
    }

    SimpleCoreServiceConfigurationParser(Class<U> configType, Function<CacheTemplate, IN> extractor, Parser<IN, U> parser, Function<CacheType, OUT> getter, BiConsumer<CacheType, OUT> setter, Function<U, OUT> unparser) {
        this(configType, extractor, parser, getter, setter, unparser, (a, b) -> {
            throw new IllegalStateException();
        });
    }

    SimpleCoreServiceConfigurationParser(Class<U> configType, Function<CacheTemplate, IN> extractor, Parser<IN, U> parser, Function<CacheType, OUT> getter, BiConsumer<CacheType, OUT> setter, Function<U, OUT> unparser, BinaryOperator<OUT> merger) {
        this.configType = configType;
        this.extractor = extractor;
        this.parser = parser;
        this.getter = getter;
        this.setter = setter;
        this.unparser = unparser;
        this.merger = merger;
    }

    @Override
    public final <K, V> CacheConfigurationBuilder<K, V> parseServiceConfiguration(CacheTemplate cacheDefinition, ClassLoader cacheClassLoader, CacheConfigurationBuilder<K, V> cacheBuilder) throws ClassNotFoundException {
        ServiceConfiguration configuration;
        IN config = this.extractor.apply(cacheDefinition);
        if (config != null && (configuration = (ServiceConfiguration)this.parser.parse(config, cacheClassLoader)) != null) {
            return cacheBuilder.add(configuration);
        }
        return cacheBuilder;
    }

    @Override
    public CacheType unparseServiceConfiguration(CacheConfiguration<?, ?> cacheConfiguration, CacheType cacheType) {
        ServiceConfiguration serviceConfig = (ServiceConfiguration)ServiceUtils.findSingletonAmongst(this.configType, (Collection)cacheConfiguration.getServiceConfigurations());
        if (serviceConfig == null) {
            return cacheType;
        }
        OUT foo = this.getter.apply(cacheType);
        if (foo == null) {
            this.setter.accept(cacheType, this.unparser.apply(serviceConfig));
        } else {
            this.setter.accept(cacheType, this.merger.apply(foo, this.unparser.apply(serviceConfig)));
        }
        return cacheType;
    }

    @FunctionalInterface
    static interface Parser<T, U> {
        public U parse(T var1, ClassLoader var2) throws ClassNotFoundException;
    }
}

