/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml.resource;

import java.net.URI;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourceType;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.config.SizedResourcePoolImpl;
import org.ehcache.xml.CacheResourceConfigurationParser;
import org.ehcache.xml.CoreResourceConfigurationParser;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.ehcache.xml.model.Disk;
import org.ehcache.xml.model.Heap;
import org.ehcache.xml.model.MemoryType;
import org.ehcache.xml.model.Offheap;
import org.ehcache.xml.model.PersistableMemoryType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultResourceConfigurationParser
implements CoreResourceConfigurationParser {
    private final Map<URI, CacheResourceConfigurationParser> extensionConfigParsers;
    private final Unmarshaller unmarshaller;

    public DefaultResourceConfigurationParser(Map<URI, CacheResourceConfigurationParser> extensionConfigParsers, Unmarshaller unmarshaller) {
        this.extensionConfigParsers = extensionConfigParsers;
        this.unmarshaller = unmarshaller;
    }

    @Override
    public ResourcePool parseResourceConfiguration(Element element) {
        if (!"http://www.ehcache.org/v3".equals(element.getNamespaceURI())) {
            return this.parseResourceExtension(element);
        }
        try {
            Object resource = this.unmarshaller.unmarshal((Node)element);
            if (resource instanceof Heap) {
                org.ehcache.xml.model.ResourceType heapResource = (org.ehcache.xml.model.ResourceType)((Heap)((Object)resource)).getValue();
                return new SizedResourcePoolImpl((ResourceType)ResourceType.Core.HEAP, heapResource.getValue().longValue(), DefaultResourceConfigurationParser.parseUnit(heapResource), false);
            }
            if (resource instanceof Offheap) {
                MemoryType offheapResource = (MemoryType)((Offheap)((Object)resource)).getValue();
                return new SizedResourcePoolImpl((ResourceType)ResourceType.Core.OFFHEAP, offheapResource.getValue().longValue(), (ResourceUnit)DefaultResourceConfigurationParser.parseMemory(offheapResource), false);
            }
            if (resource instanceof Disk) {
                PersistableMemoryType diskResource = (PersistableMemoryType)((Disk)((Object)resource)).getValue();
                return new SizedResourcePoolImpl((ResourceType)ResourceType.Core.DISK, diskResource.getValue().longValue(), (ResourceUnit)DefaultResourceConfigurationParser.parseMemory(diskResource), diskResource.isPersistent());
            }
            throw new AssertionError((Object)("Unrecognized resource: " + element + " / " + resource.getClass().getName()));
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Can't find parser for resource: " + element, e);
        }
    }

    private static ResourceUnit parseUnit(org.ehcache.xml.model.ResourceType resourceType) {
        if (resourceType.getUnit().value().equalsIgnoreCase("entries")) {
            return EntryUnit.ENTRIES;
        }
        return MemoryUnit.valueOf((String)resourceType.getUnit().value().toUpperCase());
    }

    private static MemoryUnit parseMemory(MemoryType memoryType) {
        return MemoryUnit.valueOf((String)memoryType.getUnit().value().toUpperCase());
    }

    ResourcePool parseResourceExtension(Element element) {
        URI namespace = URI.create(element.getNamespaceURI());
        CacheResourceConfigurationParser xmlConfigurationParser = this.extensionConfigParsers.get(namespace);
        if (xmlConfigurationParser == null) {
            throw new XmlConfigurationException("Can't find parser for namespace: " + namespace);
        }
        return xmlConfigurationParser.parseResourceConfiguration(element);
    }
}

