/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ConfigurationBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.core.config.ExpiryUtils;
import org.ehcache.core.internal.util.ClassLoading;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.impl.config.copy.DefaultCopierConfiguration;
import org.ehcache.impl.config.serializer.DefaultSerializerConfiguration;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.xml.ConfigurationParser;
import org.ehcache.xml.CoreServiceConfigurationParser;
import org.ehcache.xml.CoreServiceCreationConfigurationParser;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.ehcache.xml.model.CacheDefinition;
import org.ehcache.xml.model.CacheTemplate;
import org.ehcache.xml.model.ConfigType;
import org.ehcache.xml.model.Expiry;
import org.ehcache.xml.model.ServiceType;
import org.ehcache.xml.provider.CacheEventDispatcherFactoryConfigurationParser;
import org.ehcache.xml.provider.CacheManagerPersistenceConfigurationParser;
import org.ehcache.xml.provider.DefaultCopyProviderConfigurationParser;
import org.ehcache.xml.provider.DefaultSerializationProviderConfigurationParser;
import org.ehcache.xml.provider.DefaultSizeOfEngineProviderConfigurationParser;
import org.ehcache.xml.provider.OffHeapDiskStoreProviderConfigurationParser;
import org.ehcache.xml.provider.PooledExecutionServiceConfigurationParser;
import org.ehcache.xml.provider.WriteBehindProviderConfigurationParser;
import org.ehcache.xml.service.DefaultCacheEventDispatcherConfigurationParser;
import org.ehcache.xml.service.DefaultCacheEventListenerConfigurationParser;
import org.ehcache.xml.service.DefaultCacheLoaderWriterConfigurationParser;
import org.ehcache.xml.service.DefaultResilienceStrategyConfigurationParser;
import org.ehcache.xml.service.DefaultSizeOfEngineConfigurationParser;
import org.ehcache.xml.service.DefaultWriteBehindConfigurationParser;
import org.ehcache.xml.service.OffHeapDiskStoreConfigurationParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class XmlConfiguration
implements Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlConfiguration.class);
    private final URL xml;
    private final Configuration configuration;
    private final Map<String, CacheTemplate> templates = new HashMap<String, CacheTemplate>();
    private static final Collection<CoreServiceCreationConfigurationParser> CORE_SERVICE_CREATION_CONFIGURATION_PARSERS = Arrays.asList(new DefaultCopyProviderConfigurationParser(), new DefaultSerializationProviderConfigurationParser(), new OffHeapDiskStoreProviderConfigurationParser(), new CacheEventDispatcherFactoryConfigurationParser(), new DefaultSizeOfEngineProviderConfigurationParser(), new CacheManagerPersistenceConfigurationParser(), new PooledExecutionServiceConfigurationParser(), new WriteBehindProviderConfigurationParser());
    private static final Collection<CoreServiceConfigurationParser> CORE_SERVICE_CONFIGURATION_PARSERS = Arrays.asList(new DefaultCacheLoaderWriterConfigurationParser(), new DefaultResilienceStrategyConfigurationParser(), new DefaultSizeOfEngineConfigurationParser(), new DefaultWriteBehindConfigurationParser(), new OffHeapDiskStoreConfigurationParser(), new DefaultCacheEventDispatcherConfigurationParser(), new DefaultCacheEventListenerConfigurationParser());

    public XmlConfiguration(URL url) throws XmlConfigurationException {
        this(url, ClassLoading.getDefaultClassLoader());
    }

    public XmlConfiguration(URL url, ClassLoader classLoader) throws XmlConfigurationException {
        this(url, classLoader, Collections.emptyMap());
    }

    public XmlConfiguration(URL url, ClassLoader classLoader, Map<String, ClassLoader> cacheClassLoaders) throws XmlConfigurationException {
        if (url == null) {
            throw new NullPointerException("The url can not be null");
        }
        if (classLoader == null) {
            throw new NullPointerException("The classLoader can not be null");
        }
        if (cacheClassLoaders == null) {
            throw new NullPointerException("The cacheClassLoaders map can not be null");
        }
        this.xml = url;
        try {
            this.configuration = this.parseConfiguration(this.xml, classLoader, cacheClassLoaders);
        }
        catch (XmlConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlConfigurationException("Error parsing XML configuration at " + url, e);
        }
    }

    private Configuration parseConfiguration(URL xml, ClassLoader classLoader, Map<String, ClassLoader> cacheClassLoaders) throws ClassNotFoundException, IOException, SAXException, InstantiationException, IllegalAccessException, JAXBException, ParserConfigurationException {
        LOGGER.info("Loading Ehcache XML configuration from {}.", (Object)xml.getPath());
        ConfigurationParser configurationParser = new ConfigurationParser(xml.toExternalForm());
        ConfigurationBuilder managerBuilder = ConfigurationBuilder.newConfigurationBuilder();
        managerBuilder = managerBuilder.withClassLoader(classLoader);
        ConfigType configRoot = configurationParser.getConfigRoot();
        for (CoreServiceCreationConfigurationParser parser : CORE_SERVICE_CREATION_CONFIGURATION_PARSERS) {
            managerBuilder = parser.parseServiceCreationConfiguration(configRoot, classLoader, managerBuilder);
        }
        for (ServiceType serviceType : configRoot.getService()) {
            ServiceCreationConfiguration<?> serviceConfiguration = configurationParser.parseExtension(serviceType.getServiceCreationConfiguration());
            managerBuilder = managerBuilder.addService(serviceConfiguration);
        }
        this.templates.putAll(configurationParser.getTemplates());
        for (CacheDefinition cacheDefinition : configurationParser.getCacheElements()) {
            String alias = cacheDefinition.id();
            if (managerBuilder.containsCache(alias)) {
                throw new XmlConfigurationException("Two caches defined with the same alias: " + alias);
            }
            ClassLoader cacheClassLoader = cacheClassLoaders.get(alias);
            boolean classLoaderConfigured = false;
            if (cacheClassLoader != null) {
                classLoaderConfigured = true;
            }
            if (cacheClassLoader == null) {
                cacheClassLoader = classLoader != null ? classLoader : ClassLoading.getDefaultClassLoader();
            }
            Class<?> keyType = XmlConfiguration.getClassForName(cacheDefinition.keyType(), cacheClassLoader);
            Class<?> valueType = XmlConfiguration.getClassForName(cacheDefinition.valueType(), cacheClassLoader);
            ResourcePoolsBuilder resourcePoolsBuilder = ResourcePoolsBuilder.newResourcePoolsBuilder();
            for (ResourcePool resourcePool : cacheDefinition.resourcePools()) {
                resourcePoolsBuilder = resourcePoolsBuilder.with(resourcePool);
            }
            CacheConfigurationBuilder cacheBuilder = CacheConfigurationBuilder.newCacheConfigurationBuilder(keyType, valueType, (Builder)resourcePoolsBuilder);
            if (classLoaderConfigured) {
                cacheBuilder = cacheBuilder.withClassLoader(cacheClassLoader);
            }
            cacheBuilder = this.buildCacheConfigurationFromTemplate(cacheBuilder, cacheClassLoader, cacheDefinition);
            managerBuilder = managerBuilder.addCache(alias, cacheBuilder.build());
        }
        return managerBuilder.build();
    }

    private static ExpiryPolicy<? super Object, ? super Object> getExpiry(ClassLoader cacheClassLoader, Expiry parsedExpiry) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ExpiryPolicy expiry;
        if (parsedExpiry.isUserDef()) {
            ExpiryPolicy tmpExpiry;
            try {
                tmpExpiry = XmlConfiguration.getInstanceOfName(parsedExpiry.type(), cacheClassLoader, ExpiryPolicy.class);
            }
            catch (ClassCastException e) {
                tmpExpiry = ExpiryUtils.convertToExpiryPolicy((org.ehcache.expiry.Expiry)XmlConfiguration.getInstanceOfName(parsedExpiry.type(), cacheClassLoader, org.ehcache.expiry.Expiry.class));
            }
            expiry = tmpExpiry;
        } else {
            expiry = parsedExpiry.isTTL() ? ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.of(parsedExpiry.value(), parsedExpiry.unit())) : (parsedExpiry.isTTI() ? ExpiryPolicyBuilder.timeToIdleExpiration((Duration)Duration.of(parsedExpiry.value(), parsedExpiry.unit())) : ExpiryPolicyBuilder.noExpiration());
        }
        return expiry;
    }

    private static <T> T getInstanceOfName(String name, ClassLoader classLoader, Class<T> type) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (name == null) {
            return null;
        }
        Class<?> klazz = XmlConfiguration.getClassForName(name, classLoader);
        return klazz.asSubclass(type).newInstance();
    }

    public static Class<?> getClassForName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(name, true, classLoader);
    }

    public URL getURL() {
        return this.xml;
    }

    public <K, V> CacheConfigurationBuilder<K, V> newCacheConfigurationBuilderFromTemplate(String name, Class<K> keyType, Class<V> valueType) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.internalCacheConfigurationBuilderFromTemplate(name, keyType, valueType, null);
    }

    public <K, V> CacheConfigurationBuilder<K, V> newCacheConfigurationBuilderFromTemplate(String name, Class<K> keyType, Class<V> valueType, ResourcePools resourcePools) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (resourcePools == null || resourcePools.getResourceTypeSet().isEmpty()) {
            throw new IllegalArgumentException("ResourcePools parameter must define at least one resource");
        }
        return this.internalCacheConfigurationBuilderFromTemplate(name, keyType, valueType, resourcePools);
    }

    public <K, V> CacheConfigurationBuilder<K, V> newCacheConfigurationBuilderFromTemplate(String name, Class<K> keyType, Class<V> valueType, Builder<? extends ResourcePools> resourcePoolsBuilder) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.internalCacheConfigurationBuilderFromTemplate(name, keyType, valueType, (ResourcePools)resourcePoolsBuilder.build());
    }

    private <K, V> CacheConfigurationBuilder<K, V> internalCacheConfigurationBuilderFromTemplate(String name, Class<K> keyType, Class<V> valueType, ResourcePools resourcePools) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        CacheConfigurationBuilder builder;
        CacheTemplate cacheTemplate = this.templates.get(name);
        if (cacheTemplate == null) {
            return null;
        }
        ClassLoader defaultClassLoader = ClassLoading.getDefaultClassLoader();
        Class<K> keyClass = XmlConfiguration.getClassForName(cacheTemplate.keyType(), defaultClassLoader);
        Class<V> valueClass = XmlConfiguration.getClassForName(cacheTemplate.valueType(), defaultClassLoader);
        if (keyType != null && cacheTemplate.keyType() != null && !keyClass.isAssignableFrom(keyType)) {
            throw new IllegalArgumentException("CacheTemplate '" + name + "' declares key type of " + cacheTemplate.keyType());
        }
        if (valueType != null && cacheTemplate.valueType() != null && !valueClass.isAssignableFrom(valueType)) {
            throw new IllegalArgumentException("CacheTemplate '" + name + "' declares value type of " + cacheTemplate.valueType());
        }
        if ((resourcePools == null || resourcePools.getResourceTypeSet().isEmpty()) && cacheTemplate.resourcePools().isEmpty()) {
            throw new IllegalStateException("Template defines no resources, and none were provided");
        }
        if (resourcePools != null) {
            builder = CacheConfigurationBuilder.newCacheConfigurationBuilder(keyType, valueType, (ResourcePools)resourcePools);
        } else {
            ResourcePoolsBuilder resourcePoolsBuilder = ResourcePoolsBuilder.newResourcePoolsBuilder();
            for (ResourcePool resourcePool : cacheTemplate.resourcePools()) {
                resourcePoolsBuilder = resourcePoolsBuilder.with(resourcePool);
            }
            builder = CacheConfigurationBuilder.newCacheConfigurationBuilder(keyType, valueType, (Builder)resourcePoolsBuilder);
        }
        return this.buildCacheConfigurationFromTemplate(builder, defaultClassLoader, cacheTemplate);
    }

    private <K, V> CacheConfigurationBuilder<K, V> buildCacheConfigurationFromTemplate(CacheConfigurationBuilder<K, V> cacheBuilder, ClassLoader cacheClassLoader, CacheTemplate cacheDefinition) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (cacheDefinition.keySerializer() != null) {
            Class<?> keySerializer = XmlConfiguration.getClassForName(cacheDefinition.keySerializer(), cacheClassLoader);
            cacheBuilder = cacheBuilder.add((ServiceConfiguration)new DefaultSerializerConfiguration(keySerializer, DefaultSerializerConfiguration.Type.KEY));
        }
        if (cacheDefinition.keyCopier() != null) {
            Class<?> keyCopier = XmlConfiguration.getClassForName(cacheDefinition.keyCopier(), cacheClassLoader);
            cacheBuilder = cacheBuilder.add((ServiceConfiguration)new DefaultCopierConfiguration(keyCopier, DefaultCopierConfiguration.Type.KEY));
        }
        if (cacheDefinition.valueSerializer() != null) {
            Class<?> valueSerializer = XmlConfiguration.getClassForName(cacheDefinition.valueSerializer(), cacheClassLoader);
            cacheBuilder = cacheBuilder.add((ServiceConfiguration)new DefaultSerializerConfiguration(valueSerializer, DefaultSerializerConfiguration.Type.VALUE));
        }
        if (cacheDefinition.valueCopier() != null) {
            Class<?> valueCopier = XmlConfiguration.getClassForName(cacheDefinition.valueCopier(), cacheClassLoader);
            cacheBuilder = cacheBuilder.add((ServiceConfiguration)new DefaultCopierConfiguration(valueCopier, DefaultCopierConfiguration.Type.VALUE));
        }
        EvictionAdvisor evictionAdvisor = XmlConfiguration.getInstanceOfName(cacheDefinition.evictionAdvisor(), cacheClassLoader, EvictionAdvisor.class);
        cacheBuilder = cacheBuilder.withEvictionAdvisor(evictionAdvisor);
        Expiry parsedExpiry = cacheDefinition.expiry();
        if (parsedExpiry != null) {
            cacheBuilder = cacheBuilder.withExpiry(XmlConfiguration.getExpiry(cacheClassLoader, parsedExpiry));
        }
        for (CoreServiceConfigurationParser coreServiceConfigurationParser : CORE_SERVICE_CONFIGURATION_PARSERS) {
            cacheBuilder = coreServiceConfigurationParser.parseServiceConfiguration(cacheDefinition, cacheClassLoader, cacheBuilder);
        }
        for (ServiceConfiguration serviceConfiguration : cacheDefinition.serviceConfigs()) {
            cacheBuilder = cacheBuilder.add(serviceConfiguration);
        }
        return cacheBuilder;
    }

    public Map<String, CacheConfiguration<?, ?>> getCacheConfigurations() {
        return this.configuration.getCacheConfigurations();
    }

    public Collection<ServiceCreationConfiguration<?>> getServiceCreationConfigurations() {
        return this.configuration.getServiceCreationConfigurations();
    }

    public ClassLoader getClassLoader() {
        return this.configuration.getClassLoader();
    }
}

