/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ehcache.xml.XmlConfiguration;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DomUtil {
    private static final SchemaFactory XSD_SCHEMA_FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private static final URL CORE_SCHEMA_URL = XmlConfiguration.class.getResource("/ehcache-core.xsd");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Schema newSchema(Source[] schemas) throws SAXException {
        SchemaFactory schemaFactory = XSD_SCHEMA_FACTORY;
        synchronized (schemaFactory) {
            return XSD_SCHEMA_FACTORY.newSchema(schemas);
        }
    }

    public static DocumentBuilder createAndGetDocumentBuilder(Collection<Source> schemaSources) throws SAXException, ParserConfigurationException {
        DocumentBuilderFactory factory = DomUtil.createAndGetFactory(schemaSources);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new TransformationErrorHandler());
        return documentBuilder;
    }

    public static DocumentBuilder createAndGetDocumentBuilder() throws SAXException, ParserConfigurationException, IOException {
        return DomUtil.createAndGetDocumentBuilder(Arrays.asList(new StreamSource(CORE_SCHEMA_URL.openStream())));
    }

    private static DocumentBuilderFactory createAndGetFactory(Collection<Source> schemaSources) throws SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setSchema(DomUtil.newSchema(schemaSources.toArray(new Source[schemaSources.size()])));
        return factory;
    }

    static class TransformationErrorHandler
    implements ErrorHandler {
        TransformationErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }
}

