/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ehcache.core.internal.util.ClassLoading;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.xml.CacheManagerServiceConfigurationParser;
import org.ehcache.xml.CacheResourceConfigurationParser;
import org.ehcache.xml.CacheServiceConfigurationParser;
import org.ehcache.xml.XmlConfiguration;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.ehcache.xml.model.BaseCacheType;
import org.ehcache.xml.model.CacheDefinition;
import org.ehcache.xml.model.CacheTemplate;
import org.ehcache.xml.model.CacheTemplateType;
import org.ehcache.xml.model.CacheType;
import org.ehcache.xml.model.ConfigType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ConfigurationParser {
    private static final Pattern SYSPROP = Pattern.compile("\\$\\{([^}]+)\\}");
    private static final SchemaFactory XSD_SCHEMA_FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private static final URL CORE_SCHEMA_URL = XmlConfiguration.class.getResource("/ehcache-core.xsd");
    public static final String CORE_SCHEMA_NAMESPACE = "http://www.ehcache.org/v3";
    private static final String CORE_SCHEMA_ROOT_ELEMENT = "config";
    private static final String CORE_SCHEMA_JAXB_MODEL_PACKAGE = ConfigType.class.getPackage().getName();
    private final Map<URI, CacheManagerServiceConfigurationParser<?>> xmlParsers = new HashMap();
    private final Map<URI, CacheServiceConfigurationParser<?>> cacheXmlParsers = new HashMap();
    private final Unmarshaller unmarshaller;
    private final Map<URI, CacheResourceConfigurationParser> resourceXmlParsers = new HashMap<URI, CacheResourceConfigurationParser>();
    private final ConfigType config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Schema newSchema(Source[] schemas) throws SAXException {
        SchemaFactory schemaFactory = XSD_SCHEMA_FACTORY;
        synchronized (schemaFactory) {
            return XSD_SCHEMA_FACTORY.newSchema(schemas);
        }
    }

    static String replaceProperties(String originalValue, Properties properties) {
        Matcher matcher = SYSPROP.matcher(originalValue);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String property = matcher.group(1);
            String value = properties.getProperty(property);
            if (value == null) {
                throw new IllegalStateException(String.format("Replacement for ${%s} not found!", property));
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(sb);
        String resolvedValue = sb.toString();
        return resolvedValue.equals(originalValue) ? null : resolvedValue;
    }

    public ConfigurationParser(String xml) throws IOException, SAXException, JAXBException, ParserConfigurationException {
        ArrayList<Source> schemaSources = new ArrayList<Source>();
        schemaSources.add(new StreamSource(CORE_SCHEMA_URL.openStream()));
        for (Object parser : ClassLoading.libraryServiceLoaderFor(CacheManagerServiceConfigurationParser.class)) {
            schemaSources.add(parser.getXmlSchema());
            this.xmlParsers.put(parser.getNamespace(), (CacheManagerServiceConfigurationParser<?>)parser);
        }
        for (Object parser : ClassLoading.libraryServiceLoaderFor(CacheServiceConfigurationParser.class)) {
            schemaSources.add(parser.getXmlSchema());
            this.cacheXmlParsers.put(parser.getNamespace(), (CacheServiceConfigurationParser<?>)parser);
        }
        for (Object parser : ClassLoading.libraryServiceLoaderFor(CacheResourceConfigurationParser.class)) {
            schemaSources.add(parser.getXmlSchema());
            this.resourceXmlParsers.put(parser.getNamespace(), (CacheResourceConfigurationParser)parser);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setSchema(ConfigurationParser.newSchema(schemaSources.toArray(new Source[schemaSources.size()])));
        DocumentBuilder domBuilder = factory.newDocumentBuilder();
        domBuilder.setErrorHandler(new FatalErrorHandler());
        Element dom = domBuilder.parse(xml).getDocumentElement();
        this.substituteSystemProperties(dom);
        if (!CORE_SCHEMA_ROOT_ELEMENT.equals(dom.getLocalName()) || !CORE_SCHEMA_NAMESPACE.equals(dom.getNamespaceURI())) {
            throw new XmlConfigurationException("Expecting {http://www.ehcache.org/v3}config element; found {" + dom.getNamespaceURI() + "}" + dom.getLocalName());
        }
        Class<ConfigType> configTypeClass = ConfigType.class;
        JAXBContext jc = JAXBContext.newInstance((String)CORE_SCHEMA_JAXB_MODEL_PACKAGE, (ClassLoader)configTypeClass.getClassLoader());
        this.unmarshaller = jc.createUnmarshaller();
        this.config = (ConfigType)this.unmarshaller.unmarshal((Node)dom, configTypeClass).getValue();
    }

    public ConfigType getConfigRoot() {
        return this.config;
    }

    private void substituteSystemProperties(Element dom) {
        Properties properties = System.getProperties();
        Stack<NodeList> nodeLists = new Stack<NodeList>();
        nodeLists.push(dom.getChildNodes());
        while (!nodeLists.isEmpty()) {
            NodeList nodeList = (NodeList)nodeLists.pop();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String newValue;
                NamedNodeMap attributes;
                Node currentNode = nodeList.item(i);
                if (currentNode.hasChildNodes()) {
                    nodeLists.push(currentNode.getChildNodes());
                }
                if ((attributes = currentNode.getAttributes()) != null) {
                    for (int j = 0; j < attributes.getLength(); ++j) {
                        Node attributeNode = attributes.item(j);
                        String newValue2 = ConfigurationParser.replaceProperties(attributeNode.getNodeValue(), properties);
                        if (newValue2 == null) continue;
                        attributeNode.setNodeValue(newValue2);
                    }
                }
                if (currentNode.getNodeType() != 3 || (newValue = ConfigurationParser.replaceProperties(currentNode.getNodeValue(), properties)) == null) continue;
                currentNode.setNodeValue(newValue);
            }
        }
    }

    public Iterable<CacheDefinition> getCacheElements() {
        ArrayList<CacheDefinition> cacheCfgs = new ArrayList<CacheDefinition>();
        List<BaseCacheType> cacheOrCacheTemplate = this.config.getCacheOrCacheTemplate();
        for (BaseCacheType baseCacheType : cacheOrCacheTemplate) {
            if (!(baseCacheType instanceof CacheType)) continue;
            CacheType cacheType = (CacheType)baseCacheType;
            BaseCacheType[] sources = cacheType.getUsesTemplate() != null ? new BaseCacheType[]{cacheType, (BaseCacheType)cacheType.getUsesTemplate()} : new BaseCacheType[]{cacheType};
            cacheCfgs.add(new CacheDefinition(cacheType.getAlias(), this.cacheXmlParsers, this.resourceXmlParsers, this.unmarshaller, sources));
        }
        return Collections.unmodifiableList(cacheCfgs);
    }

    public Map<String, CacheTemplate> getTemplates() {
        HashMap<String, CacheTemplate.Impl> templates = new HashMap<String, CacheTemplate.Impl>();
        List<BaseCacheType> cacheOrCacheTemplate = this.config.getCacheOrCacheTemplate();
        for (BaseCacheType baseCacheType : cacheOrCacheTemplate) {
            if (!(baseCacheType instanceof CacheTemplateType)) continue;
            CacheTemplateType cacheTemplate = (CacheTemplateType)baseCacheType;
            templates.put(cacheTemplate.getName(), new CacheTemplate.Impl(this.cacheXmlParsers, this.resourceXmlParsers, this.unmarshaller, cacheTemplate));
        }
        return Collections.unmodifiableMap(templates);
    }

    ServiceCreationConfiguration<?> parseExtension(Element element) {
        URI namespace = URI.create(element.getNamespaceURI());
        CacheManagerServiceConfigurationParser<?> cacheManagerServiceConfigurationParser = this.xmlParsers.get(namespace);
        if (cacheManagerServiceConfigurationParser == null) {
            throw new IllegalArgumentException("Can't find parser for namespace: " + namespace);
        }
        return cacheManagerServiceConfigurationParser.parseServiceCreationConfiguration(element);
    }

    static class FatalErrorHandler
    implements ErrorHandler {
        FatalErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }
}

