
package org.ehcache.xml.model;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * &lt;p&gt;Java class for time-unit.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * &lt;pre&gt;
 * &amp;lt;simpleType name="time-unit"&amp;gt;
 *   &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&amp;gt;
 *     &amp;lt;enumeration value="nanos"/&amp;gt;
 *     &amp;lt;enumeration value="micros"/&amp;gt;
 *     &amp;lt;enumeration value="millis"/&amp;gt;
 *     &amp;lt;enumeration value="seconds"/&amp;gt;
 *     &amp;lt;enumeration value="minutes"/&amp;gt;
 *     &amp;lt;enumeration value="hours"/&amp;gt;
 *     &amp;lt;enumeration value="days"/&amp;gt;
 *   &amp;lt;/restriction&amp;gt;
 * &amp;lt;/simpleType&amp;gt;
 * &lt;/pre&gt;
 * 
 */
@XmlType(name = "time-unit")
@XmlEnum
public enum TimeUnit {

    @XmlEnumValue("nanos")
    NANOS("nanos"),
    @XmlEnumValue("micros")
    MICROS("micros"),
    @XmlEnumValue("millis")
    MILLIS("millis"),
    @XmlEnumValue("seconds")
    SECONDS("seconds"),
    @XmlEnumValue("minutes")
    MINUTES("minutes"),
    @XmlEnumValue("hours")
    HOURS("hours"),
    @XmlEnumValue("days")
    DAYS("days");
    private final String value;

    TimeUnit(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static TimeUnit fromValue(String v) {
        for (TimeUnit c: TimeUnit.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
