/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.FluentConfigurationBuilder;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ConfigurationBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.core.util.ClassLoading;
import org.ehcache.xml.CacheManagerServiceConfigurationParser;
import org.ehcache.xml.CacheResourceConfigurationParser;
import org.ehcache.xml.CacheServiceConfigurationParser;
import org.ehcache.xml.CoreCacheConfigurationParser;
import org.ehcache.xml.Parser;
import org.ehcache.xml.ResourceConfigurationParser;
import org.ehcache.xml.ServiceConfigurationParser;
import org.ehcache.xml.ServiceCreationConfigurationParser;
import org.ehcache.xml.XmlConfiguration;
import org.ehcache.xml.XmlUtil;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.ehcache.xml.model.BaseCacheType;
import org.ehcache.xml.model.CacheDefinition;
import org.ehcache.xml.model.CacheEntryType;
import org.ehcache.xml.model.CacheTemplate;
import org.ehcache.xml.model.CacheTemplateType;
import org.ehcache.xml.model.CacheType;
import org.ehcache.xml.model.ConfigType;
import org.ehcache.xml.model.ObjectFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ConfigurationParser {
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private static final QName CORE_SCHEMA_ROOT_NAME;
    static final CoreCacheConfigurationParser CORE_CACHE_CONFIGURATION_PARSER;
    private final Schema schema;
    private final JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ConfigType.class});
    private final DocumentBuilder documentBuilder;
    private final ServiceCreationConfigurationParser serviceCreationConfigurationParser = ConfigurationParser.stream(XmlUtil.namespaceUniqueParsersOfType(CacheManagerServiceConfigurationParser.class)).collect(Collectors.collectingAndThen(Collectors.toMap(CacheManagerServiceConfigurationParser::getServiceType, Function.identity(), (a, b) -> a.getClass().isInstance(b) ? b : a), ServiceCreationConfigurationParser::new));
    private final ServiceConfigurationParser serviceConfigurationParser = ConfigurationParser.stream(XmlUtil.namespaceUniqueParsersOfType(CacheServiceConfigurationParser.class)).collect(Collectors.collectingAndThen(Collectors.toMap(CacheServiceConfigurationParser::getServiceType, Function.identity(), (a, b) -> a.getClass().isInstance(b) ? b : a), ServiceConfigurationParser::new));
    private final ResourceConfigurationParser resourceConfigurationParser = ConfigurationParser.stream(ClassLoading.servicesOfType(CacheResourceConfigurationParser.class)).flatMap(p -> p.getResourceTypes().stream().map(t -> new AbstractMap.SimpleImmutableEntry<Class, CacheResourceConfigurationParser>((Class)t, (CacheResourceConfigurationParser)p))).collect(Collectors.collectingAndThen(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a.getClass().isInstance(b) ? b : a), m -> new ResourceConfigurationParser(new HashSet<CacheResourceConfigurationParser>(m.values()))));

    private static <T> Stream<T> stream(Iterable<? super T> iterable) {
        return StreamSupport.stream(Spliterators.spliterator(iterable.iterator(), Long.MAX_VALUE, 0), false);
    }

    ConfigurationParser() throws IOException, SAXException, JAXBException, ParserConfigurationException {
        this.schema = ConfigurationParser.discoverSchema(new StreamSource(XmlConfiguration.CORE_SCHEMA_URL.openStream()));
        this.documentBuilder = ConfigurationParser.documentBuilder(this.schema);
    }

    <K, V> CacheConfigurationBuilder<K, V> parseServiceConfigurations(Document document, CacheConfigurationBuilder<K, V> cacheBuilder, ClassLoader cacheClassLoader, CacheTemplate cacheDefinition) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        cacheBuilder = CORE_CACHE_CONFIGURATION_PARSER.parse(cacheDefinition, cacheClassLoader, cacheBuilder);
        return this.serviceConfigurationParser.parse(document, cacheDefinition, cacheClassLoader, cacheBuilder);
    }

    private static Iterable<CacheDefinition> getCacheElements(ConfigType configType) {
        ArrayList<CacheDefinition> cacheCfgs = new ArrayList<CacheDefinition>();
        List<BaseCacheType> cacheOrCacheTemplate = configType.getCacheOrCacheTemplate();
        for (BaseCacheType baseCacheType : cacheOrCacheTemplate) {
            if (!(baseCacheType instanceof CacheType)) continue;
            CacheType cacheType = (CacheType)baseCacheType;
            BaseCacheType[] sources = cacheType.getUsesTemplate() != null ? new BaseCacheType[]{cacheType, (BaseCacheType)cacheType.getUsesTemplate()} : new BaseCacheType[]{cacheType};
            cacheCfgs.add(new CacheDefinition(cacheType.getAlias(), sources));
        }
        return Collections.unmodifiableList(cacheCfgs);
    }

    private Map<String, XmlConfiguration.Template> getTemplates(Document document, ConfigType configType) {
        HashMap<String, XmlConfiguration.Template> templates = new HashMap<String, XmlConfiguration.Template>();
        List<BaseCacheType> cacheOrCacheTemplate = configType.getCacheOrCacheTemplate();
        for (BaseCacheType baseCacheType : cacheOrCacheTemplate) {
            if (!(baseCacheType instanceof CacheTemplateType)) continue;
            CacheTemplate.Impl cacheTemplate = new CacheTemplate.Impl((CacheTemplateType)baseCacheType);
            templates.put(cacheTemplate.id(), this.parseTemplate(document, cacheTemplate));
        }
        return Collections.unmodifiableMap(templates);
    }

    private XmlConfiguration.Template parseTemplate(final Document document, final CacheTemplate template) {
        return new XmlConfiguration.Template(){

            @Override
            public <K, V> CacheConfigurationBuilder<K, V> builderFor(ClassLoader classLoader, Class<K> keyType, Class<V> valueType, ResourcePools resources) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
                ConfigurationParser.checkTemplateTypeConsistency("key", classLoader, keyType, template);
                ConfigurationParser.checkTemplateTypeConsistency("value", classLoader, valueType, template);
                if ((resources == null || resources.getResourceTypeSet().isEmpty()) && template.getHeap() == null && template.getResources().isEmpty()) {
                    throw new IllegalStateException("Template defines no resources, and none were provided");
                }
                if (resources == null) {
                    resources = ConfigurationParser.this.resourceConfigurationParser.parse(template, ResourcePoolsBuilder.newResourcePoolsBuilder(), classLoader);
                }
                return ConfigurationParser.this.parseServiceConfigurations(document, CacheConfigurationBuilder.newCacheConfigurationBuilder(keyType, valueType, (ResourcePools)resources), classLoader, template);
            }
        };
    }

    private static <T> void checkTemplateTypeConsistency(String type, ClassLoader classLoader, Class<T> providedType, CacheTemplate template) throws ClassNotFoundException {
        Class<Object> templateType = type.equals("key") ? XmlConfiguration.getClassForName(template.keyType(), classLoader) : XmlConfiguration.getClassForName(template.valueType(), classLoader);
        if (providedType == null || !templateType.isAssignableFrom(providedType)) {
            throw new IllegalArgumentException("CacheTemplate '" + template.id() + "' declares " + type + " type of " + templateType.getName() + ". Provided: " + providedType);
        }
    }

    public Document uriToDocument(URI uri) throws IOException, SAXException {
        return this.documentBuilder.parse(uri.toString());
    }

    public XmlConfigurationWrapper documentToConfig(Document document, ClassLoader classLoader, Map<String, ClassLoader> cacheClassLoaders) throws JAXBException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Document annotatedDocument = XmlUtil.stampExternalConfigurations(this.copyAndValidate(document));
        Element root = annotatedDocument.getDocumentElement();
        QName rootName = new QName(root.getNamespaceURI(), root.getLocalName());
        if (!CORE_SCHEMA_ROOT_NAME.equals(rootName)) {
            throw new XmlConfigurationException("Expecting " + CORE_SCHEMA_ROOT_NAME + " element; found " + rootName);
        }
        Class<ConfigType> configTypeClass = ConfigType.class;
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
        ConfigType jaxbModel = (ConfigType)unmarshaller.unmarshal((Node)annotatedDocument, configTypeClass).getValue();
        FluentConfigurationBuilder managerBuilder = ConfigurationBuilder.newConfigurationBuilder().withClassLoader(classLoader);
        managerBuilder = this.serviceCreationConfigurationParser.parse(annotatedDocument, jaxbModel, classLoader, managerBuilder);
        for (CacheDefinition cacheDefinition : ConfigurationParser.getCacheElements(jaxbModel)) {
            boolean classLoaderConfigured;
            String alias = cacheDefinition.id();
            if (managerBuilder.getCache(alias) != null) {
                throw new XmlConfigurationException("Two caches defined with the same alias: " + alias);
            }
            ClassLoader cacheClassLoader = cacheClassLoaders.get(alias);
            boolean bl = classLoaderConfigured = cacheClassLoader != null;
            if (cacheClassLoader == null) {
                cacheClassLoader = classLoader != null ? classLoader : ClassLoading.getDefaultClassLoader();
            }
            Class<?> keyType = XmlConfiguration.getClassForName(cacheDefinition.keyType(), cacheClassLoader);
            Class<?> valueType = XmlConfiguration.getClassForName(cacheDefinition.valueType(), cacheClassLoader);
            ResourcePools resourcePools = this.resourceConfigurationParser.parse(cacheDefinition, ResourcePoolsBuilder.newResourcePoolsBuilder(), classLoader);
            CacheConfigurationBuilder cacheBuilder = CacheConfigurationBuilder.newCacheConfigurationBuilder(keyType, valueType, (ResourcePools)resourcePools);
            if (classLoaderConfigured) {
                cacheBuilder = cacheBuilder.withClassLoader(cacheClassLoader);
            }
            cacheBuilder = this.parseServiceConfigurations(annotatedDocument, cacheBuilder, cacheClassLoader, cacheDefinition);
            managerBuilder = managerBuilder.withCache(alias, cacheBuilder.build());
        }
        Map<String, XmlConfiguration.Template> templates = this.getTemplates(annotatedDocument, jaxbModel);
        return new XmlConfigurationWrapper((Configuration)managerBuilder.build(), templates);
    }

    private Document copyAndValidate(Document document) {
        try {
            Validator validator = this.schema.newValidator();
            Document newDocument = this.documentBuilder.newDocument();
            newDocument.setStrictErrorChecking(false);
            validator.validate(new DOMSource(document), new DOMResult(newDocument));
            return newDocument;
        }
        catch (IOException | SAXException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Document configToDocument(Configuration configuration) throws JAXBException {
        ConfigType configType = new ConfigType();
        Document document = this.documentBuilder.newDocument();
        this.serviceCreationConfigurationParser.unparse(document, configuration, configType);
        for (Map.Entry cacheConfigurationEntry : configuration.getCacheConfigurations().entrySet()) {
            CacheConfiguration cacheConfiguration = (CacheConfiguration)cacheConfigurationEntry.getValue();
            CacheType cacheType = new CacheType().withAlias((String)cacheConfigurationEntry.getKey()).withKeyType(new CacheEntryType().withValue(cacheConfiguration.getKeyType().getName())).withValueType(new CacheEntryType().withValue(cacheConfiguration.getValueType().getName()));
            cacheType = this.resourceConfigurationParser.unparse(document, cacheConfiguration.getResourcePools(), cacheType);
            cacheType = CORE_CACHE_CONFIGURATION_PARSER.unparse(cacheConfiguration, cacheType);
            cacheType = this.serviceConfigurationParser.unparse(document, cacheConfiguration, cacheType);
            configType = configType.withCacheOrCacheTemplate(cacheType);
        }
        JAXBElement<ConfigType> root = new ObjectFactory().createConfig(configType);
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setSchema(this.schema);
        marshaller.marshal(root, (Node)document);
        return document;
    }

    public static String documentToText(Document xml) throws IOException, TransformerException {
        try (StringWriter writer = new StringWriter();){
            ConfigurationParser.transformer().transform(new DOMSource(xml), new StreamResult(writer));
            String string = writer.toString();
            return string;
        }
    }

    private static Transformer transformer() throws TransformerConfigurationException {
        Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        return transformer;
    }

    public static String urlToText(URL url, String encoding) throws IOException {
        Charset charset = encoding == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), charset));){
            String string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static DocumentBuilder documentBuilder(Schema schema) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setSchema(schema);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new XmlUtil.FatalErrorHandler());
        return documentBuilder;
    }

    public static Schema discoverSchema(Source ... fixedSources) throws SAXException {
        ArrayList neededNamespaces = new ArrayList();
        HashMap<URI, Supplier<Source>> sources = new HashMap<URI, Supplier<Source>>();
        for (Iterable parsers : Arrays.asList(XmlUtil.namespaceUniqueParsersOfType(CacheManagerServiceConfigurationParser.class), XmlUtil.namespaceUniqueParsersOfType(CacheServiceConfigurationParser.class), ClassLoading.servicesOfType(CacheResourceConfigurationParser.class))) {
            for (Parser p : parsers) {
                ArrayList<URI> ordering = new ArrayList<URI>();
                for (Map.Entry<URI, Supplier<Source>> element : p.getSchema().entrySet()) {
                    sources.putIfAbsent(element.getKey(), element.getValue());
                    ordering.add(element.getKey());
                }
                neededNamespaces.add(ordering);
            }
        }
        List fullOrdering = XmlUtil.mergePartialOrderings(neededNamespaces);
        ArrayList<Source> schemaSources = new ArrayList<Source>(Arrays.asList(fixedSources));
        schemaSources.addAll(fullOrdering.stream().map(sources::get).map(Supplier::get).collect(Collectors.toList()));
        return XmlUtil.newSchema(schemaSources.toArray(new Source[0]));
    }

    static {
        ObjectFactory objectFactory = new ObjectFactory();
        CORE_SCHEMA_ROOT_NAME = objectFactory.createConfig(objectFactory.createConfigType()).getName();
        CORE_CACHE_CONFIGURATION_PARSER = new CoreCacheConfigurationParser();
    }

    public static class XmlConfigurationWrapper {
        private final Configuration configuration;
        private final Map<String, XmlConfiguration.Template> templates;

        public XmlConfigurationWrapper(Configuration configuration, Map<String, XmlConfiguration.Template> templates) {
            this.configuration = configuration;
            this.templates = templates;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public Map<String, XmlConfiguration.Template> getTemplates() {
            return this.templates;
        }
    }
}

