/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml.service;

import java.math.BigInteger;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.ehcache.config.builders.WriteBehindConfigurationBuilder;
import org.ehcache.spi.loaderwriter.WriteBehindConfiguration;
import org.ehcache.xml.XmlModel;
import org.ehcache.xml.model.BaseCacheType;
import org.ehcache.xml.model.CacheLoaderWriterType;
import org.ehcache.xml.model.CacheTemplate;
import org.ehcache.xml.model.CacheType;
import org.ehcache.xml.model.TimeTypeWithPropSubst;
import org.ehcache.xml.service.SimpleCoreServiceConfigurationParser;

public class DefaultWriteBehindConfigurationParser
extends SimpleCoreServiceConfigurationParser<CacheTemplate, CacheType, CacheLoaderWriterType.WriteBehind, CacheLoaderWriterType, WriteBehindConfiguration<?>> {
    public DefaultWriteBehindConfigurationParser() {
        super(WriteBehindConfiguration.class, CacheTemplate::writeBehind, (IN config) -> (WriteBehindConfiguration)Optional.ofNullable(config.getBatching()).map(batching -> {
            WriteBehindConfigurationBuilder.BatchedWriteBehindConfigurationBuilder batchedBuilder = WriteBehindConfigurationBuilder.newBatchedWriteBehindConfiguration((long)batching.getMaxWriteDelay().getValue().longValue(), (TimeUnit)XmlModel.convertToJUCTimeUnit(batching.getMaxWriteDelay().getUnit()), (int)batching.getBatchSize().intValue());
            if (batching.isCoalesce()) {
                batchedBuilder = batchedBuilder.enableCoalescing();
            }
            return batchedBuilder;
        }).orElseGet(WriteBehindConfigurationBuilder::newUnBatchedWriteBehindConfiguration).useThreadPool(config.getThreadPool()).concurrencyLevel(config.getConcurrency().intValue()).queueSize(config.getSize().intValue()).build(), BaseCacheType::getLoaderWriter, BaseCacheType::setLoaderWriter, (U config) -> {
            CacheLoaderWriterType.WriteBehind writeBehind = new CacheLoaderWriterType.WriteBehind().withThreadPool(config.getThreadPoolAlias()).withConcurrency(BigInteger.valueOf(config.getConcurrency())).withSize(BigInteger.valueOf(config.getMaxQueueSize()));
            WriteBehindConfiguration.BatchingConfiguration batchingConfiguration = config.getBatchingConfiguration();
            if (batchingConfiguration == null) {
                writeBehind.setNonBatching(new CacheLoaderWriterType.WriteBehind.NonBatching());
            } else {
                writeBehind.withBatching(new CacheLoaderWriterType.WriteBehind.Batching().withBatchSize(BigInteger.valueOf(batchingConfiguration.getBatchSize())).withCoalesce(batchingConfiguration.isCoalescing()).withMaxWriteDelay(new TimeTypeWithPropSubst().withValue(BigInteger.valueOf(batchingConfiguration.getMaxDelay())).withUnit(XmlModel.convertToXmlTimeUnit(batchingConfiguration.getMaxDelayUnit()))));
            }
            return new CacheLoaderWriterType().withWriteBehind(writeBehind);
        }, (existing, additional) -> {
            existing.setWriteBehind(additional.getWriteBehind());
            return existing;
        });
    }
}

