/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;

public class XmlUtil {
    private static final URL CORE_SCHEMA_URL = XmlUtil.class.getResource("/ehcache-core.xsd");

    public static DocumentBuilder createAndGetDocumentBuilder(Collection<Source> schemaSources) throws SAXException, ParserConfigurationException {
        DocumentBuilderFactory factory = XmlUtil.createAndGetFactory(schemaSources);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new TransformationErrorHandler());
        return documentBuilder;
    }

    public static DocumentBuilder createAndGetDocumentBuilder(Source schemaSource) throws SAXException, ParserConfigurationException, IOException {
        ArrayList<Source> schemaSources = new ArrayList<Source>(2);
        schemaSources.add(new StreamSource(CORE_SCHEMA_URL.openStream()));
        schemaSources.add(schemaSource);
        return XmlUtil.createAndGetDocumentBuilder(schemaSources);
    }

    public static DocumentBuilder createAndGetDocumentBuilder() throws SAXException, ParserConfigurationException, IOException {
        return XmlUtil.createAndGetDocumentBuilder(new StreamSource(CORE_SCHEMA_URL.openStream()));
    }

    private static DocumentBuilderFactory createAndGetFactory(Collection<Source> schemaSources) throws SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setSchema(XmlUtil.newSchema(schemaSources.toArray(new Source[schemaSources.size()])));
        return factory;
    }

    public static Document createDocumentRoot(Source schemaSource) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder domBuilder = XmlUtil.createAndGetDocumentBuilder(schemaSource);
        Document doc = domBuilder.newDocument();
        return doc;
    }

    public static Schema newSchema(Source ... schemas) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            schemaFactory.setProperty("http://saxon.sf.net/feature/xsd-version", "1.0");
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
        schemaFactory.setErrorHandler(new FatalErrorHandler());
        return schemaFactory.newSchema(schemas);
    }

    public static class FatalErrorHandler
    implements ErrorHandler {
        private static final Collection<Pattern> ABSTRACT_TYPE_FAILURES;

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.fatalError(exception);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.fatalError(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            if (ABSTRACT_TYPE_FAILURES.stream().anyMatch(pattern -> pattern.matcher(exception.getMessage()).matches())) {
                throw new XmlConfigurationException("Cannot confirm XML sub-type correctness. You might be missing client side libraries.", exception);
            }
            throw exception;
        }

        static {
            List<QName> abstractTypes = Arrays.asList(new QName("http://www.ehcache.org/v3", "service-creation-configuration"), new QName("http://www.ehcache.org/v3", "service-configuration"), new QName("http://www.ehcache.org/v3", "resource"));
            ABSTRACT_TYPE_FAILURES = Arrays.asList(abstractTypes.stream().map(element -> Pattern.quote(String.format("\"%s\":%s", element.getNamespaceURI(), element.getLocalPart()))).collect(Collectors.collectingAndThen(Collectors.joining("|", "^\\Qcvc-complex-type.2.4.a\\E.*'\\{.*(?:", ").*\\}'.*$"), Pattern::compile)), abstractTypes.stream().map(element -> Pattern.quote(element.getLocalPart())).collect(Collectors.collectingAndThen(Collectors.joining("|", "^.*\\QThe content model does not allow element\\E.*(?:", ").*"), Pattern::compile)));
        }
    }

    static class TransformationErrorHandler
    implements ErrorHandler {
        TransformationErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }
}

