/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config.xml;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.ehcache.config.xml.JaxbHelper;
import org.ehcache.config.xml.XmlConfigurationParser;
import org.ehcache.config.xml.model.BaseCacheType;
import org.ehcache.config.xml.model.CacheIntegration;
import org.ehcache.config.xml.model.CacheTemplateType;
import org.ehcache.config.xml.model.CacheType;
import org.ehcache.config.xml.model.ConfigType;
import org.ehcache.config.xml.model.ExpiryType;
import org.ehcache.config.xml.model.ServiceType;
import org.ehcache.config.xml.model.TimeType;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.util.ClassLoading;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ConfigurationParser {
    private static final SchemaFactory XSD_SCHEMA_FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private final Map<URI, XmlConfigurationParser> xmlParsers = new HashMap<URI, XmlConfigurationParser>();
    private final ConfigType config;

    public ConfigurationParser(String xml, URL ... sources) throws IOException, SAXException {
        DocumentBuilder domBuilder;
        ArrayList<Source> schemaSources = new ArrayList<Source>();
        for (XmlConfigurationParser parser : ClassLoading.libraryServiceLoaderFor(XmlConfigurationParser.class)) {
            schemaSources.add(parser.getXmlSchema());
            this.xmlParsers.put(parser.getNamespace(), parser);
        }
        for (URL source : sources) {
            schemaSources.add(new StreamSource(source.openStream()));
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setSchema(XSD_SCHEMA_FACTORY.newSchema(schemaSources.toArray(new Source[schemaSources.size()])));
        try {
            domBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        domBuilder.setErrorHandler(new FatalErrorHandler());
        Element config = domBuilder.parse(xml).getDocumentElement();
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"org.ehcache.config.xml.model");
            Unmarshaller u = jc.createUnmarshaller();
            this.config = (ConfigType)u.unmarshal((Node)config, ConfigType.class).getValue();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterable<ServiceConfiguration> getServiceConfigurations() {
        ArrayList serviceConfigurations = new ArrayList();
        for (ServiceType serviceType : this.config.getService()) {
            ServiceConfiguration<?> serviceConfiguration = this.parseExtension((Element)serviceType.getAny());
            serviceConfigurations.add(serviceConfiguration);
        }
        return Collections.unmodifiableList(serviceConfigurations);
    }

    public Iterable<CacheDefinition> getCacheElements() {
        ArrayList<1> cacheCfgs = new ArrayList<1>();
        List<BaseCacheType> cacheOrCacheTemplate = this.config.getCacheOrCacheTemplate();
        for (BaseCacheType baseCacheType : cacheOrCacheTemplate) {
            if (!(baseCacheType instanceof CacheType)) continue;
            final CacheType cacheType = (CacheType)baseCacheType;
            final BaseCacheType[] sources = cacheType.getUsesTemplate() != null ? new BaseCacheType[]{cacheType, (BaseCacheType)cacheType.getUsesTemplate()} : new BaseCacheType[]{cacheType};
            cacheCfgs.add(new CacheDefinition(){

                @Override
                public String id() {
                    return cacheType.getAlias();
                }

                @Override
                public String keyType() {
                    BaseCacheType source;
                    int i$;
                    String value = null;
                    BaseCacheType[] arr$ = sources;
                    int len$ = arr$.length;
                    for (i$ = 0; i$ < len$ && (value = (source = arr$[i$]).getKeyType()) == null; ++i$) {
                    }
                    if (value == null) {
                        arr$ = sources;
                        len$ = arr$.length;
                        for (i$ = 0; i$ < len$ && (value = JaxbHelper.findDefaultValue(source = arr$[i$], "keyType")) == null; ++i$) {
                        }
                    }
                    return value;
                }

                @Override
                public String valueType() {
                    BaseCacheType source;
                    int i$;
                    String value = null;
                    BaseCacheType[] arr$ = sources;
                    int len$ = arr$.length;
                    for (i$ = 0; i$ < len$ && (value = (source = arr$[i$]).getValueType()) == null; ++i$) {
                    }
                    if (value == null) {
                        arr$ = sources;
                        len$ = arr$.length;
                        for (i$ = 0; i$ < len$ && (value = JaxbHelper.findDefaultValue(source = arr$[i$], "valueType")) == null; ++i$) {
                        }
                    }
                    return value;
                }

                @Override
                public Long capacityConstraint() {
                    BaseCacheType source;
                    BigInteger value = null;
                    BaseCacheType[] arr$ = sources;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (value = (source = arr$[i$]).getCapacity()) == null; ++i$) {
                    }
                    return value != null ? Long.valueOf(value.longValue()) : null;
                }

                @Override
                public String evictionVeto() {
                    BaseCacheType source;
                    String value = null;
                    BaseCacheType[] arr$ = sources;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (value = (source = arr$[i$]).getEvictionVeto()) == null; ++i$) {
                    }
                    return value;
                }

                @Override
                public String evictionPrioritizer() {
                    BaseCacheType source;
                    String value = null;
                    BaseCacheType[] arr$ = sources;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (value = (source = arr$[i$]).getEvictionPrioritizer()) == null; ++i$) {
                    }
                    return value;
                }

                @Override
                public Expiry expiry() {
                    BaseCacheType source;
                    ExpiryType value = null;
                    BaseCacheType[] arr$ = sources;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (value = (source = arr$[i$]).getExpiry()) == null; ++i$) {
                    }
                    return new XmlExpiry(value);
                }

                @Override
                public boolean storeByValueOnHeap() {
                    BaseCacheType source;
                    Boolean value = null;
                    BaseCacheType[] arr$ = sources;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (value = (source = arr$[i$]).isStoreByValueOnHeap()) == null; ++i$) {
                    }
                    return value == null ? false : value;
                }

                @Override
                public String loader() {
                    String configClass = null;
                    for (BaseCacheType source : sources) {
                        CacheIntegration.Loader loader;
                        CacheIntegration integration = source.getIntegration();
                        CacheIntegration.Loader loader2 = loader = integration != null ? integration.getLoader() : null;
                        if (loader == null) continue;
                        configClass = loader.getClazz();
                        break;
                    }
                    return configClass;
                }

                @Override
                public String writer() {
                    String configClass = null;
                    for (BaseCacheType source : sources) {
                        CacheIntegration.Writer writer;
                        CacheIntegration integration = source.getIntegration();
                        CacheIntegration.Writer writer2 = writer = integration != null ? integration.getWriter() : null;
                        if (writer == null) continue;
                        configClass = writer.getClazz();
                        break;
                    }
                    return configClass;
                }

                @Override
                public Iterable<ServiceConfiguration<?>> serviceConfigs() {
                    ArrayList configs = new ArrayList();
                    for (BaseCacheType source : sources) {
                        for (Object child : source.getAny()) {
                            configs.add(ConfigurationParser.this.parseExtension((Element)child));
                        }
                    }
                    return configs;
                }
            });
        }
        return Collections.unmodifiableList(cacheCfgs);
    }

    public Map<String, CacheTemplate> getTemplates() {
        HashMap<String, 2> templates = new HashMap<String, 2>();
        List<BaseCacheType> cacheOrCacheTemplate = this.config.getCacheOrCacheTemplate();
        for (BaseCacheType baseCacheType : cacheOrCacheTemplate) {
            if (!(baseCacheType instanceof CacheTemplateType)) continue;
            final CacheTemplateType cacheTemplate = (CacheTemplateType)baseCacheType;
            templates.put(cacheTemplate.getName(), new CacheTemplate(){

                @Override
                public String keyType() {
                    String keyType = cacheTemplate.getKeyType();
                    if (keyType == null) {
                        keyType = JaxbHelper.findDefaultValue(cacheTemplate, "keyType");
                    }
                    return keyType;
                }

                @Override
                public String valueType() {
                    String valueType = cacheTemplate.getValueType();
                    if (valueType == null) {
                        valueType = JaxbHelper.findDefaultValue(cacheTemplate, "valueType");
                    }
                    return valueType;
                }

                @Override
                public Long capacityConstraint() {
                    BigInteger capacity = cacheTemplate.getCapacity();
                    return capacity == null ? null : Long.valueOf(capacity.longValue());
                }

                @Override
                public String evictionVeto() {
                    return cacheTemplate.getEvictionVeto();
                }

                @Override
                public String evictionPrioritizer() {
                    return cacheTemplate.getEvictionPrioritizer();
                }

                @Override
                public Expiry expiry() {
                    return new XmlExpiry(cacheTemplate.getExpiry());
                }

                @Override
                public boolean storeByValueOnHeap() {
                    Boolean storeByValueOnHeap = cacheTemplate.isStoreByValueOnHeap();
                    return storeByValueOnHeap == null ? false : storeByValueOnHeap;
                }

                @Override
                public String loader() {
                    CacheIntegration integration = cacheTemplate.getIntegration();
                    CacheIntegration.Loader loader = integration != null ? integration.getLoader() : null;
                    return loader != null ? loader.getClazz() : null;
                }

                @Override
                public String writer() {
                    CacheIntegration integration = cacheTemplate.getIntegration();
                    CacheIntegration.Writer writer = integration != null ? integration.getWriter() : null;
                    return writer != null ? writer.getClazz() : null;
                }

                @Override
                public Iterable<ServiceConfiguration<?>> serviceConfigs() {
                    ArrayList configs = new ArrayList();
                    for (Object child : cacheTemplate.getAny()) {
                        configs.add(ConfigurationParser.this.parseExtension((Element)child));
                    }
                    return configs;
                }
            });
        }
        return Collections.unmodifiableMap(templates);
    }

    private ServiceConfiguration<?> parseExtension(Element element) {
        URI namespace = URI.create(element.getNamespaceURI());
        XmlConfigurationParser xmlConfigurationParser = this.xmlParsers.get(namespace);
        if (xmlConfigurationParser == null) {
            throw new IllegalArgumentException("Can't find parser for namespace: " + namespace);
        }
        return xmlConfigurationParser.parse(element);
    }

    private static class XmlExpiry
    implements Expiry {
        final ExpiryType type;

        private XmlExpiry(ExpiryType type) {
            this.type = type;
        }

        @Override
        public boolean isUserDef() {
            return this.type != null && this.type.getClazz() != null;
        }

        @Override
        public boolean isTTI() {
            return this.type != null && this.type.getTti() != null;
        }

        @Override
        public boolean isTTL() {
            return this.type != null && this.type.getTtl() != null;
        }

        @Override
        public String type() {
            return this.type.getClazz();
        }

        @Override
        public long value() {
            TimeType time = this.isTTI() ? this.type.getTti() : this.type.getTtl();
            return time == null ? 0L : time.getValue().longValue();
        }

        @Override
        public TimeUnit unit() {
            TimeType time = this.isTTI() ? this.type.getTti() : this.type.getTtl();
            if (time != null) {
                switch (time.getUnit()) {
                    case NANOS: {
                        return TimeUnit.NANOSECONDS;
                    }
                    case MICROS: {
                        return TimeUnit.MICROSECONDS;
                    }
                    case MILLIS: {
                        return TimeUnit.MILLISECONDS;
                    }
                    case SECONDS: {
                        return TimeUnit.SECONDS;
                    }
                    case MINUTES: {
                        return TimeUnit.MINUTES;
                    }
                    case HOURS: {
                        return TimeUnit.HOURS;
                    }
                    case DAYS: {
                        return TimeUnit.DAYS;
                    }
                }
            }
            return null;
        }
    }

    static interface Expiry {
        public boolean isUserDef();

        public boolean isTTI();

        public boolean isTTL();

        public String type();

        public long value();

        public TimeUnit unit();
    }

    static interface CacheDefinition
    extends CacheTemplate {
        public String id();
    }

    static interface CacheTemplate {
        public String keyType();

        public String valueType();

        public Long capacityConstraint();

        public String evictionVeto();

        public String evictionPrioritizer();

        public Expiry expiry();

        public boolean storeByValueOnHeap();

        public String loader();

        public String writer();

        public Iterable<ServiceConfiguration<?>> serviceConfigs();
    }

    static class FatalErrorHandler
    implements ErrorHandler {
        FatalErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }
}

