/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.server.internal.messages;

import java.nio.ByteBuffer;
import org.ehcache.clustered.common.internal.messages.ChainCodec;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;
import org.ehcache.clustered.common.internal.messages.MessageCodecUtils;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.server.internal.messages.PassiveReplicationMessage;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.StructDecoder;

public class PassiveReplicationMessageCodec {
    private static final String CHAIN_FIELD = "chain";
    private static final String OLDEST_TRANSACTION_ID_FIELD = "otId";
    private static final String TRANSACTION_ID_FIELD = "tId";
    private static final String CLIENT_ID_FIELD = "cId";
    private static final Struct CHAIN_REPLICATION_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("tId", 15).int64("cId", 20).string("serverStoreName", 30).int64("otId", 35).int64("key", 40).struct("chain", 45, ChainCodec.CHAIN_STRUCT).build();
    private static final Struct CLEAR_INVALIDATION_COMPLETE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).build();
    private static final Struct INVALIDATION_COMPLETE_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, EhcacheMessageType.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).int64("key", 20).build();

    public byte[] encode(PassiveReplicationMessage message) {
        switch (message.getMessageType()) {
            case CHAIN_REPLICATION_OP: {
                return this.encodeChainReplicationMessage((PassiveReplicationMessage.ChainReplicationMessage)message);
            }
            case CLEAR_INVALIDATION_COMPLETE: {
                return this.encodeClearInvalidationCompleteMessage((PassiveReplicationMessage.ClearInvalidationCompleteMessage)message);
            }
            case INVALIDATION_COMPLETE: {
                return this.encodeInvalidationCompleteMessage((PassiveReplicationMessage.InvalidationCompleteMessage)message);
            }
        }
        throw new UnsupportedOperationException("This operation is not supported : " + message.getMessageType());
    }

    private byte[] encodeInvalidationCompleteMessage(PassiveReplicationMessage.InvalidationCompleteMessage message) {
        return MessageCodecUtils.encodeMandatoryFields((Struct)INVALIDATION_COMPLETE_STRUCT, (EhcacheOperationMessage)message).int64("key", message.getKey()).encode().array();
    }

    private byte[] encodeClearInvalidationCompleteMessage(PassiveReplicationMessage.ClearInvalidationCompleteMessage message) {
        return MessageCodecUtils.encodeMandatoryFields((Struct)CLEAR_INVALIDATION_COMPLETE_STRUCT, (EhcacheOperationMessage)message).encode().array();
    }

    private byte[] encodeChainReplicationMessage(PassiveReplicationMessage.ChainReplicationMessage message) {
        return MessageCodecUtils.encodeMandatoryFields((Struct)CHAIN_REPLICATION_STRUCT, (EhcacheOperationMessage)message).int64(TRANSACTION_ID_FIELD, message.getTransactionId()).int64(CLIENT_ID_FIELD, message.getClientId()).int64(OLDEST_TRANSACTION_ID_FIELD, message.getOldestTransactionId()).int64("key", message.getKey()).struct(CHAIN_FIELD, (Object)message.getChain(), ChainCodec::encode).encode().array();
    }

    public EhcacheEntityMessage decode(EhcacheMessageType messageType, ByteBuffer messageBuffer) {
        switch (messageType) {
            case CHAIN_REPLICATION_OP: {
                return this.decodeChainReplicationMessage(messageBuffer);
            }
            case CLEAR_INVALIDATION_COMPLETE: {
                return this.decodeClearInvalidationCompleteMessage(messageBuffer);
            }
            case INVALIDATION_COMPLETE: {
                return this.decodeInvalidationCompleteMessage(messageBuffer);
            }
        }
        throw new UnsupportedOperationException("Unknown message type: " + messageType);
    }

    private PassiveReplicationMessage.InvalidationCompleteMessage decodeInvalidationCompleteMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = INVALIDATION_COMPLETE_STRUCT.decoder(messageBuffer);
        Long key = decoder.int64("key");
        return new PassiveReplicationMessage.InvalidationCompleteMessage(key);
    }

    private PassiveReplicationMessage.ClearInvalidationCompleteMessage decodeClearInvalidationCompleteMessage(ByteBuffer messageBuffer) {
        return new PassiveReplicationMessage.ClearInvalidationCompleteMessage();
    }

    private PassiveReplicationMessage.ChainReplicationMessage decodeChainReplicationMessage(ByteBuffer messageBuffer) {
        StructDecoder decoder = CHAIN_REPLICATION_STRUCT.decoder(messageBuffer);
        Long currentTransactionId = decoder.int64(TRANSACTION_ID_FIELD);
        Long clientId = decoder.int64(CLIENT_ID_FIELD);
        Long oldestTransactionId = decoder.int64(OLDEST_TRANSACTION_ID_FIELD);
        Long key = decoder.int64("key");
        Chain chain = ChainCodec.decode((StructDecoder)decoder.struct(CHAIN_FIELD));
        return new PassiveReplicationMessage.ChainReplicationMessage(key, chain, currentTransactionId, oldestTransactionId, clientId);
    }
}

