/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.statistics;

import java.io.Serializable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.ehcache.Cache;
import org.ehcache.Status;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.core.InternalCache;
import org.ehcache.core.events.CacheManagerListener;
import org.ehcache.core.spi.service.CacheManagerProviderService;
import org.ehcache.core.spi.store.InternalCacheManager;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.statistics.CacheStatistics;
import org.ehcache.core.statistics.OperationObserver;
import org.ehcache.core.statistics.StatisticType;
import org.ehcache.core.statistics.ZeroOperationStatistic;
import org.ehcache.management.ExtendedStatisticsService;
import org.ehcache.management.registry.LatencyHistogramConfiguration;
import org.ehcache.management.statistics.DefaultCacheStatistics;
import org.ehcache.management.statistics.DelegatedMappedOperationStatistics;
import org.ehcache.management.statistics.DelegatingOperationObserver;
import org.ehcache.management.statistics.StatsUtils;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.model.capabilities.descriptors.StatisticDescriptor;
import org.terracotta.management.model.stats.Statistic;
import org.terracotta.management.model.stats.StatisticRegistry;
import org.terracotta.statistics.MappedOperationStatistic;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.StatisticBuilder;
import org.terracotta.statistics.StatisticsManager;
import org.terracotta.statistics.derived.OperationResultFilter;
import org.terracotta.statistics.derived.latency.DefaultLatencyHistogramStatistic;
import org.terracotta.statistics.observer.ChainedEventObserver;
import org.terracotta.statistics.observer.ChainedObserver;

@ServiceDependencies(value={CacheManagerProviderService.class})
public class DefaultExtendedStatisticsService
implements ExtendedStatisticsService,
CacheManagerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExtendedStatisticsService.class);
    private final ConcurrentMap<String, DefaultCacheStatistics> cacheStatistics = new ConcurrentHashMap<String, DefaultCacheStatistics>();
    private final ConcurrentMap<String, StatisticRegistry> statisticRegistries = new ConcurrentHashMap<String, StatisticRegistry>();
    private volatile InternalCacheManager cacheManager;
    private volatile boolean started = false;

    public CacheStatistics getCacheStatistics(String cacheName) {
        CacheStatistics stats = (CacheStatistics)this.cacheStatistics.get(cacheName);
        if (stats == null) {
            throw new IllegalArgumentException("Unknown cache: " + cacheName);
        }
        return stats;
    }

    public void registerWithParent(Object toAssociate, Object parent) {
        StatisticsManager.associate((Object)toAssociate).withParent(parent);
    }

    public <K, V, S extends Enum<S>, T extends Enum<T>> org.ehcache.core.statistics.OperationStatistic<T> registerStoreStatistics(Store<K, V> store, String targetName, int tierHeight, String tag, Map<T, Set<S>> translation, String statisticName) {
        Class<S> outcomeType = DefaultExtendedStatisticsService.getOutcomeType(translation);
        if (StatsUtils.hasOperationStat(store, outcomeType, targetName)) {
            MappedOperationStatistic operationStatistic = new MappedOperationStatistic(store, translation, statisticName, tierHeight, targetName, tag);
            StatisticsManager.associate((Object)operationStatistic).withParent(store);
            return new DelegatedMappedOperationStatistics(operationStatistic);
        }
        return ZeroOperationStatistic.get();
    }

    private static <S extends Enum<S>, T extends Enum<T>> Class<S> getOutcomeType(Map<T, Set<S>> translation) {
        Map.Entry<T, Set<S>> first = translation.entrySet().iterator().next();
        return ((Enum)first.getValue().iterator().next()).getDeclaringClass();
    }

    public void deRegisterFromParent(Object toDisassociate, Object parent) {
        StatisticsManager.dissociate((Object)toDisassociate).fromParent(parent);
    }

    public void cleanForNode(Object node) {
        StatisticsManager.nodeFor((Object)node).clean();
    }

    @Override
    public <K, V> void createCacheRegistry(String cacheName, Cache<K, V> cache, LongSupplier timeSource) {
        this.statisticRegistries.put(cacheName, new StatisticRegistry(cache, timeSource));
    }

    @Override
    public void registerCacheStatistics(String cacheName) {
        ((DefaultCacheStatistics)this.cacheStatistics.get(cacheName)).getKnownStatistics().forEach((arg_0, arg_1) -> ((StatisticRegistry)((StatisticRegistry)this.statisticRegistries.get(cacheName))).registerStatistic(arg_0, arg_1));
    }

    @Override
    public Collection<StatisticDescriptor> getCacheDescriptors(String cacheName) {
        return ((StatisticRegistry)this.statisticRegistries.get(cacheName)).getDescriptors();
    }

    @Override
    public <T extends Enum<T>, K, V> void registerDerivedStatistics(String cacheName, Cache<K, V> cache, String statName, T outcome, String derivedName, LatencyHistogramConfiguration configuration) {
        DefaultLatencyHistogramStatistic histogram = new DefaultLatencyHistogramStatistic(configuration.getPhi(), configuration.getBucketCount(), configuration.getWindow());
        Class<?> outcomeClass = outcome.getClass();
        OperationStatistic stat = org.ehcache.core.internal.statistics.StatsUtils.findOperationStatisticOnChildren(cache, outcomeClass, (String)statName);
        stat.addDerivedStatistic((ChainedObserver)new OperationResultFilter(EnumSet.of(outcome), new ChainedEventObserver[]{histogram}));
        ((StatisticRegistry)this.statisticRegistries.get(cacheName)).registerStatistic(derivedName + "#50", histogram.medianStatistic());
        ((StatisticRegistry)this.statisticRegistries.get(cacheName)).registerStatistic(derivedName + "#95", histogram.percentileStatistic(0.95));
        ((StatisticRegistry)this.statisticRegistries.get(cacheName)).registerStatistic(derivedName + "#99", histogram.percentileStatistic(0.99));
        ((StatisticRegistry)this.statisticRegistries.get(cacheName)).registerStatistic(derivedName + "#100", histogram.maximumStatistic());
    }

    @Override
    public Map<String, Statistic<? extends Serializable>> collectStatistics(String cacheName, Collection<String> statisticNames, long since) {
        return StatisticRegistry.collect((StatisticRegistry)((StatisticRegistry)this.statisticRegistries.get(cacheName)), statisticNames, (long)since);
    }

    public <T extends Serializable> void registerStatistic(Object context, String name, StatisticType type, Set<String> tags, Supplier<T> valueSupplier) {
        StatisticsManager.createPassThroughStatistic((Object)context, (String)name, tags, (org.terracotta.statistics.StatisticType)DefaultExtendedStatisticsService.convert(type), valueSupplier);
    }

    public <T extends Enum<T>> OperationObserver<T> createOperationStatistics(String name, Class<T> outcome, String tag, Object context) {
        return new DelegatingOperationObserver(((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(outcome).named(name)).of(context)).tag(new String[]{tag})).build());
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start(ServiceProvider<Service> serviceProvider) {
        LOGGER.debug("Starting service");
        CacheManagerProviderService cacheManagerProviderService = (CacheManagerProviderService)serviceProvider.getService(CacheManagerProviderService.class);
        this.cacheManager = cacheManagerProviderService.getCacheManager();
        this.cacheManager.registerListener((CacheManagerListener)this);
        this.started = true;
    }

    public void stop() {
        LOGGER.debug("Stopping service");
        this.cacheManager.deregisterListener((CacheManagerListener)this);
        this.cacheStatistics.clear();
        this.started = false;
    }

    public void stateTransition(Status from, Status to) {
        LOGGER.debug("Moving from " + from + " to " + to);
        switch (to) {
            case AVAILABLE: {
                this.registerAllCaches();
                break;
            }
            case UNINITIALIZED: {
                this.cacheManager.deregisterListener((CacheManagerListener)this);
                this.cacheStatistics.clear();
                break;
            }
            case MAINTENANCE: {
                throw new IllegalStateException("Should not be started in maintenance mode");
            }
            default: {
                throw new AssertionError((Object)("Unsupported state: " + to));
            }
        }
    }

    private void registerAllCaches() {
        for (Map.Entry entry : this.cacheManager.getRuntimeConfiguration().getCacheConfigurations().entrySet()) {
            String alias = (String)entry.getKey();
            CacheConfiguration configuration = (CacheConfiguration)entry.getValue();
            Cache cache = this.cacheManager.getCache(alias, configuration.getKeyType(), configuration.getValueType());
            this.cacheAdded(alias, cache);
        }
    }

    public void cacheAdded(String alias, Cache<?, ?> cache) {
        LOGGER.debug("Cache added " + alias);
        this.cacheStatistics.put(alias, new DefaultCacheStatistics((InternalCache)cache));
    }

    public void cacheRemoved(String alias, Cache<?, ?> cache) {
        LOGGER.debug("Cache removed " + alias);
        this.cacheStatistics.remove(alias);
    }

    private static org.terracotta.statistics.StatisticType convert(StatisticType type) {
        switch (type) {
            case COUNTER: {
                return org.terracotta.statistics.StatisticType.COUNTER;
            }
            case GAUGE: {
                return org.terracotta.statistics.StatisticType.GAUGE;
            }
        }
        throw new IllegalArgumentException("Untranslatable statistic type : " + type);
    }
}

