/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.registry;

import java.util.ArrayList;
import java.util.Map;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.Status;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.core.events.CacheManagerListener;
import org.ehcache.core.spi.service.CacheManagerProviderService;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.spi.store.InternalCacheManager;
import org.ehcache.core.spi.time.TimeSourceService;
import org.ehcache.management.ManagementRegistryService;
import org.ehcache.management.ManagementRegistryServiceConfiguration;
import org.ehcache.management.cluster.Clustering;
import org.ehcache.management.cluster.ClusteringManagementService;
import org.ehcache.management.cluster.DefaultClusteringManagementServiceConfiguration;
import org.ehcache.management.providers.CacheBinding;
import org.ehcache.management.providers.EhcacheStatisticCollectorProvider;
import org.ehcache.management.providers.actions.EhcacheActionProvider;
import org.ehcache.management.providers.settings.EhcacheSettingsProvider;
import org.ehcache.management.providers.statistics.EhcacheStatisticsProvider;
import org.ehcache.management.registry.DefaultManagementRegistryConfiguration;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.terracotta.management.model.context.ContextContainer;
import org.terracotta.management.registry.DefaultManagementRegistry;
import org.terracotta.management.registry.ManagementProvider;
import org.terracotta.statistics.StatisticsManager;

@ServiceDependencies(value={CacheManagerProviderService.class, StatisticsService.class, TimeSourceService.class})
public class DefaultManagementRegistryService
extends DefaultManagementRegistry
implements ManagementRegistryService,
CacheManagerListener {
    private final ManagementRegistryServiceConfiguration configuration;
    private volatile InternalCacheManager cacheManager;
    private volatile ClusteringManagementService clusteringManagementService;

    public DefaultManagementRegistryService() {
        this(new DefaultManagementRegistryConfiguration());
    }

    public DefaultManagementRegistryService(ManagementRegistryServiceConfiguration configuration) {
        super(null);
        this.configuration = configuration == null ? new DefaultManagementRegistryConfiguration() : configuration;
    }

    public void start(ServiceProvider<Service> serviceProvider) {
        this.cacheManager = ((CacheManagerProviderService)serviceProvider.getService(CacheManagerProviderService.class)).getCacheManager();
        StatisticsService statisticsService = (StatisticsService)serviceProvider.getService(StatisticsService.class);
        TimeSourceService timeSourceService = (TimeSourceService)serviceProvider.getService(TimeSourceService.class);
        this.addManagementProvider((ManagementProvider)new EhcacheActionProvider(this.getConfiguration()));
        this.addManagementProvider((ManagementProvider)new EhcacheStatisticsProvider(this.getConfiguration(), statisticsService, timeSourceService.getTimeSource()));
        this.addManagementProvider((ManagementProvider)new EhcacheStatisticCollectorProvider(this.getConfiguration()));
        this.addManagementProvider((ManagementProvider)new EhcacheSettingsProvider(this.getConfiguration(), (CacheManager)this.cacheManager));
        this.cacheManager.registerListener((CacheManagerListener)this);
        this.clusteringManagementService = (ClusteringManagementService)serviceProvider.getService(ClusteringManagementService.class);
        if (this.clusteringManagementService == null && Clustering.isAvailable(serviceProvider)) {
            this.clusteringManagementService = Clustering.newClusteringManagementService(new DefaultClusteringManagementServiceConfiguration());
            this.clusteringManagementService.start(serviceProvider);
        }
    }

    public void stop() {
        if (this.clusteringManagementService != null) {
            this.clusteringManagementService.stop();
            this.clusteringManagementService = null;
        }
        super.close();
    }

    public void cacheAdded(String alias, Cache<?, ?> cache) {
        StatisticsManager.associate(cache).withParent((Object)this.cacheManager);
        this.register(new CacheBinding(alias, cache));
    }

    public void cacheRemoved(String alias, Cache<?, ?> cache) {
        this.unregister(new CacheBinding(alias, cache));
        StatisticsManager.dissociate(cache).fromParent((Object)this.cacheManager);
    }

    public void stateTransition(Status from, Status to) {
        switch (to) {
            case AVAILABLE: {
                this.register(this.cacheManager);
                for (Map.Entry entry : this.cacheManager.getRuntimeConfiguration().getCacheConfigurations().entrySet()) {
                    String alias = (String)entry.getKey();
                    CacheConfiguration configuration = (CacheConfiguration)entry.getValue();
                    Cache cache = this.cacheManager.getCache(alias, configuration.getKeyType(), configuration.getValueType());
                    this.cacheAdded(alias, cache);
                }
                break;
            }
            case UNINITIALIZED: {
                this.cacheManager.deregisterListener((CacheManagerListener)this);
                break;
            }
            case MAINTENANCE: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported state: " + to));
            }
        }
    }

    @Override
    public ManagementRegistryServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public ContextContainer getContextContainer() {
        ArrayList<ContextContainer> cacheCtx = new ArrayList<ContextContainer>();
        for (String cacheName : this.cacheManager.getRuntimeConfiguration().getCacheConfigurations().keySet()) {
            cacheCtx.add(new ContextContainer("cacheName", cacheName));
        }
        return new ContextContainer("cacheManagerName", this.getConfiguration().getContext().get("cacheManagerName"), cacheCtx);
    }
}

