/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers.statistics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.management.ManagementRegistryServiceConfiguration;
import org.ehcache.management.providers.CacheBinding;
import org.ehcache.management.providers.CacheBindingManagementProvider;
import org.ehcache.management.providers.ExposedCacheBinding;
import org.ehcache.management.providers.statistics.StandardEhcacheStatistics;
import org.terracotta.management.model.capabilities.descriptors.Descriptor;
import org.terracotta.management.model.capabilities.descriptors.StatisticDescriptor;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.registry.ExposedObject;
import org.terracotta.management.registry.Named;
import org.terracotta.management.registry.collect.StatisticProvider;

@Named(value="StatisticsCapability")
@StatisticProvider
public class EhcacheStatisticsProvider
extends CacheBindingManagementProvider {
    private static final Comparator<StatisticDescriptor> STATISTIC_DESCRIPTOR_COMPARATOR = new Comparator<StatisticDescriptor>(){

        @Override
        public int compare(StatisticDescriptor o1, StatisticDescriptor o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private final StatisticsService statisticsService;

    public EhcacheStatisticsProvider(ManagementRegistryServiceConfiguration configuration, StatisticsService statisticsService) {
        super(configuration);
        this.statisticsService = statisticsService;
    }

    @Override
    protected ExposedCacheBinding wrap(CacheBinding cacheBinding) {
        return new StandardEhcacheStatistics(this.registryConfiguration, cacheBinding, this.statisticsService);
    }

    public final Collection<? extends Descriptor> getDescriptors() {
        HashSet<StatisticDescriptor> capabilities = new HashSet<StatisticDescriptor>();
        for (ExposedObject o : this.getExposedObjects()) {
            capabilities.addAll(((StandardEhcacheStatistics)o).getDescriptors());
        }
        ArrayList list = new ArrayList(capabilities);
        Collections.sort(list, STATISTIC_DESCRIPTOR_COMPARATOR);
        return list;
    }

    public Map<String, Number> collectStatistics(Context context, Collection<String> statisticNames) {
        StandardEhcacheStatistics ehcacheStatistics = (StandardEhcacheStatistics)this.findExposedObject(context);
        if (ehcacheStatistics != null) {
            if (statisticNames == null || statisticNames.isEmpty()) {
                return ehcacheStatistics.queryStatistics();
            }
            TreeMap<String, Number> statistics = new TreeMap<String, Number>();
            for (String statisticName : statisticNames) {
                try {
                    statistics.put(statisticName, ehcacheStatistics.queryStatistic(statisticName));
                }
                catch (IllegalArgumentException ignored) {}
            }
            return statistics;
        }
        return Collections.emptyMap();
    }
}

