/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.registry;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.ehcache.management.ManagementRegistryService;
import org.ehcache.management.ManagementRegistryServiceConfiguration;
import org.ehcache.management.config.EhcacheStatisticsProviderConfiguration;
import org.ehcache.management.config.StatisticsProviderConfiguration;
import org.terracotta.management.model.context.Context;
import org.terracotta.management.registry.ManagementProvider;

public class DefaultManagementRegistryConfiguration
implements ManagementRegistryServiceConfiguration {
    private static final AtomicLong COUNTER = new AtomicLong();
    private final Map<Class<? extends ManagementProvider>, StatisticsProviderConfiguration> statisticConfigurations = new HashMap<Class<? extends ManagementProvider>, StatisticsProviderConfiguration>();
    private final Collection<String> tags = new TreeSet<String>();
    private Context context = Context.empty();
    private String statisticsExecutorAlias;
    private String collectorExecutorAlias;

    public DefaultManagementRegistryConfiguration() {
        this.setCacheManagerAlias("cache-manager-" + COUNTER.getAndIncrement());
        this.addConfiguration(new EhcacheStatisticsProviderConfiguration());
    }

    public DefaultManagementRegistryConfiguration setCacheManagerAlias(String alias) {
        return this.setContext(Context.create((String)"cacheManagerName", (String)alias));
    }

    public DefaultManagementRegistryConfiguration setContext(Context context) {
        if (!this.context.contains("cacheManagerName") && !context.contains("cacheManagerName")) {
            throw new IllegalArgumentException("'cacheManagerName' is missing from context");
        }
        this.context = this.context.with((Map)context);
        return this;
    }

    public DefaultManagementRegistryConfiguration setStatisticsExecutorAlias(String alias) {
        this.statisticsExecutorAlias = alias;
        return this;
    }

    public DefaultManagementRegistryConfiguration setCollectorExecutorAlias(String collectorExecutorAlias) {
        this.collectorExecutorAlias = collectorExecutorAlias;
        return this;
    }

    public DefaultManagementRegistryConfiguration addConfiguration(StatisticsProviderConfiguration configuration) {
        Class<? extends ManagementProvider> providerType = configuration.getStatisticsProviderType();
        this.statisticConfigurations.put(providerType, configuration);
        return this;
    }

    public DefaultManagementRegistryConfiguration addTags(String ... tags) {
        this.tags.addAll(Arrays.asList(tags));
        return this;
    }

    public DefaultManagementRegistryConfiguration addTag(String tag) {
        return this.addTags(tag);
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public String getCacheManagerAlias() {
        return this.getContext().get("cacheManagerName");
    }

    @Override
    public String getStatisticsExecutorAlias() {
        return this.statisticsExecutorAlias;
    }

    @Override
    public String getCollectorExecutorAlias() {
        return this.collectorExecutorAlias;
    }

    @Override
    public Collection<String> getTags() {
        return this.tags;
    }

    @Override
    public StatisticsProviderConfiguration getConfigurationFor(Class<? extends ManagementProvider> providerType) {
        return this.statisticConfigurations.get(providerType);
    }

    public Class<ManagementRegistryService> getServiceType() {
        return ManagementRegistryService.class;
    }

    public String toString() {
        return "DefaultManagementRegistryConfiguration{context=" + this.context + ", tags=" + this.tags + ", statisticsExecutorAlias='" + this.statisticsExecutorAlias + '\'' + ", collectorExecutorAlias='" + this.collectorExecutorAlias + '\'' + ", statisticConfigurations=" + this.statisticConfigurations + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultManagementRegistryConfiguration that = (DefaultManagementRegistryConfiguration)o;
        if (!((Object)this.statisticConfigurations).equals(that.statisticConfigurations)) {
            return false;
        }
        if (!((Object)this.tags).equals(that.tags)) {
            return false;
        }
        if (!this.context.equals((Object)that.context)) {
            return false;
        }
        if (this.statisticsExecutorAlias != null ? !this.statisticsExecutorAlias.equals(that.statisticsExecutorAlias) : that.statisticsExecutorAlias != null) {
            return false;
        }
        return this.collectorExecutorAlias != null ? this.collectorExecutorAlias.equals(that.collectorExecutorAlias) : that.collectorExecutorAlias == null;
    }

    public int hashCode() {
        int result = ((Object)this.statisticConfigurations).hashCode();
        result = 31 * result + ((Object)this.tags).hashCode();
        result = 31 * result + this.context.hashCode();
        result = 31 * result + (this.statisticsExecutorAlias != null ? this.statisticsExecutorAlias.hashCode() : 0);
        result = 31 * result + (this.collectorExecutorAlias != null ? this.collectorExecutorAlias.hashCode() : 0);
        return result;
    }
}

