/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers.actions;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.ehcache.management.ManagementRegistryServiceConfiguration;
import org.ehcache.management.providers.CacheBinding;
import org.ehcache.management.providers.ExposedCacheBinding;
import org.terracotta.management.registry.action.Exposed;
import org.terracotta.management.registry.action.Named;

public class EhcacheActionWrapper
extends ExposedCacheBinding {
    EhcacheActionWrapper(ManagementRegistryServiceConfiguration registryServiceConfiguration, CacheBinding cacheBinding) {
        super(registryServiceConfiguration, cacheBinding);
    }

    @Exposed
    public void clear() {
        this.cacheBinding.getCache().clear();
    }

    @Exposed
    public Object get(@Named(value="key") Object key) {
        Object convertedKey = EhcacheActionWrapper.convert(key, this.cacheBinding.getCache().getRuntimeConfiguration().getKeyType());
        return this.cacheBinding.getCache().get(convertedKey);
    }

    @Exposed
    public void remove(@Named(value="key") Object key) {
        Object convertedKey = EhcacheActionWrapper.convert(key, this.cacheBinding.getCache().getRuntimeConfiguration().getKeyType());
        this.cacheBinding.getCache().remove(convertedKey);
    }

    @Exposed
    public void put(@Named(value="key") Object key, @Named(value="value") Object value) {
        Object convertedKey = EhcacheActionWrapper.convert(key, this.cacheBinding.getCache().getRuntimeConfiguration().getKeyType());
        Object convertedValue = EhcacheActionWrapper.convert(value, this.cacheBinding.getCache().getRuntimeConfiguration().getValueType());
        this.cacheBinding.getCache().put(convertedKey, convertedValue);
    }

    private static Object convert(Object srcObj, Class<?> destClazz) {
        if (srcObj == null || destClazz.isInstance(srcObj)) {
            return srcObj;
        }
        try {
            Constructor<?> constructor = destClazz.getConstructor(srcObj.getClass());
            return constructor.newInstance(srcObj);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No conversion possible from " + srcObj.getClass().getName() + " to " + destClazz.getName(), e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Conversion error from " + srcObj.getClass().getName() + " to " + destClazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

