/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers.statistics;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.ehcache.management.config.StatisticsProviderConfiguration;
import org.ehcache.management.providers.CacheBinding;
import org.ehcache.management.providers.statistics.EhcacheStatistics;
import org.terracotta.management.capabilities.Capability;
import org.terracotta.management.capabilities.StatisticsCapability;
import org.terracotta.management.capabilities.descriptors.Descriptor;
import org.terracotta.management.context.Context;
import org.terracotta.management.registry.AbstractManagementProvider;
import org.terracotta.management.registry.action.ExposedObject;
import org.terracotta.management.registry.action.Named;
import org.terracotta.management.registry.action.RequiredContext;
import org.terracotta.management.stats.Statistic;

@Named(value="StatisticsCapability")
@RequiredContext(value={@Named(value="cacheManagerName"), @Named(value="cacheName")})
public class EhcacheStatisticsProvider
extends AbstractManagementProvider<CacheBinding> {
    private final StatisticsProviderConfiguration configuration;
    private final ScheduledExecutorService executor;
    private final Context cmContex;

    public EhcacheStatisticsProvider(Context cmContex, StatisticsProviderConfiguration statisticsProviderConfiguration, ScheduledExecutorService executor) {
        super(CacheBinding.class);
        this.cmContex = cmContex;
        this.configuration = statisticsProviderConfiguration;
        this.executor = executor;
    }

    protected ExposedObject<CacheBinding> wrap(CacheBinding cacheBinding) {
        return new EhcacheStatistics(this.cmContex.with("cacheName", cacheBinding.getAlias()), cacheBinding, this.configuration, this.executor);
    }

    protected void dispose(ExposedObject<CacheBinding> exposedObject) {
        ((EhcacheStatistics)exposedObject).dispose();
    }

    public Capability getCapability() {
        StatisticsCapability.Properties properties = new StatisticsCapability.Properties(this.configuration.averageWindowDuration(), this.configuration.averageWindowUnit(), this.configuration.historySize(), this.configuration.historyInterval(), this.configuration.historyIntervalUnit(), this.configuration.timeToDisable(), this.configuration.timeToDisableUnit());
        return new StatisticsCapability(this.getCapabilityName(), properties, this.getDescriptors(), this.getCapabilityContext());
    }

    public Set<Descriptor> getDescriptors() {
        HashSet<Descriptor> capabilities = new HashSet<Descriptor>();
        for (ExposedObject ehcacheStatistics : this.managedObjects) {
            capabilities.addAll(((EhcacheStatistics)ehcacheStatistics).getDescriptors());
        }
        return capabilities;
    }

    public Map<String, Statistic<?, ?>> collectStatistics(Context context, Collection<String> statisticNames, long since) {
        HashMap statistics = new HashMap(statisticNames.size());
        EhcacheStatistics ehcacheStatistics = (EhcacheStatistics)this.findExposedObject(context);
        if (ehcacheStatistics != null) {
            for (String statisticName : statisticNames) {
                statistics.putAll(ehcacheStatistics.queryStatistic(statisticName, since));
            }
        }
        return statistics;
    }
}

