/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.ehcache.management.ManagementRegistry;
import org.ehcache.management.ManagementRegistryConfiguration;
import org.ehcache.management.config.EhcacheStatisticsProviderConfiguration;
import org.ehcache.management.config.StatisticsProviderConfiguration;
import org.ehcache.management.providers.ManagementProvider;

public class DefaultManagementRegistryConfiguration
implements ManagementRegistryConfiguration {
    private static final AtomicLong COUNTER = new AtomicLong();
    private final Map<Class<? extends ManagementProvider>, StatisticsProviderConfiguration<?>> configurationMap = new HashMap();
    private String cacheManagerAlias = "cache-manager-" + COUNTER.getAndIncrement();
    private String statisticsExecutorAlias;

    public DefaultManagementRegistryConfiguration() {
        this.addConfiguration(new EhcacheStatisticsProviderConfiguration(1L, TimeUnit.MINUTES, 100, 1L, TimeUnit.SECONDS, 30L, TimeUnit.SECONDS));
    }

    public DefaultManagementRegistryConfiguration setCacheManagerAlias(String alias) {
        this.cacheManagerAlias = alias;
        return this;
    }

    public DefaultManagementRegistryConfiguration setStatisticsExecutorAlias(String alias) {
        this.statisticsExecutorAlias = alias;
        return this;
    }

    public DefaultManagementRegistryConfiguration addConfiguration(StatisticsProviderConfiguration<?> configuration) {
        Class<?> serviceType = configuration.getStatisticsProviderType();
        this.configurationMap.put(serviceType, configuration);
        return this;
    }

    @Override
    public String getCacheManagerAlias() {
        return this.cacheManagerAlias;
    }

    @Override
    public String getStatisticsExecutorAlias() {
        return this.statisticsExecutorAlias;
    }

    @Override
    public StatisticsProviderConfiguration getConfigurationFor(Class<? extends ManagementProvider<?>> managementProviderClass) {
        return this.configurationMap.get(managementProviderClass);
    }

    public Class<ManagementRegistry> getServiceType() {
        return ManagementRegistry.class;
    }
}

