/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.ehcache.Cache;
import org.ehcache.EhcacheManager;
import org.ehcache.Status;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.events.CacheManagerListener;
import org.ehcache.internal.executor.ExecutorUtil;
import org.ehcache.management.CapabilityManagement;
import org.ehcache.management.ManagementRegistry;
import org.ehcache.management.ManagementRegistryConfiguration;
import org.ehcache.management.providers.ManagementProvider;
import org.ehcache.management.providers.actions.EhcacheActionProvider;
import org.ehcache.management.providers.statistics.EhcacheStatisticsProvider;
import org.ehcache.management.registry.CacheBinding;
import org.ehcache.management.registry.DefaultCapabilityManagement;
import org.ehcache.management.registry.DefaultManagementRegistryConfiguration;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.service.CacheManagerProviderService;
import org.ehcache.spi.service.ExecutionService;
import org.ehcache.spi.service.ServiceDependencies;
import org.terracotta.management.capabilities.Capability;
import org.terracotta.management.context.ContextContainer;
import org.terracotta.statistics.StatisticsManager;

@ServiceDependencies(value={CacheManagerProviderService.class, ExecutionService.class})
public class DefaultManagementRegistry
implements ManagementRegistry,
CacheManagerListener {
    private final ManagementRegistryConfiguration configuration;
    private final List<ManagementProvider<?>> managementProviders = new CopyOnWriteArrayList();
    private volatile ScheduledExecutorService statisticsExecutor;
    private volatile EhcacheManager cacheManager;

    public DefaultManagementRegistry() {
        this(new DefaultManagementRegistryConfiguration());
    }

    public DefaultManagementRegistry(ManagementRegistryConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException();
        }
        this.configuration = configuration;
    }

    public void start(ServiceProvider serviceProvider) {
        this.statisticsExecutor = ((ExecutionService)serviceProvider.getService(ExecutionService.class)).getScheduledExecutor(this.configuration.getStatisticsExecutorAlias());
        this.cacheManager = ((CacheManagerProviderService)serviceProvider.getService(CacheManagerProviderService.class)).getCacheManager();
        this.cacheManager.registerListener((CacheManagerListener)this);
    }

    public void stop() {
        this.cacheManager.deregisterListener((CacheManagerListener)this);
        for (ManagementProvider<?> managementProvider : this.managementProviders) {
            managementProvider.close();
        }
        this.managementProviders.clear();
        ExecutorUtil.shutdownNow((ExecutorService)this.statisticsExecutor);
        this.cacheManager = null;
    }

    public void cacheAdded(String alias, Cache<?, ?> cache) {
        StatisticsManager.associate(cache).withParent((Object)this.cacheManager);
        this.register(cache);
        this.register(new CacheBinding(alias, cache));
    }

    public void cacheRemoved(String alias, Cache<?, ?> cache) {
        this.unregister(cache);
        this.unregister(new CacheBinding(alias, cache));
        StatisticsManager.dissociate(cache).fromParent((Object)this.cacheManager);
    }

    public void stateTransition(Status from, Status to) {
        if (from == Status.UNINITIALIZED && to == Status.AVAILABLE) {
            this.addManagementProvider(new EhcacheActionProvider(this.getConfiguration().getCacheManagerAlias()));
            this.addManagementProvider(new EhcacheStatisticsProvider(this.getConfiguration().getCacheManagerAlias(), this.getConfiguration().getConfigurationFor(EhcacheStatisticsProvider.class), this.statisticsExecutor));
            this.register(this.cacheManager);
            for (Map.Entry entry : this.cacheManager.getRuntimeConfiguration().getCacheConfigurations().entrySet()) {
                String alias = (String)entry.getKey();
                CacheConfiguration configuration = (CacheConfiguration)entry.getValue();
                Cache cache = this.cacheManager.getCache(alias, configuration.getKeyType(), configuration.getValueType());
                this.cacheAdded(alias, cache);
            }
        }
    }

    @Override
    public ManagementRegistryConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void addManagementProvider(ManagementProvider<?> provider) {
        String name = provider.getCapabilityName();
        for (ManagementProvider<?> managementProvider : this.managementProviders) {
            if (!managementProvider.getCapabilityName().equals(name)) continue;
            throw new IllegalStateException("Duplicated management provider name : " + name);
        }
        this.managementProviders.add(provider);
    }

    @Override
    public void removeManagementProvider(ManagementProvider<?> provider) {
        this.managementProviders.remove(provider);
    }

    @Override
    public void register(Object managedObject) {
        for (ManagementProvider<?> managementProvider : this.managementProviders) {
            if (!managementProvider.managedType().isInstance(managedObject)) continue;
            managementProvider.register(managedObject);
        }
    }

    @Override
    public void unregister(Object managedObject) {
        for (ManagementProvider<?> managementProvider : this.managementProviders) {
            if (!managementProvider.managedType().isInstance(managedObject)) continue;
            managementProvider.unregister(managedObject);
        }
    }

    @Override
    public ContextContainer getContext() {
        ArrayList<ContextContainer> cacheCtx = new ArrayList<ContextContainer>();
        for (String cacheName : this.cacheManager.getRuntimeConfiguration().getCacheConfigurations().keySet()) {
            cacheCtx.add(new ContextContainer("cacheName", cacheName, null));
        }
        return new ContextContainer("cacheManagerName", this.getConfiguration().getCacheManagerAlias(), cacheCtx);
    }

    @Override
    public CapabilityManagement withCapability(String capabilityName) {
        return new DefaultCapabilityManagement(this, capabilityName);
    }

    @Override
    public Collection<Capability> getCapabilities() {
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        for (ManagementProvider<?> managementProvider : this.managementProviders) {
            capabilities.add(managementProvider.getCapability());
        }
        return capabilities;
    }

    public List<ManagementProvider<?>> getManagementProvidersByCapability(String capabilityName) {
        ArrayList allProviders = new ArrayList();
        for (ManagementProvider<?> provider : this.managementProviders) {
            if (!provider.getCapabilityName().equals(capabilityName)) continue;
            allProviders.add(provider);
        }
        return allProviders;
    }
}

