/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers.statistics;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.ehcache.management.annotations.Named;
import org.ehcache.management.config.StatisticsProviderConfiguration;
import org.ehcache.management.providers.CacheBindingManagementProviderSkeleton;
import org.ehcache.management.providers.statistics.EhcacheStatistics;
import org.ehcache.management.registry.CacheBinding;
import org.terracotta.management.capabilities.Capability;
import org.terracotta.management.capabilities.StatisticsCapability;
import org.terracotta.management.capabilities.context.CapabilityContext;
import org.terracotta.management.capabilities.descriptors.Descriptor;
import org.terracotta.management.context.Context;
import org.terracotta.management.stats.Statistic;

@Named(value="StatisticsCapability")
public class EhcacheStatisticsProvider
extends CacheBindingManagementProviderSkeleton<EhcacheStatistics> {
    private final StatisticsProviderConfiguration configuration;
    private final ScheduledExecutorService executor;

    public EhcacheStatisticsProvider(String cacheManagerAlias, StatisticsProviderConfiguration statisticsProviderConfiguration, ScheduledExecutorService executor) {
        super(cacheManagerAlias);
        this.configuration = statisticsProviderConfiguration;
        this.executor = executor;
    }

    @Override
    protected EhcacheStatistics createManagedObject(CacheBinding cacheBinding) {
        return new EhcacheStatistics(cacheBinding.getCache(), this.configuration, this.executor);
    }

    @Override
    protected void close(CacheBinding cacheBinding, EhcacheStatistics managed) {
        managed.dispose();
    }

    @Override
    protected Capability createCapability(String name, CapabilityContext context, Collection<Descriptor> descriptors) {
        StatisticsCapability.Properties properties = new StatisticsCapability.Properties(this.configuration.averageWindowDuration(), this.configuration.averageWindowUnit(), this.configuration.historySize(), this.configuration.historyInterval(), this.configuration.historyIntervalUnit(), this.configuration.timeToDisable(), this.configuration.timeToDisableUnit());
        return new StatisticsCapability(name, properties, descriptors, context);
    }

    public Set<Descriptor> getDescriptors() {
        HashSet<Descriptor> capabilities = new HashSet<Descriptor>();
        for (EhcacheStatistics ehcacheStatistics : this.managedObjects.values()) {
            capabilities.addAll(ehcacheStatistics.getDescriptors());
        }
        return capabilities;
    }

    @Override
    public Map<String, Statistic<?, ?>> collectStatistics(Context context, Collection<String> statisticNames, long since) {
        HashMap statistics = new HashMap(statisticNames.size());
        Map.Entry entry = this.findManagedObject(context);
        if (entry != null) {
            for (String statisticName : statisticNames) {
                statistics.putAll(((EhcacheStatistics)entry.getValue()).queryStatistic(statisticName, since));
            }
        }
        return statistics;
    }
}

