/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers.statistics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.ehcache.Cache;
import org.ehcache.internal.concurrent.ConcurrentHashMap;
import org.ehcache.management.config.StatisticsProviderConfiguration;
import org.ehcache.management.providers.statistics.StandardOperationStatistic;
import org.ehcache.statistics.CacheOperationOutcomes;
import org.terracotta.context.ContextManager;
import org.terracotta.context.TreeNode;
import org.terracotta.context.extended.ExposedStatistic;
import org.terracotta.context.extended.OperationType;
import org.terracotta.context.extended.StatisticsRegistry;
import org.terracotta.context.query.Matcher;
import org.terracotta.context.query.Matchers;
import org.terracotta.context.query.Query;
import org.terracotta.context.query.QueryBuilder;
import org.terracotta.management.capabilities.descriptors.Descriptor;
import org.terracotta.management.capabilities.descriptors.StatisticDescriptor;
import org.terracotta.management.capabilities.descriptors.StatisticDescriptorCategory;
import org.terracotta.management.stats.NumberUnit;
import org.terracotta.management.stats.Sample;
import org.terracotta.management.stats.Statistic;
import org.terracotta.management.stats.StatisticType;
import org.terracotta.management.stats.history.AverageHistory;
import org.terracotta.management.stats.history.CounterHistory;
import org.terracotta.management.stats.history.DurationHistory;
import org.terracotta.management.stats.history.RateHistory;
import org.terracotta.management.stats.history.RatioHistory;
import org.terracotta.management.stats.primitive.Counter;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.archive.Timestamped;
import org.terracotta.statistics.extended.Result;
import org.terracotta.statistics.extended.SampledStatistic;

class EhcacheStatistics {
    private static final Set<CacheOperationOutcomes.PutOutcome> ALL_CACHE_PUT_OUTCOMES = EnumSet.allOf(CacheOperationOutcomes.PutOutcome.class);
    private static final Set<CacheOperationOutcomes.GetOutcome> ALL_CACHE_GET_OUTCOMES = EnumSet.allOf(CacheOperationOutcomes.GetOutcome.class);
    private static final Set<CacheOperationOutcomes.GetOutcome> ALL_CACHE_MISS_OUTCOMES = EnumSet.of(CacheOperationOutcomes.GetOutcome.FAILURE, CacheOperationOutcomes.GetOutcome.MISS_NO_LOADER, CacheOperationOutcomes.GetOutcome.MISS_WITH_LOADER);
    private static final Set<CacheOperationOutcomes.RemoveOutcome> ALL_CACHE_REMOVE_OUTCOMES = EnumSet.allOf(CacheOperationOutcomes.RemoveOutcome.class);
    private static final Set<CacheOperationOutcomes.GetOutcome> GET_WITH_LOADER_OUTCOMES = EnumSet.of(CacheOperationOutcomes.GetOutcome.HIT_WITH_LOADER, CacheOperationOutcomes.GetOutcome.MISS_WITH_LOADER);
    private static final Set<CacheOperationOutcomes.GetOutcome> GET_NO_LOADER_OUTCOMES = EnumSet.of(CacheOperationOutcomes.GetOutcome.HIT_NO_LOADER, CacheOperationOutcomes.GetOutcome.MISS_NO_LOADER);
    private static final Set<CacheOperationOutcomes.CacheLoadingOutcome> ALL_CACHE_LOADER_OUTCOMES = EnumSet.allOf(CacheOperationOutcomes.CacheLoadingOutcome.class);
    private final StatisticsRegistry statisticsRegistry;
    private final Cache<?, ?> contextObject;
    private final ConcurrentMap<String, OperationStatistic<?>> countStatistics;

    EhcacheStatistics(Cache<?, ?> contextObject, StatisticsProviderConfiguration configuration, ScheduledExecutorService executor) {
        this.contextObject = contextObject;
        this.countStatistics = this.discoverCountStatistics();
        this.statisticsRegistry = new StatisticsRegistry(StandardOperationStatistic.class, contextObject, executor, configuration.averageWindowDuration(), configuration.averageWindowUnit(), configuration.historySize(), configuration.historyInterval(), configuration.historyIntervalUnit(), configuration.timeToDisable(), configuration.timeToDisableUnit());
        this.statisticsRegistry.registerCompoundOperation("AllCacheGet", Collections.singleton("cache"), Collections.singletonMap("type", "Result"), (OperationType)StandardOperationStatistic.CACHE_GET, ALL_CACHE_GET_OUTCOMES);
        this.statisticsRegistry.registerCompoundOperation("AllCacheMiss", Collections.singleton("cache"), Collections.singletonMap("type", "Result"), (OperationType)StandardOperationStatistic.CACHE_GET, ALL_CACHE_MISS_OUTCOMES);
        this.statisticsRegistry.registerCompoundOperation("AllCachePut", Collections.singleton("cache"), Collections.singletonMap("type", "Result"), (OperationType)StandardOperationStatistic.CACHE_PUT, ALL_CACHE_PUT_OUTCOMES);
        this.statisticsRegistry.registerCompoundOperation("AllCacheRemove", Collections.singleton("cache"), Collections.singletonMap("type", "Result"), (OperationType)StandardOperationStatistic.CACHE_REMOVE, ALL_CACHE_REMOVE_OUTCOMES);
        this.statisticsRegistry.registerCompoundOperation("GetWithLoader", Collections.singleton("cache"), Collections.singletonMap("type", "Result"), (OperationType)StandardOperationStatistic.CACHE_GET, GET_WITH_LOADER_OUTCOMES);
        this.statisticsRegistry.registerCompoundOperation("GetNoLoader", Collections.singleton("cache"), Collections.singletonMap("type", "Result"), (OperationType)StandardOperationStatistic.CACHE_GET, GET_NO_LOADER_OUTCOMES);
        this.statisticsRegistry.registerCompoundOperation("AllCacheLoader", Collections.singleton("cache"), Collections.singletonMap("type", "Result"), (OperationType)StandardOperationStatistic.CACHE_LOADING, ALL_CACHE_LOADER_OUTCOMES);
        this.statisticsRegistry.registerRatio("Hit", Collections.singleton("cache"), Collections.singletonMap("type", "Ratio"), (OperationType)StandardOperationStatistic.CACHE_GET, EnumSet.of(CacheOperationOutcomes.GetOutcome.HIT_NO_LOADER), ALL_CACHE_GET_OUTCOMES);
    }

    public Map<String, ? extends Statistic<?, ?>> queryStatistic(String statisticName, long since) {
        Collection registrations = this.statisticsRegistry.getRegistrations();
        for (ExposedStatistic registration : registrations) {
            Object type = registration.getProperties().get("type");
            String name = registration.getName();
            if ("Result".equals(type)) {
                Result result = (Result)registration.getStat();
                if ((name + "Count").equals(statisticName)) {
                    SampledStatistic count = result.count();
                    return Collections.singletonMap(statisticName, new CounterHistory(statisticName, this.buildHistory(count, since), NumberUnit.COUNT));
                }
                if ((name + "Rate").equals(statisticName)) {
                    SampledStatistic rate = result.rate();
                    return Collections.singletonMap(statisticName, new RateHistory(statisticName, this.buildHistory(rate, since), TimeUnit.SECONDS));
                }
                if ((name + "LatencyMinimum").equals(statisticName)) {
                    SampledStatistic minimum = result.latency().minimum();
                    return Collections.singletonMap(statisticName, new DurationHistory(statisticName, this.buildHistory(minimum, since), TimeUnit.NANOSECONDS));
                }
                if ((name + "LatencyMaximum").equals(statisticName)) {
                    SampledStatistic maximum = result.latency().maximum();
                    return Collections.singletonMap(statisticName, new DurationHistory(statisticName, this.buildHistory(maximum, since), TimeUnit.NANOSECONDS));
                }
                if ((name + "LatencyAverage").equals(statisticName)) {
                    SampledStatistic average = result.latency().average();
                    return Collections.singletonMap(statisticName, new AverageHistory(statisticName, this.buildHistory(average, since), TimeUnit.NANOSECONDS));
                }
                if (!name.equals(statisticName)) continue;
                HashMap<String, Object> resultStats = new HashMap<String, Object>();
                resultStats.put(statisticName + "Count", new CounterHistory(statisticName + "Count", this.buildHistory(result.count(), since), NumberUnit.COUNT));
                resultStats.put(statisticName + "Rate", new RateHistory(statisticName + "Rate", this.buildHistory(result.rate(), since), TimeUnit.SECONDS));
                resultStats.put(statisticName + "LatencyMinimum", new DurationHistory(statisticName + "LatencyMinimum", this.buildHistory(result.latency().minimum(), since), TimeUnit.NANOSECONDS));
                resultStats.put(statisticName + "LatencyMaximum", new DurationHistory(statisticName + "LatencyMaximum", this.buildHistory(result.latency().maximum(), since), TimeUnit.NANOSECONDS));
                resultStats.put(statisticName + "LatencyAverage", new AverageHistory(statisticName + "LatencyAverage", this.buildHistory(result.latency().average(), since), TimeUnit.NANOSECONDS));
                return resultStats;
            }
            if (!"Ratio".equals(type) || !(name + "Ratio").equals(statisticName)) continue;
            SampledStatistic ratio = (SampledStatistic)registration.getStat();
            return Collections.singletonMap(statisticName, new RatioHistory(statisticName, this.buildHistory(ratio, since), NumberUnit.PERCENT));
        }
        OperationStatistic operationStatistic = (OperationStatistic)this.countStatistics.get(statisticName);
        if (operationStatistic != null) {
            long sum = operationStatistic.sum();
            return Collections.singletonMap(statisticName, new Counter(statisticName, Long.valueOf(sum), NumberUnit.COUNT));
        }
        throw new IllegalArgumentException("Unknown statistic name : " + statisticName);
    }

    private <T extends Number> List<Sample<T>> buildHistory(SampledStatistic<T> sampledStatistic, long since) {
        ArrayList<Sample<T>> result = new ArrayList<Sample<T>>();
        List history = sampledStatistic.history();
        for (Timestamped timestamped : history) {
            if (timestamped.getTimestamp() < since) continue;
            result.add(new Sample(timestamped.getTimestamp(), timestamped.getSample()));
        }
        return result;
    }

    public Set<Descriptor> getDescriptors() {
        HashSet<Descriptor> capabilities = new HashSet<Descriptor>();
        capabilities.addAll(this.queryStatisticsRegistry());
        capabilities.addAll(this.operationStatistics());
        return capabilities;
    }

    private Set<Descriptor> operationStatistics() {
        HashSet<Descriptor> capabilities = new HashSet<Descriptor>();
        for (String name : this.countStatistics.keySet()) {
            capabilities.add((Descriptor)new StatisticDescriptor(name, StatisticType.COUNTER));
        }
        return capabilities;
    }

    private Set<Descriptor> queryStatisticsRegistry() {
        HashSet<Descriptor> capabilities = new HashSet<Descriptor>();
        Collection registrations = this.statisticsRegistry.getRegistrations();
        for (ExposedStatistic registration : registrations) {
            String name = registration.getName();
            Object type = registration.getProperties().get("type");
            if ("Result".equals(type)) {
                ArrayList<StatisticDescriptor> statistics = new ArrayList<StatisticDescriptor>();
                statistics.add(new StatisticDescriptor(name + "Count", StatisticType.COUNTER_HISTORY));
                statistics.add(new StatisticDescriptor(name + "Rate", StatisticType.RATE_HISTORY));
                statistics.add(new StatisticDescriptor(name + "LatencyMinimum", StatisticType.DURATION_HISTORY));
                statistics.add(new StatisticDescriptor(name + "LatencyMaximum", StatisticType.DURATION_HISTORY));
                statistics.add(new StatisticDescriptor(name + "LatencyAverage", StatisticType.AVERAGE_HISTORY));
                capabilities.add((Descriptor)new StatisticDescriptorCategory(name, statistics));
                continue;
            }
            if (!"Ratio".equals(type)) continue;
            capabilities.add((Descriptor)new StatisticDescriptor(name + "Ratio", StatisticType.RATIO_HISTORY));
        }
        return capabilities;
    }

    public void dispose() {
        this.statisticsRegistry.clearRegistrations();
    }

    private ConcurrentMap<String, OperationStatistic<?>> discoverCountStatistics() {
        ConcurrentHashMap result = new ConcurrentHashMap();
        for (StandardOperationStatistic t : (StandardOperationStatistic[])StandardOperationStatistic.class.getEnumConstants()) {
            OperationStatistic statistic = this.findOperationObserver(t);
            if (statistic == null) {
                if (!t.required()) continue;
                throw new IllegalStateException("Required statistic " + (Object)((Object)t) + " not found");
            }
            result.putIfAbsent((Object)(EhcacheStatistics.capitalize(t.operationName()) + "Counter"), (Object)statistic);
        }
        return result;
    }

    private static String capitalize(String s) {
        if (s.length() < 2) {
            return s.toUpperCase();
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private OperationStatistic findOperationObserver(OperationType statistic) {
        Set<OperationStatistic<?>> results = this.findOperationObserver(statistic.context(), statistic.type(), statistic.operationName(), statistic.tags());
        switch (results.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return results.iterator().next();
            }
        }
        throw new IllegalStateException("Duplicate statistics found for " + statistic);
    }

    private Set<OperationStatistic<?>> findOperationObserver(Query contextQuery, Class<?> type, String name, final Set<String> tags) {
        Query q = QueryBuilder.queryBuilder().chain(contextQuery).children().filter(Matchers.context((Matcher)Matchers.identifier((Matcher)Matchers.subclassOf(OperationStatistic.class)))).build();
        Set operationStatisticNodes = q.execute(Collections.singleton(ContextManager.nodeFor(this.contextObject)));
        Set result = QueryBuilder.queryBuilder().filter(Matchers.context((Matcher)Matchers.attributes((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasAttribute((String)"type", type), Matchers.hasAttribute((String)"name", (Object)name), Matchers.hasAttribute((String)"tags", (Matcher)new Matcher<Set<String>>(){

            protected boolean matchesSafely(Set<String> object) {
                return object.containsAll(tags);
            }
        })})))).build().execute(operationStatisticNodes);
        if (result.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet statistics = new HashSet();
        for (TreeNode node : result) {
            statistics.add((OperationStatistic)node.getContext().attributes().get("this"));
        }
        return statistics;
    }
}

