/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers.actions;

import org.ehcache.Cache;
import org.ehcache.management.annotations.Exposed;
import org.ehcache.management.annotations.Named;
import org.ehcache.management.utils.ConversionHelper;

public class EhcacheActionWrapper {
    private final Cache cache;

    public EhcacheActionWrapper(Cache cache) {
        this.cache = cache;
    }

    @Exposed
    public void clear() {
        this.cache.clear();
    }

    @Exposed
    public Object get(@Named(value="key") Object key) {
        Object convertedKey = ConversionHelper.convert(key, this.cache.getRuntimeConfiguration().getKeyType());
        return this.cache.get(convertedKey);
    }

    @Exposed
    public void remove(@Named(value="key") Object key) {
        Object convertedKey = ConversionHelper.convert(key, this.cache.getRuntimeConfiguration().getKeyType());
        this.cache.remove(convertedKey);
    }

    @Exposed
    public void put(@Named(value="key") Object key, @Named(value="value") Object value) {
        Object convertedKey = ConversionHelper.convert(key, this.cache.getRuntimeConfiguration().getKeyType());
        Object convertedValue = ConversionHelper.convert(value, this.cache.getRuntimeConfiguration().getValueType());
        this.cache.put(convertedKey, convertedValue);
    }
}

