/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.ehcache.Ehcache;
import org.ehcache.EhcacheManager;
import org.terracotta.context.ContextManager;
import org.terracotta.context.TreeNode;
import org.terracotta.context.query.Matcher;
import org.terracotta.context.query.Matchers;
import org.terracotta.context.query.Query;
import org.terracotta.context.query.QueryBuilder;

public abstract class ContextHelper {
    private ContextHelper() {
    }

    public static Collection<String> findCacheNames(EhcacheManager ehcacheManager) {
        Query q = QueryBuilder.queryBuilder().descendants().filter(Matchers.context((Matcher)Matchers.attributes((Matcher)Matchers.hasAttribute((String)"CacheName", (Matcher)new Matcher<String>(){

            protected boolean matchesSafely(String object) {
                return true;
            }
        })))).filter(Matchers.context((Matcher)Matchers.attributes((Matcher)Matchers.hasAttribute((String)"tags", (Matcher)new Matcher<Set<String>>(){

            protected boolean matchesSafely(Set<String> object) {
                return object.containsAll(Arrays.asList("cache", "exposed"));
            }
        })))).build();
        Set queryResult = ehcacheManager.getStatisticsManager().query(q);
        ArrayList<String> result = new ArrayList<String>();
        for (TreeNode treeNode : queryResult) {
            String cacheName = (String)treeNode.getContext().attributes().get("CacheName");
            result.add(cacheName);
        }
        return result;
    }

    public static String findCacheName(Ehcache<?, ?> ehcache) {
        Query query = QueryBuilder.queryBuilder().children().filter(Matchers.context((Matcher)Matchers.attributes((Matcher)Matchers.hasAttribute((String)"tags", (Matcher)new Matcher<Set<String>>(){

            protected boolean matchesSafely(Set<String> object) {
                return object.containsAll(Arrays.asList("cache", "exposed"));
            }
        })))).build();
        Set queryResult = query.execute(Collections.singleton(ContextManager.nodeFor(ehcache)));
        if (queryResult.size() != 1) {
            throw new RuntimeException("Cache without name setting : " + ehcache);
        }
        TreeNode treeNode = (TreeNode)queryResult.iterator().next();
        return (String)treeNode.getContext().attributes().get("CacheName");
    }

    public static String findCacheManagerName(EhcacheManager ehcacheManager) {
        Query q = QueryBuilder.queryBuilder().descendants().filter(Matchers.context((Matcher)Matchers.attributes((Matcher)Matchers.hasAttribute((String)"CacheManagerName", (Matcher)new Matcher<String>(){

            protected boolean matchesSafely(String object) {
                return true;
            }
        })))).filter(Matchers.context((Matcher)Matchers.attributes((Matcher)Matchers.hasAttribute((String)"tags", (Matcher)new Matcher<Set<String>>(){

            protected boolean matchesSafely(Set<String> object) {
                return object.containsAll(Arrays.asList("cacheManager", "exposed"));
            }
        })))).build();
        Set queryResult = ehcacheManager.getStatisticsManager().query(q);
        if (queryResult.size() != 1) {
            throw new RuntimeException("Cache manager without name setting : " + ehcacheManager);
        }
        TreeNode treeNode = (TreeNode)queryResult.iterator().next();
        return (String)treeNode.getContext().attributes().get("CacheManagerName");
    }

    public static String findCacheManagerName(Ehcache<?, ?> ehcache) {
        Query query = QueryBuilder.queryBuilder().parent().descendants().filter(Matchers.context((Matcher)Matchers.attributes((Matcher)Matchers.hasAttribute((String)"tags", (Matcher)new Matcher<Set<String>>(){

            protected boolean matchesSafely(Set<String> object) {
                return object.containsAll(Arrays.asList("cacheManager", "exposed"));
            }
        })))).build();
        Set queryResult = query.execute(Collections.singleton(ContextManager.nodeFor(ehcache)));
        if (queryResult.size() != 1) {
            throw new RuntimeException("Cache manager without name setting from cache : " + ehcache);
        }
        TreeNode treeNode = (TreeNode)queryResult.iterator().next();
        return (String)treeNode.getContext().attributes().get("CacheManagerName");
    }
}

