/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ehcache.management.ManagementRegistry;
import org.ehcache.management.config.StatisticsProviderConfiguration;
import org.ehcache.management.providers.CapabilityContextProvider;
import org.ehcache.management.providers.ManagementProvider;
import org.ehcache.management.providers.statistics.EhcacheStatisticsProvider;
import org.ehcache.spi.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.capabilities.ActionsCapability;
import org.terracotta.management.capabilities.StatisticsCapability;
import org.terracotta.management.capabilities.context.CapabilityContext;
import org.terracotta.management.capabilities.descriptors.Descriptor;
import org.terracotta.management.stats.Statistic;

public abstract class AbstractManagementRegistry
implements ManagementRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractManagementRegistry.class);
    private final Map<Class<?>, List<ManagementProvider<?>>> managementProviders = new HashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final CapabilityContextProvider capabilityContextProvider = new CapabilityContextProvider();
    private boolean started = false;

    protected AbstractManagementRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSupportFor(ManagementProvider<?> managementProvider) {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            List<ManagementProvider<?>> managementProviders = this.managementProviders.get(managementProvider.managedType());
            if (managementProviders == null) {
                managementProviders = new ArrayList();
                this.managementProviders.put(managementProvider.managedType(), managementProviders);
            }
            managementProviders.add(managementProvider);
        }
        finally {
            lock.unlock();
        }
    }

    public <T> Collection<T> contexts() {
        return this.capabilityContextProvider.contexts();
    }

    public <T> Collection<T> collectStatistics(Map<String, String> context, String capabilityName, String ... statisticNames) {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            for (List<ManagementProvider<?>> providers : this.managementProviders.values()) {
                for (ManagementProvider<?> provider : providers) {
                    if (!provider.getClass().getName().equals(capabilityName)) continue;
                    Collection<Statistic<?>> collection = provider.collectStatistics(context, statisticNames);
                    return collection;
                }
            }
            throw new IllegalArgumentException("No such capability registered : " + capabilityName);
        }
        finally {
            lock.unlock();
        }
    }

    public <T> T callAction(Map<String, String> context, String capabilityName, String methodName, String[] argClassNames, Object[] args) {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            for (List<ManagementProvider<?>> providers : this.managementProviders.values()) {
                for (ManagementProvider<?> provider : providers) {
                    if (!provider.getClass().getName().equals(capabilityName)) continue;
                    Object object = provider.callAction(context, methodName, argClassNames, args);
                    return (T)object;
                }
            }
            throw new IllegalArgumentException("No such capability registered : " + capabilityName);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void register(Class<T> managedType, T managedObject) {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            if (!this.started) {
                throw new IllegalStateException("Management registry not started");
            }
            List<ManagementProvider<?>> managementProviders = this.managementProviders.get(managedType);
            if (managementProviders == null) {
                LOGGER.warn("No registered management provider that supports {}", managedType);
                return;
            }
            Iterator<ManagementProvider<?>> i$ = managementProviders.iterator();
            while (i$.hasNext()) {
                ManagementProvider<?> managementProvider;
                ManagementProvider<?> typedManagementProvider = managementProvider = i$.next();
                typedManagementProvider.register(managedObject);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void unregister(Class<T> managedType, T managedObject) {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            if (!this.started) {
                throw new IllegalStateException("Management registry not started");
            }
            List<ManagementProvider<?>> managementProviders = this.managementProviders.get(managedType);
            if (managementProviders == null) {
                LOGGER.warn("No registered management provider that supports {}", managedType);
                return;
            }
            Iterator<ManagementProvider<?>> i$ = managementProviders.iterator();
            while (i$.hasNext()) {
                ManagementProvider<?> managementProvider;
                ManagementProvider<?> typedManagementProvider = managementProvider = i$.next();
                typedManagementProvider.unregister(managedObject);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Collection<T> capabilities() {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Map.Entry<Class<?>, List<ManagementProvider<?>>> entry : this.managementProviders.entrySet()) {
                List<ManagementProvider<?>> managementProviders = entry.getValue();
                for (ManagementProvider<?> managementProvider : managementProviders) {
                    CapabilityContext context;
                    String name;
                    Set<Descriptor> descriptors;
                    if (managementProvider.descriptions().isEmpty()) continue;
                    if (managementProvider instanceof EhcacheStatisticsProvider) {
                        descriptors = managementProvider.descriptions();
                        name = managementProvider.getClass().getName();
                        context = managementProvider.capabilityContext();
                        EhcacheStatisticsProvider ehcacheStatisticsProvider = (EhcacheStatisticsProvider)managementProvider;
                        StatisticsProviderConfiguration configuration = ehcacheStatisticsProvider.getConfiguration();
                        StatisticsCapability.Properties properties = new StatisticsCapability.Properties(configuration.averageWindowDuration(), configuration.averageWindowUnit(), configuration.historySize(), configuration.historyInterval(), configuration.historyIntervalUnit(), configuration.timeToDisable(), configuration.timeToDisableUnit());
                        StatisticsCapability statisticsCapability = new StatisticsCapability(name, properties, descriptors, context);
                        result.add(statisticsCapability);
                        continue;
                    }
                    descriptors = managementProvider.descriptions();
                    name = managementProvider.getClass().getName();
                    context = managementProvider.capabilityContext();
                    ActionsCapability actionsCapability = new ActionsCapability(name, descriptors, context);
                    result.add(actionsCapability);
                }
            }
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ServiceProvider serviceProvider) {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            this.addSupportFor(this.capabilityContextProvider);
            this.started = true;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            this.managementProviders.clear();
            this.started = false;
        }
        finally {
            lock.unlock();
        }
    }
}

