/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.management.providers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.ehcache.management.annotations.Exposed;
import org.ehcache.management.annotations.Named;
import org.ehcache.management.providers.ManagementProvider;
import org.ehcache.util.ConcurrentWeakIdentityHashMap;
import org.terracotta.management.capabilities.descriptors.CallDescriptor;
import org.terracotta.management.capabilities.descriptors.Descriptor;
import org.terracotta.management.stats.Statistic;

public abstract class AbstractActionProvider<T, A>
implements ManagementProvider<T> {
    protected final ConcurrentMap<T, A> actions = new ConcurrentWeakIdentityHashMap();

    @Override
    public final void register(T contextObject) {
        this.actions.putIfAbsent(contextObject, this.createActionWrapper(contextObject));
    }

    protected abstract A createActionWrapper(T var1);

    @Override
    public final void unregister(T contextObject) {
        this.actions.remove(contextObject);
    }

    @Override
    public final Set<Descriptor> descriptions() {
        return this.listManagementCapabilities();
    }

    private Set<Descriptor> listManagementCapabilities() {
        HashSet<Descriptor> capabilities = new HashSet<Descriptor>();
        Collection actions = this.actions.values();
        for (Object action : actions) {
            Method[] methods;
            Class<?> actionClass = action.getClass();
            for (Method method : methods = actionClass.getMethods()) {
                Annotation[] declaredAnnotations = method.getDeclaredAnnotations();
                boolean expose = false;
                for (Annotation declaredAnnotation : declaredAnnotations) {
                    if (declaredAnnotation.annotationType() != Exposed.class) continue;
                    expose = true;
                    break;
                }
                if (!expose) continue;
                String methodName = method.getName();
                Class<?> returnType = method.getReturnType();
                Class<?>[] parameterTypes = method.getParameterTypes();
                ArrayList<String> parameterNames = new ArrayList<String>();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Annotation[] parameterAnnotations = method.getParameterAnnotations()[i];
                    boolean named = false;
                    for (Annotation parameterAnnotation : parameterAnnotations) {
                        if (!(parameterAnnotation instanceof Named)) continue;
                        Named namedAnnotation = (Named)parameterAnnotation;
                        parameterNames.add(namedAnnotation.value());
                        named = true;
                        break;
                    }
                    if (named) continue;
                    parameterNames.add("arg" + i);
                }
                ArrayList<CallDescriptor.Parameter> parameters = new ArrayList<CallDescriptor.Parameter>();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    parameters.add(new CallDescriptor.Parameter((String)parameterNames.get(i), parameterTypes[i].getName()));
                }
                capabilities.add((Descriptor)new CallDescriptor(methodName, returnType.getName(), parameters));
            }
        }
        return capabilities;
    }

    @Override
    public final Collection<Statistic<?>> collectStatistics(Map<String, String> context, String[] statisticNames) {
        throw new UnsupportedOperationException("Not a statistics provider : " + this.getClass().getName());
    }
}

