/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.events;

import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;
import org.ehcache.core.events.StoreEventDispatcher;
import org.ehcache.core.events.StoreEventSink;
import org.ehcache.core.spi.store.events.StoreEventFilter;
import org.ehcache.core.spi.store.events.StoreEventListener;
import org.ehcache.impl.internal.events.CloseableStoreEventSink;
import org.ehcache.impl.internal.events.FireableStoreEventHolder;
import org.ehcache.impl.internal.events.InvocationScopedEventSink;

public abstract class AbstractStoreEventDispatcher<K, V>
implements StoreEventDispatcher<K, V> {
    protected static final StoreEventSink<?, ?> NO_OP_EVENT_SINK = new CloseableStoreEventSink<Object, Object>(){

        @Override
        public void close() {
        }

        @Override
        public void closeOnFailure() {
        }

        @Override
        public void reset() {
        }

        public void removed(Object key, Supplier<Object> value) {
        }

        public void updated(Object key, Supplier<Object> oldValue, Object newValue) {
        }

        public void expired(Object key, Supplier<Object> value) {
        }

        public void created(Object key, Object value) {
        }

        public void evicted(Object key, Supplier<Object> value) {
        }
    };
    private final Set<StoreEventFilter<K, V>> filters = new CopyOnWriteArraySet<StoreEventFilter<K, V>>();
    private final Set<StoreEventListener<K, V>> listeners = new CopyOnWriteArraySet<StoreEventListener<K, V>>();
    private final BlockingQueue<FireableStoreEventHolder<K, V>>[] orderedQueues;
    private volatile boolean ordered = false;

    protected AbstractStoreEventDispatcher(int dispatcherConcurrency) {
        if (dispatcherConcurrency <= 0) {
            throw new IllegalArgumentException("Dispatcher concurrency must be an integer greater than 0");
        }
        LinkedBlockingQueue[] queues = new LinkedBlockingQueue[dispatcherConcurrency];
        this.orderedQueues = queues;
        for (int i = 0; i < this.orderedQueues.length; ++i) {
            this.orderedQueues[i] = new LinkedBlockingQueue<FireableStoreEventHolder<K, V>>(10000);
        }
    }

    protected Set<StoreEventListener<K, V>> getListeners() {
        return this.listeners;
    }

    protected Set<StoreEventFilter<K, V>> getFilters() {
        return this.filters;
    }

    protected BlockingQueue<FireableStoreEventHolder<K, V>>[] getOrderedQueues() {
        return this.orderedQueues;
    }

    public void addEventListener(StoreEventListener<K, V> eventListener) {
        this.listeners.add(eventListener);
    }

    public void removeEventListener(StoreEventListener<K, V> eventListener) {
        this.listeners.remove(eventListener);
    }

    public void addEventFilter(StoreEventFilter<K, V> eventFilter) {
        this.filters.add(eventFilter);
    }

    public void setEventOrdering(boolean ordering) {
        this.ordered = ordering;
    }

    public void setSynchronous(boolean synchronous) throws IllegalArgumentException {
    }

    public boolean isEventOrdering() {
        return this.ordered;
    }

    public void releaseEventSink(StoreEventSink<K, V> eventSink) {
        ((CloseableStoreEventSink)eventSink).close();
    }

    public void releaseEventSinkAfterFailure(StoreEventSink<K, V> eventSink, Throwable throwable) {
        ((CloseableStoreEventSink)eventSink).closeOnFailure();
    }

    public void reset(StoreEventSink<K, V> eventSink) {
        ((CloseableStoreEventSink)eventSink).reset();
    }

    public StoreEventSink<K, V> eventSink() {
        return new InvocationScopedEventSink<K, V>(this.getFilters(), this.isEventOrdering(), this.getOrderedQueues(), this.getListeners());
    }
}

