/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.persistence;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import org.ehcache.CachePersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.utilities.io.Files;

final class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);
    private static final int DEL = 127;
    private static final char ESCAPE = '%';
    private static final Set<Character> ILLEGALS = new HashSet<Character>();

    FileUtils() {
    }

    static void createLocationIfRequiredAndVerify(File rootDirectory) {
        if (!rootDirectory.exists()) {
            if (!rootDirectory.mkdirs()) {
                throw new IllegalArgumentException("Directory couldn't be created: " + rootDirectory.getAbsolutePath());
            }
        } else if (!rootDirectory.isDirectory()) {
            throw new IllegalArgumentException("Location is not a directory: " + rootDirectory.getAbsolutePath());
        }
        if (!rootDirectory.canWrite()) {
            throw new IllegalArgumentException("Location isn't writable: " + rootDirectory.getAbsolutePath());
        }
    }

    static File createSubDirectory(File mainDirectory, String name) throws CachePersistenceException {
        FileUtils.validateName(name);
        File subDirectory = new File(mainDirectory, name);
        FileUtils.create(subDirectory);
        return subDirectory;
    }

    static void validateName(String name) {
        if (!name.matches("[a-zA-Z0-9\\-_]+")) {
            throw new IllegalArgumentException("Name is invalid for persistence context: " + name);
        }
    }

    static void create(File directory) throws CachePersistenceException {
        if (directory.isDirectory()) {
            LOGGER.debug("Reusing {}", (Object)directory.getAbsolutePath());
        } else if (directory.mkdir()) {
            LOGGER.debug("Created {}", (Object)directory.getAbsolutePath());
        } else if (directory.isDirectory()) {
            LOGGER.debug("Reusing {}", (Object)directory.getAbsolutePath());
        } else {
            throw new CachePersistenceException("Unable to create or reuse directory: " + directory.getAbsolutePath());
        }
    }

    static boolean tryRecursiveDelete(File file) {
        try {
            Files.deleteTree((Path)file.toPath(), (Duration)Duration.ofMillis(250L), FileUtils::gc);
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    @SuppressFBWarnings(value={"DM_GC"})
    private static void gc() {
        System.gc();
        System.runFinalization();
    }

    static String safeIdentifier(String name) {
        return FileUtils.safeIdentifier(name, true);
    }

    static String safeIdentifier(String name, boolean withSha1) {
        int len = name.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c <= ' ' || c >= '\u007f' || ILLEGALS.contains(Character.valueOf(c)) || c == '%') {
                sb.append('%');
                sb.append(String.format("%04x", c));
                continue;
            }
            sb.append(c);
        }
        if (withSha1) {
            sb.append("_").append(FileUtils.sha1(name));
        }
        return sb.toString();
    }

    private static String sha1(String input) {
        StringBuilder sb = new StringBuilder();
        for (byte b : FileUtils.getSha1Digest().digest(input.getBytes(StandardCharsets.UTF_8))) {
            sb.append(Integer.toHexString((b & 0xF0) >>> 4));
            sb.append(Integer.toHexString(b & 0xF));
        }
        return sb.toString();
    }

    private static MessageDigest getSha1Digest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"All JDKs must have SHA-1");
        }
    }

    static {
        ILLEGALS.add(Character.valueOf('/'));
        ILLEGALS.add(Character.valueOf('\\'));
        ILLEGALS.add(Character.valueOf('<'));
        ILLEGALS.add(Character.valueOf('>'));
        ILLEGALS.add(Character.valueOf(':'));
        ILLEGALS.add(Character.valueOf('\"'));
        ILLEGALS.add(Character.valueOf('|'));
        ILLEGALS.add(Character.valueOf('?'));
        ILLEGALS.add(Character.valueOf('*'));
        ILLEGALS.add(Character.valueOf('.'));
    }
}

