/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.store;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.ehcache.config.ResourceType;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.statistics.OperationObserver;
import org.ehcache.core.statistics.OperationStatistic;
import org.ehcache.core.statistics.ZeroOperationStatistic;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.terracotta.management.model.stats.StatisticType;

public abstract class BaseStore<K, V>
implements Store<K, V> {
    protected final Class<K> keyType;
    protected final Class<V> valueType;
    protected final boolean operationStatisticsEnabled;
    protected final StatisticsService statisticsService;

    public BaseStore(Store.Configuration<K, V> config, StatisticsService statisticsService) {
        this(config.getKeyType(), config.getValueType(), config.isOperationStatisticsEnabled(), statisticsService);
    }

    public BaseStore(Class<K> keyType, Class<V> valueType, boolean operationStatisticsEnabled, StatisticsService statisticsService) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.operationStatisticsEnabled = operationStatisticsEnabled;
        this.statisticsService = statisticsService;
    }

    protected void checkKey(K keyObject) {
        if (!this.keyType.isInstance(Objects.requireNonNull(keyObject))) {
            throw new ClassCastException("Invalid key type, expected : " + this.keyType.getName() + " but was : " + keyObject.getClass().getName());
        }
    }

    protected void checkValue(V valueObject) {
        if (!this.valueType.isInstance(Objects.requireNonNull(valueObject))) {
            throw new ClassCastException("Invalid value type, expected : " + this.valueType.getName() + " but was : " + valueObject.getClass().getName());
        }
    }

    protected <T extends Enum<T>> OperationObserver<T> createObserver(String name, Class<T> outcome, boolean canBeDisabled) {
        if (!this.operationStatisticsEnabled && canBeDisabled) {
            return ZeroOperationStatistic.get();
        }
        return this.statisticsService.createOperationStatistics(name, outcome, this.getStatisticsTag(), (Object)this);
    }

    protected <T extends Serializable> void registerStatistic(String name, StatisticType type, Set<String> tags, Supplier<T> valueSupplier) {
        this.statisticsService.registerStatistic((Object)this, name, type, tags, valueSupplier);
    }

    protected abstract String getStatisticsTag();

    @ServiceDependencies(value={StatisticsService.class})
    protected static abstract class BaseStoreProvider
    implements Store.Provider {
        private volatile ServiceProvider<Service> serviceProvider;

        protected BaseStoreProvider() {
        }

        protected <K, V, S extends Enum<S>, T extends Enum<T>> OperationStatistic<T> createTranslatedStatistic(BaseStore<K, V> store, String statisticName, Map<T, Set<S>> translation, String targetName) {
            StatisticsService statisticsService = (StatisticsService)this.serviceProvider.getService(StatisticsService.class);
            return statisticsService.registerStoreStatistics(store, targetName, this.getResourceType().getTierHeight(), store.getStatisticsTag(), translation, statisticName);
        }

        public void start(ServiceProvider<Service> serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        public void stop() {
            this.serviceProvider = null;
        }

        protected ServiceProvider<Service> getServiceProvider() {
            return this.serviceProvider;
        }

        protected abstract ResourceType<?> getResourceType();
    }
}

