/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.offheap;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.ehcache.Cache;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.core.config.ExpiryUtils;
import org.ehcache.core.events.StoreEventDispatcher;
import org.ehcache.core.events.StoreEventSink;
import org.ehcache.core.exceptions.StorePassThroughException;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.events.StoreEventSource;
import org.ehcache.core.spi.store.tiering.AuthoritativeTier;
import org.ehcache.core.spi.store.tiering.CachingTier;
import org.ehcache.core.spi.store.tiering.LowerCachingTier;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.statistics.AuthoritativeTierOperationOutcomes;
import org.ehcache.core.statistics.LowerCachingTierOperationsOutcome;
import org.ehcache.core.statistics.StoreOperationOutcomes;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.impl.internal.store.BinaryValueHolder;
import org.ehcache.impl.internal.store.basic.BaseStore;
import org.ehcache.impl.internal.store.offheap.BasicOffHeapValueHolder;
import org.ehcache.impl.internal.store.offheap.BinaryOffHeapValueHolder;
import org.ehcache.impl.internal.store.offheap.EhcacheOffHeapBackingMap;
import org.ehcache.impl.internal.store.offheap.OffHeapMapStatistics;
import org.ehcache.impl.internal.store.offheap.OffHeapValueHolder;
import org.ehcache.impl.internal.store.offheap.SwitchableEvictionAdvisor;
import org.ehcache.impl.internal.store.offheap.factories.EhcacheSegmentFactory;
import org.ehcache.impl.store.HashUtils;
import org.ehcache.spi.resilience.StoreAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.offheapstore.exceptions.OversizeMappingException;
import org.terracotta.statistics.StatisticType;
import org.terracotta.statistics.StatisticsManager;
import org.terracotta.statistics.observer.OperationObserver;

public abstract class AbstractOffHeapStore<K, V>
extends BaseStore<K, V>
implements AuthoritativeTier<K, V>,
LowerCachingTier<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOffHeapStore.class);
    private static final CachingTier.InvalidationListener<?, ?> NULL_INVALIDATION_LISTENER = (key, valueHolder) -> {};
    private final TimeSource timeSource;
    private final StoreEventDispatcher<K, V> eventDispatcher;
    private final ExpiryPolicy<? super K, ? super V> expiry;
    private final OperationObserver<StoreOperationOutcomes.GetOutcome> getObserver;
    private final OperationObserver<StoreOperationOutcomes.PutOutcome> putObserver;
    private final OperationObserver<StoreOperationOutcomes.PutIfAbsentOutcome> putIfAbsentObserver;
    private final OperationObserver<StoreOperationOutcomes.RemoveOutcome> removeObserver;
    private final OperationObserver<StoreOperationOutcomes.ConditionalRemoveOutcome> conditionalRemoveObserver;
    private final OperationObserver<StoreOperationOutcomes.ReplaceOutcome> replaceObserver;
    private final OperationObserver<StoreOperationOutcomes.ConditionalReplaceOutcome> conditionalReplaceObserver;
    private final OperationObserver<StoreOperationOutcomes.ComputeOutcome> computeObserver;
    private final OperationObserver<StoreOperationOutcomes.ComputeIfAbsentOutcome> computeIfAbsentObserver;
    private final OperationObserver<StoreOperationOutcomes.EvictionOutcome> evictionObserver;
    private final OperationObserver<StoreOperationOutcomes.ExpirationOutcome> expirationObserver;
    private final OperationObserver<AuthoritativeTierOperationOutcomes.GetAndFaultOutcome> getAndFaultObserver;
    private final OperationObserver<AuthoritativeTierOperationOutcomes.ComputeIfAbsentAndFaultOutcome> computeIfAbsentAndFaultObserver;
    private final OperationObserver<AuthoritativeTierOperationOutcomes.FlushOutcome> flushObserver;
    private final OperationObserver<LowerCachingTierOperationsOutcome.InvalidateOutcome> invalidateObserver;
    private final OperationObserver<LowerCachingTierOperationsOutcome.InvalidateAllOutcome> invalidateAllObserver;
    private final OperationObserver<LowerCachingTierOperationsOutcome.InvalidateAllWithHashOutcome> invalidateAllWithHashObserver;
    private final OperationObserver<LowerCachingTierOperationsOutcome.GetAndRemoveOutcome> getAndRemoveObserver;
    private final OperationObserver<LowerCachingTierOperationsOutcome.InstallMappingOutcome> installMappingObserver;
    private volatile AuthoritativeTier.InvalidationValve valve;
    protected final BackingMapEvictionListener<K, V> mapEvictionListener;
    private volatile CachingTier.InvalidationListener<K, V> invalidationListener = NULL_INVALIDATION_LISTENER;
    private static final Supplier<Boolean> REPLACE_EQUALS_TRUE = () -> Boolean.TRUE;

    public AbstractOffHeapStore(Store.Configuration<K, V> config, TimeSource timeSource, StoreEventDispatcher<K, V> eventDispatcher) {
        super(config);
        this.expiry = config.getExpiry();
        this.timeSource = timeSource;
        this.eventDispatcher = eventDispatcher;
        this.getObserver = this.createObserver("get", StoreOperationOutcomes.GetOutcome.class, true);
        this.putObserver = this.createObserver("put", StoreOperationOutcomes.PutOutcome.class, true);
        this.putIfAbsentObserver = this.createObserver("putIfAbsent", StoreOperationOutcomes.PutIfAbsentOutcome.class, true);
        this.removeObserver = this.createObserver("remove", StoreOperationOutcomes.RemoveOutcome.class, true);
        this.conditionalRemoveObserver = this.createObserver("conditionalRemove", StoreOperationOutcomes.ConditionalRemoveOutcome.class, true);
        this.replaceObserver = this.createObserver("replace", StoreOperationOutcomes.ReplaceOutcome.class, true);
        this.conditionalReplaceObserver = this.createObserver("conditionalReplace", StoreOperationOutcomes.ConditionalReplaceOutcome.class, true);
        this.computeObserver = this.createObserver("compute", StoreOperationOutcomes.ComputeOutcome.class, true);
        this.computeIfAbsentObserver = this.createObserver("computeIfAbsent", StoreOperationOutcomes.ComputeIfAbsentOutcome.class, true);
        this.evictionObserver = this.createObserver("eviction", StoreOperationOutcomes.EvictionOutcome.class, false);
        this.expirationObserver = this.createObserver("expiration", StoreOperationOutcomes.ExpirationOutcome.class, false);
        this.getAndFaultObserver = this.createObserver("getAndFault", AuthoritativeTierOperationOutcomes.GetAndFaultOutcome.class, true);
        this.computeIfAbsentAndFaultObserver = this.createObserver("computeIfAbsentAndFault", AuthoritativeTierOperationOutcomes.ComputeIfAbsentAndFaultOutcome.class, true);
        this.flushObserver = this.createObserver("flush", AuthoritativeTierOperationOutcomes.FlushOutcome.class, true);
        this.invalidateObserver = this.createObserver("invalidate", LowerCachingTierOperationsOutcome.InvalidateOutcome.class, true);
        this.invalidateAllObserver = this.createObserver("invalidateAll", LowerCachingTierOperationsOutcome.InvalidateAllOutcome.class, true);
        this.invalidateAllWithHashObserver = this.createObserver("invalidateAllWithHash", LowerCachingTierOperationsOutcome.InvalidateAllWithHashOutcome.class, true);
        this.getAndRemoveObserver = this.createObserver("getAndRemove", LowerCachingTierOperationsOutcome.GetAndRemoveOutcome.class, true);
        this.installMappingObserver = this.createObserver("installMapping", LowerCachingTierOperationsOutcome.InstallMappingOutcome.class, true);
        Set tags = StatisticsManager.tags((String[])new String[]{this.getStatisticsTag(), "tier"});
        this.registerStatistic("allocatedMemory", StatisticType.GAUGE, (Set<String>)tags, OffHeapMapStatistics::allocatedMemory);
        this.registerStatistic("occupiedMemory", StatisticType.GAUGE, (Set<String>)tags, OffHeapMapStatistics::occupiedMemory);
        this.registerStatistic("dataAllocatedMemory", StatisticType.GAUGE, (Set<String>)tags, OffHeapMapStatistics::dataAllocatedMemory);
        this.registerStatistic("dataOccupiedMemory", StatisticType.GAUGE, (Set<String>)tags, OffHeapMapStatistics::dataOccupiedMemory);
        this.registerStatistic("dataSize", StatisticType.GAUGE, (Set<String>)tags, OffHeapMapStatistics::dataSize);
        this.registerStatistic("dataVitalMemory", StatisticType.GAUGE, (Set<String>)tags, OffHeapMapStatistics::dataVitalMemory);
        this.registerStatistic("mappings", StatisticType.GAUGE, (Set<String>)tags, OffHeapMapStatistics::longSize);
        this.registerStatistic("vitalMemory", StatisticType.GAUGE, (Set<String>)tags, OffHeapMapStatistics::vitalMemory);
        this.registerStatistic("removedSlotCount", StatisticType.GAUGE, (Set<String>)tags, OffHeapMapStatistics::removedSlotCount);
        this.registerStatistic("usedSlotCount", StatisticType.GAUGE, (Set<String>)tags, OffHeapMapStatistics::usedSlotCount);
        this.registerStatistic("tableCapacity", StatisticType.GAUGE, (Set<String>)tags, OffHeapMapStatistics::tableCapacity);
        this.mapEvictionListener = new BackingMapEvictionListener(eventDispatcher, this.evictionObserver);
    }

    private <T extends Serializable> void registerStatistic(String name, StatisticType type, Set<String> tags, Function<EhcacheOffHeapBackingMap<K, OffHeapValueHolder<V>>, T> fn) {
        this.registerStatistic(name, type, tags, () -> {
            EhcacheOffHeapBackingMap<K, OffHeapValueHolder<V>> map = this.backingMap();
            return map == null ? null : (Serializable)fn.apply(map);
        });
    }

    public Store.ValueHolder<V> get(K key) throws StoreAccessException {
        this.checkKey(key);
        this.getObserver.begin();
        Store.ValueHolder<V> result = this.internalGet(key, true, true);
        if (result == null) {
            this.getObserver.end((Enum)StoreOperationOutcomes.GetOutcome.MISS);
        } else {
            this.getObserver.end((Enum)StoreOperationOutcomes.GetOutcome.HIT);
        }
        return result;
    }

    private Store.ValueHolder<V> internalGet(K key, boolean updateAccess, boolean touchValue) throws StoreAccessException {
        StoreEventSink eventSink = this.eventDispatcher.eventSink();
        AtomicReference heldValue = new AtomicReference();
        try {
            OffHeapValueHolder result = this.backingMap().computeIfPresent(key, (mappedKey, mappedValue) -> {
                long now = this.timeSource.getTimeMillis();
                if (mappedValue.isExpired(now)) {
                    this.onExpiration((K)mappedKey, (Store.ValueHolder<V>)mappedValue, (StoreEventSink<K, V>)eventSink);
                    return null;
                }
                if (updateAccess) {
                    mappedValue.forceDeserialization();
                    OffHeapValueHolder<V> valueHolder = this.setAccessTimeAndExpiryThenReturnMapping((K)mappedKey, (OffHeapValueHolder<V>)((Object)mappedValue), now, (StoreEventSink<K, V>)eventSink);
                    if (valueHolder == null) {
                        heldValue.set(mappedValue);
                    }
                    return valueHolder;
                }
                if (touchValue) {
                    mappedValue.forceDeserialization();
                }
                return mappedValue;
            });
            if (result == null && heldValue.get() != null) {
                result = (OffHeapValueHolder)((Object)heldValue.get());
            }
            this.eventDispatcher.releaseEventSink(eventSink);
            return result;
        }
        catch (RuntimeException re) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    public boolean containsKey(K key) throws StoreAccessException {
        this.checkKey(key);
        return this.internalGet(key, false, false) != null;
    }

    public Store.PutStatus put(K key, V value) throws StoreAccessException {
        this.checkKey(key);
        this.checkValue(value);
        this.putObserver.begin();
        AtomicBoolean put = new AtomicBoolean();
        StoreEventSink eventSink = this.eventDispatcher.eventSink();
        long now = this.timeSource.getTimeMillis();
        try {
            BiFunction<Object, OffHeapValueHolder, OffHeapValueHolder> mappingFunction = (mappedKey, mappedValue) -> {
                if (mappedValue != null && mappedValue.isExpired(now)) {
                    mappedValue = null;
                }
                if (mappedValue == null) {
                    OffHeapValueHolder<Object> newValue = this.newCreateValueHolder(key, value, now, eventSink);
                    put.set(newValue != null);
                    return newValue;
                }
                OffHeapValueHolder<Object> newValue = this.newUpdatedValueHolder(key, value, (OffHeapValueHolder<V>)((Object)mappedValue), now, (StoreEventSink<K, V>)eventSink);
                put.set(true);
                return newValue;
            };
            this.computeWithRetry(key, mappingFunction, false);
            this.eventDispatcher.releaseEventSink(eventSink);
            if (put.get()) {
                this.putObserver.end((Enum)StoreOperationOutcomes.PutOutcome.PUT);
                return Store.PutStatus.PUT;
            }
            this.putObserver.end((Enum)StoreOperationOutcomes.PutOutcome.NOOP);
            return Store.PutStatus.NOOP;
        }
        catch (RuntimeException | StoreAccessException caex) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, caex);
            this.putObserver.end((Enum)StoreOperationOutcomes.PutOutcome.FAILURE);
            throw caex;
        }
    }

    public Store.ValueHolder<V> putIfAbsent(K key, V value, Consumer<Boolean> put) throws NullPointerException, StoreAccessException {
        this.checkKey(key);
        this.checkValue(value);
        this.putIfAbsentObserver.begin();
        AtomicReference returnValue = new AtomicReference();
        StoreEventSink eventSink = this.eventDispatcher.eventSink();
        try {
            BiFunction<Object, OffHeapValueHolder, OffHeapValueHolder> mappingFunction = (mappedKey, mappedValue) -> {
                long now = this.timeSource.getTimeMillis();
                if (mappedValue == null || mappedValue.isExpired(now)) {
                    if (mappedValue != null) {
                        this.onExpiration((K)mappedKey, (Store.ValueHolder<V>)mappedValue, (StoreEventSink<K, V>)eventSink);
                    }
                    return this.newCreateValueHolder(mappedKey, value, now, eventSink);
                }
                mappedValue.forceDeserialization();
                returnValue.set(mappedValue);
                return this.setAccessTimeAndExpiryThenReturnMapping((K)mappedKey, (OffHeapValueHolder<V>)((Object)mappedValue), now, (StoreEventSink<K, V>)eventSink);
            };
            this.computeWithRetry(key, mappingFunction, false);
            this.eventDispatcher.releaseEventSink(eventSink);
            Store.ValueHolder resultHolder = (Store.ValueHolder)returnValue.get();
            if (resultHolder == null) {
                this.putIfAbsentObserver.end((Enum)StoreOperationOutcomes.PutIfAbsentOutcome.PUT);
                return null;
            }
            this.putIfAbsentObserver.end((Enum)StoreOperationOutcomes.PutIfAbsentOutcome.HIT);
            return resultHolder;
        }
        catch (RuntimeException | StoreAccessException caex) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, caex);
            throw caex;
        }
    }

    public boolean remove(K key) throws StoreAccessException {
        this.checkKey(key);
        this.removeObserver.begin();
        StoreEventSink eventSink = this.eventDispatcher.eventSink();
        long now = this.timeSource.getTimeMillis();
        AtomicBoolean removed = new AtomicBoolean(false);
        try {
            this.backingMap().computeIfPresent(key, (mappedKey, mappedValue) -> {
                if (mappedValue != null && mappedValue.isExpired(now)) {
                    this.onExpiration((K)mappedKey, (Store.ValueHolder<V>)mappedValue, (StoreEventSink<K, V>)eventSink);
                    return null;
                }
                if (mappedValue != null) {
                    removed.set(true);
                    eventSink.removed(mappedKey, (Supplier)((Object)mappedValue));
                }
                return null;
            });
            this.eventDispatcher.releaseEventSink(eventSink);
            if (removed.get()) {
                this.removeObserver.end((Enum)StoreOperationOutcomes.RemoveOutcome.REMOVED);
            } else {
                this.removeObserver.end((Enum)StoreOperationOutcomes.RemoveOutcome.MISS);
            }
            return removed.get();
        }
        catch (RuntimeException re) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    public Store.RemoveStatus remove(K key, V value) throws StoreAccessException {
        this.checkKey(key);
        this.checkValue(value);
        this.conditionalRemoveObserver.begin();
        AtomicBoolean removed = new AtomicBoolean(false);
        StoreEventSink eventSink = this.eventDispatcher.eventSink();
        AtomicBoolean mappingExists = new AtomicBoolean();
        try {
            this.backingMap().computeIfPresent(key, (mappedKey, mappedValue) -> {
                long now = this.timeSource.getTimeMillis();
                if (mappedValue.isExpired(now)) {
                    this.onExpiration((K)mappedKey, (Store.ValueHolder<V>)mappedValue, (StoreEventSink<K, V>)eventSink);
                    return null;
                }
                if (mappedValue.get().equals(value)) {
                    removed.set(true);
                    eventSink.removed(mappedKey, (Supplier)((Object)mappedValue));
                    return null;
                }
                mappingExists.set(true);
                return this.setAccessTimeAndExpiryThenReturnMapping((K)mappedKey, (OffHeapValueHolder<V>)((Object)mappedValue), now, (StoreEventSink<K, V>)eventSink);
            });
            this.eventDispatcher.releaseEventSink(eventSink);
            if (removed.get()) {
                this.conditionalRemoveObserver.end((Enum)StoreOperationOutcomes.ConditionalRemoveOutcome.REMOVED);
                return Store.RemoveStatus.REMOVED;
            }
            this.conditionalRemoveObserver.end((Enum)StoreOperationOutcomes.ConditionalRemoveOutcome.MISS);
            if (mappingExists.get()) {
                return Store.RemoveStatus.KEY_PRESENT;
            }
            return Store.RemoveStatus.KEY_MISSING;
        }
        catch (RuntimeException re) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    public Store.ValueHolder<V> replace(K key, V value) throws NullPointerException, StoreAccessException {
        this.checkKey(key);
        this.checkValue(value);
        this.replaceObserver.begin();
        AtomicReference<Object> returnValue = new AtomicReference<Object>(null);
        StoreEventSink eventSink = this.eventDispatcher.eventSink();
        BiFunction<Object, OffHeapValueHolder, OffHeapValueHolder> mappingFunction = (mappedKey, mappedValue) -> {
            long now = this.timeSource.getTimeMillis();
            if (mappedValue == null || mappedValue.isExpired(now)) {
                if (mappedValue != null) {
                    this.onExpiration((K)mappedKey, (Store.ValueHolder<V>)mappedValue, (StoreEventSink<K, V>)eventSink);
                }
                return null;
            }
            returnValue.set(mappedValue);
            return this.newUpdatedValueHolder((K)mappedKey, value, (OffHeapValueHolder<V>)((Object)mappedValue), now, (StoreEventSink<K, V>)eventSink);
        };
        try {
            this.computeWithRetry(key, mappingFunction, false);
            this.eventDispatcher.releaseEventSink(eventSink);
            Store.ValueHolder resultHolder = returnValue.get();
            if (resultHolder != null) {
                this.replaceObserver.end((Enum)StoreOperationOutcomes.ReplaceOutcome.REPLACED);
            } else {
                this.replaceObserver.end((Enum)StoreOperationOutcomes.ReplaceOutcome.MISS);
            }
            return resultHolder;
        }
        catch (RuntimeException | StoreAccessException caex) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, caex);
            throw caex;
        }
    }

    public Store.ReplaceStatus replace(K key, V oldValue, V newValue) throws NullPointerException, IllegalArgumentException, StoreAccessException {
        this.checkKey(key);
        this.checkValue(oldValue);
        this.checkValue(newValue);
        this.conditionalReplaceObserver.begin();
        AtomicBoolean replaced = new AtomicBoolean(false);
        StoreEventSink eventSink = this.eventDispatcher.eventSink();
        AtomicBoolean mappingExists = new AtomicBoolean();
        BiFunction<Object, OffHeapValueHolder, OffHeapValueHolder> mappingFunction = (mappedKey, mappedValue) -> {
            long now = this.timeSource.getTimeMillis();
            if (mappedValue == null || mappedValue.isExpired(now)) {
                if (mappedValue != null) {
                    this.onExpiration((K)mappedKey, (Store.ValueHolder<V>)mappedValue, (StoreEventSink<K, V>)eventSink);
                }
                return null;
            }
            if (oldValue.equals(mappedValue.get())) {
                replaced.set(true);
                return this.newUpdatedValueHolder((K)mappedKey, newValue, (OffHeapValueHolder<V>)((Object)mappedValue), now, (StoreEventSink<K, V>)eventSink);
            }
            mappingExists.set(true);
            return this.setAccessTimeAndExpiryThenReturnMapping((K)mappedKey, (OffHeapValueHolder<V>)((Object)mappedValue), now, (StoreEventSink<K, V>)eventSink);
        };
        try {
            this.computeWithRetry(key, mappingFunction, false);
            this.eventDispatcher.releaseEventSink(eventSink);
            if (replaced.get()) {
                this.conditionalReplaceObserver.end((Enum)StoreOperationOutcomes.ConditionalReplaceOutcome.REPLACED);
                return Store.ReplaceStatus.HIT;
            }
            this.conditionalReplaceObserver.end((Enum)StoreOperationOutcomes.ConditionalReplaceOutcome.MISS);
            if (mappingExists.get()) {
                return Store.ReplaceStatus.MISS_PRESENT;
            }
            return Store.ReplaceStatus.MISS_NOT_PRESENT;
        }
        catch (RuntimeException | StoreAccessException caex) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, caex);
            throw caex;
        }
    }

    public void clear() throws StoreAccessException {
        try {
            this.backingMap().clear();
        }
        catch (RuntimeException re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    public StoreEventSource<K, V> getStoreEventSource() {
        return this.eventDispatcher;
    }

    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() {
        return new Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>>(){
            private final Iterator<Map.Entry<K, OffHeapValueHolder<V>>> mapIterator;
            {
                this.mapIterator = AbstractOffHeapStore.this.backingMap().entrySet().iterator();
            }

            public boolean hasNext() {
                return this.mapIterator.hasNext();
            }

            public Cache.Entry<K, Store.ValueHolder<V>> next() {
                Map.Entry next = this.mapIterator.next();
                final Object key = next.getKey();
                final OffHeapValueHolder value = next.getValue();
                return new Cache.Entry<K, Store.ValueHolder<V>>(){

                    public K getKey() {
                        return key;
                    }

                    public Store.ValueHolder<V> getValue() {
                        return value;
                    }
                };
            }
        };
    }

    public Store.ValueHolder<V> getAndCompute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) throws StoreAccessException {
        this.checkKey(key);
        this.computeObserver.begin();
        AtomicBoolean write = new AtomicBoolean(false);
        AtomicReference valueHeld = new AtomicReference();
        AtomicReference existingValueHolder = new AtomicReference();
        StoreEventSink eventSink = this.eventDispatcher.eventSink();
        BiFunction<Object, OffHeapValueHolder, OffHeapValueHolder> computeFunction = (mappedKey, mappedValue) -> {
            long now = this.timeSource.getTimeMillis();
            Object existingValue = null;
            if (mappedValue == null || mappedValue.isExpired(now)) {
                if (mappedValue != null) {
                    this.onExpiration((K)mappedKey, (Store.ValueHolder<V>)mappedValue, (StoreEventSink<K, V>)eventSink);
                }
                mappedValue = null;
            } else {
                existingValue = mappedValue.get();
                existingValueHolder.set(mappedValue);
            }
            Object computedValue = mappingFunction.apply((K)mappedKey, (V)existingValue);
            if (computedValue == null) {
                if (mappedValue != null) {
                    write.set(true);
                    eventSink.removed(mappedKey, (Supplier)((Object)mappedValue));
                }
                return null;
            }
            this.checkValue(computedValue);
            write.set(true);
            if (mappedValue != null) {
                OffHeapValueHolder valueHolder = this.newUpdatedValueHolder(key, (V)computedValue, (OffHeapValueHolder<V>)((Object)mappedValue), now, (StoreEventSink<K, V>)eventSink);
                if (valueHolder == null) {
                    valueHeld.set(new BasicOffHeapValueHolder(mappedValue.getId(), computedValue, now, now));
                }
                return valueHolder;
            }
            return this.newCreateValueHolder(key, computedValue, now, eventSink);
        };
        try {
            OffHeapValueHolder result = this.computeWithRetry(key, computeFunction, false);
            if (result == null && valueHeld.get() != null) {
                result = (OffHeapValueHolder)((Object)valueHeld.get());
            }
            this.eventDispatcher.releaseEventSink(eventSink);
            if (result == null) {
                if (write.get()) {
                    this.computeObserver.end((Enum)StoreOperationOutcomes.ComputeOutcome.REMOVED);
                } else {
                    this.computeObserver.end((Enum)StoreOperationOutcomes.ComputeOutcome.MISS);
                }
            } else if (write.get()) {
                this.computeObserver.end((Enum)StoreOperationOutcomes.ComputeOutcome.PUT);
            } else {
                this.computeObserver.end((Enum)StoreOperationOutcomes.ComputeOutcome.HIT);
            }
            return (Store.ValueHolder)existingValueHolder.get();
        }
        catch (RuntimeException | StoreAccessException caex) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, caex);
            throw caex;
        }
    }

    public Store.ValueHolder<V> computeAndGet(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction, Supplier<Boolean> replaceEqual, Supplier<Boolean> invokeWriter) throws StoreAccessException {
        this.checkKey(key);
        this.computeObserver.begin();
        AtomicBoolean write = new AtomicBoolean(false);
        AtomicReference valueHeld = new AtomicReference();
        StoreEventSink eventSink = this.eventDispatcher.eventSink();
        BiFunction<Object, OffHeapValueHolder, OffHeapValueHolder> computeFunction = (mappedKey, mappedValue) -> {
            long now = this.timeSource.getTimeMillis();
            Object existingValue = null;
            if (mappedValue == null || mappedValue.isExpired(now)) {
                if (mappedValue != null) {
                    this.onExpiration((K)mappedKey, (Store.ValueHolder<V>)mappedValue, (StoreEventSink<K, V>)eventSink);
                }
                mappedValue = null;
            } else {
                existingValue = mappedValue.get();
            }
            Object computedValue = mappingFunction.apply((K)mappedKey, (V)existingValue);
            if (computedValue == null) {
                if (mappedValue != null) {
                    write.set(true);
                    eventSink.removed(mappedKey, (Supplier)((Object)mappedValue));
                }
                return null;
            }
            if (this.safeEquals(existingValue, computedValue) && !((Boolean)replaceEqual.get()).booleanValue()) {
                if (mappedValue != null) {
                    OffHeapValueHolder<V> valueHolder = this.setAccessTimeAndExpiryThenReturnMapping((K)mappedKey, (OffHeapValueHolder<V>)((Object)mappedValue), now, (StoreEventSink<K, V>)eventSink);
                    if (valueHolder == null) {
                        valueHeld.set(mappedValue);
                    }
                    return valueHolder;
                }
                return null;
            }
            this.checkValue(computedValue);
            write.set(true);
            if (mappedValue != null) {
                OffHeapValueHolder valueHolder = this.newUpdatedValueHolder(key, (V)computedValue, (OffHeapValueHolder<V>)((Object)mappedValue), now, (StoreEventSink<K, V>)eventSink);
                if (valueHolder == null) {
                    valueHeld.set(new BasicOffHeapValueHolder(mappedValue.getId(), computedValue, now, now));
                }
                return valueHolder;
            }
            return this.newCreateValueHolder(key, computedValue, now, eventSink);
        };
        try {
            OffHeapValueHolder result = this.computeWithRetry(key, computeFunction, false);
            if (result == null && valueHeld.get() != null) {
                result = (OffHeapValueHolder)((Object)valueHeld.get());
            }
            this.eventDispatcher.releaseEventSink(eventSink);
            if (result == null) {
                if (write.get()) {
                    this.computeObserver.end((Enum)StoreOperationOutcomes.ComputeOutcome.REMOVED);
                } else {
                    this.computeObserver.end((Enum)StoreOperationOutcomes.ComputeOutcome.MISS);
                }
            } else if (write.get()) {
                this.computeObserver.end((Enum)StoreOperationOutcomes.ComputeOutcome.PUT);
            } else {
                this.computeObserver.end((Enum)StoreOperationOutcomes.ComputeOutcome.HIT);
            }
            return result;
        }
        catch (RuntimeException | StoreAccessException caex) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, caex);
            throw caex;
        }
    }

    public Store.ValueHolder<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) throws StoreAccessException {
        return this.internalComputeIfAbsent(key, mappingFunction, false, false);
    }

    private Store.ValueHolder<V> internalComputeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, boolean fault, boolean delayedDeserialization) throws StoreAccessException {
        this.checkKey(key);
        if (fault) {
            this.computeIfAbsentAndFaultObserver.begin();
        } else {
            this.computeIfAbsentObserver.begin();
        }
        AtomicBoolean write = new AtomicBoolean(false);
        AtomicReference valueHeld = new AtomicReference();
        StoreEventSink eventSink = this.eventDispatcher.eventSink();
        BiFunction<Object, OffHeapValueHolder, OffHeapValueHolder> computeFunction = (mappedKey, mappedValue) -> {
            long now = this.timeSource.getTimeMillis();
            if (mappedValue == null || mappedValue.isExpired(now)) {
                if (mappedValue != null) {
                    this.onExpiration((K)mappedKey, (Store.ValueHolder<V>)mappedValue, (StoreEventSink<K, V>)eventSink);
                }
                write.set(true);
                Object computedValue = mappingFunction.apply((K)mappedKey);
                if (computedValue == null) {
                    return null;
                }
                this.checkValue(computedValue);
                return this.newCreateValueHolder(mappedKey, computedValue, now, eventSink);
            }
            OffHeapValueHolder<V> valueHolder = this.setAccessTimeAndExpiryThenReturnMapping((K)mappedKey, (OffHeapValueHolder<V>)((Object)mappedValue), now, (StoreEventSink<K, V>)eventSink);
            if (valueHolder != null) {
                if (delayedDeserialization) {
                    mappedValue.detach();
                } else {
                    mappedValue.forceDeserialization();
                }
            } else {
                valueHeld.set(mappedValue);
            }
            return valueHolder;
        };
        try {
            OffHeapValueHolder computeResult = this.computeWithRetry(key, computeFunction, fault);
            if (computeResult == null && valueHeld.get() != null) {
                computeResult = (OffHeapValueHolder)((Object)valueHeld.get());
            }
            this.eventDispatcher.releaseEventSink(eventSink);
            if (write.get()) {
                if (computeResult != null) {
                    if (fault) {
                        this.computeIfAbsentAndFaultObserver.end((Enum)AuthoritativeTierOperationOutcomes.ComputeIfAbsentAndFaultOutcome.PUT);
                    } else {
                        this.computeIfAbsentObserver.end((Enum)StoreOperationOutcomes.ComputeIfAbsentOutcome.PUT);
                    }
                } else if (fault) {
                    this.computeIfAbsentAndFaultObserver.end((Enum)AuthoritativeTierOperationOutcomes.ComputeIfAbsentAndFaultOutcome.NOOP);
                } else {
                    this.computeIfAbsentObserver.end((Enum)StoreOperationOutcomes.ComputeIfAbsentOutcome.NOOP);
                }
            } else if (fault) {
                this.computeIfAbsentAndFaultObserver.end((Enum)AuthoritativeTierOperationOutcomes.ComputeIfAbsentAndFaultOutcome.HIT);
            } else {
                this.computeIfAbsentObserver.end((Enum)StoreOperationOutcomes.ComputeIfAbsentOutcome.HIT);
            }
            return computeResult;
        }
        catch (RuntimeException | StoreAccessException caex) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, caex);
            throw caex;
        }
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws StoreAccessException {
        return this.bulkCompute(keys, remappingFunction, REPLACE_EQUALS_TRUE);
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, Supplier<Boolean> replaceEqual) throws StoreAccessException {
        HashMap<K, Store.ValueHolder<Object>> result = new HashMap<K, Store.ValueHolder<Object>>(keys.size());
        for (K key : keys) {
            this.checkKey(key);
            BiFunction<Object, Object, Object> biFunction = (k, v) -> {
                Map.Entry entry = new Map.Entry<K, V>(){

                    @Override
                    public K getKey() {
                        return k;
                    }

                    @Override
                    public V getValue() {
                        return v;
                    }

                    @Override
                    public V setValue(V value) {
                        throw new UnsupportedOperationException();
                    }
                };
                Iterator iterator = ((Iterable)remappingFunction.apply(Collections.singleton(entry))).iterator();
                Map.Entry result1 = (Map.Entry)iterator.next();
                if (result1 != null) {
                    this.checkKey(result1.getKey());
                    return result1.getValue();
                }
                return null;
            };
            Store.ValueHolder<Object> computed = this.computeAndGet(key, biFunction, replaceEqual, () -> false);
            result.put(key, computed);
        }
        return result;
    }

    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws StoreAccessException {
        HashMap<K, Store.ValueHolder<Object>> result = new HashMap<K, Store.ValueHolder<Object>>(keys.size());
        for (K key : keys) {
            this.checkKey(key);
            Function<Object, Object> function = k -> {
                Iterator iterator = ((Iterable)mappingFunction.apply(Collections.singleton(k))).iterator();
                Map.Entry result1 = (Map.Entry)iterator.next();
                if (result1 != null) {
                    this.checkKey(result1.getKey());
                    return result1.getValue();
                }
                return null;
            };
            Store.ValueHolder<Object> computed = this.computeIfAbsent(key, function);
            result.put(key, computed);
        }
        return result;
    }

    public Store.ValueHolder<V> getAndFault(K key) throws StoreAccessException {
        Store.ValueHolder mappedValue;
        this.checkKey(key);
        this.getAndFaultObserver.begin();
        StoreEventSink eventSink = this.eventDispatcher.eventSink();
        try {
            mappedValue = (Store.ValueHolder)this.backingMap().computeIfPresentAndPin(key, (mappedKey, mappedValue1) -> {
                if (mappedValue1.isExpired(this.timeSource.getTimeMillis())) {
                    this.onExpiration((K)mappedKey, (Store.ValueHolder<V>)mappedValue1, (StoreEventSink<K, V>)eventSink);
                    return null;
                }
                mappedValue1.detach();
                return mappedValue1;
            });
            this.eventDispatcher.releaseEventSink(eventSink);
            if (mappedValue == null) {
                this.getAndFaultObserver.end((Enum)AuthoritativeTierOperationOutcomes.GetAndFaultOutcome.MISS);
            } else {
                this.getAndFaultObserver.end((Enum)AuthoritativeTierOperationOutcomes.GetAndFaultOutcome.HIT);
            }
        }
        catch (RuntimeException re) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            throw StorePassThroughException.handleException((Exception)re);
        }
        return mappedValue;
    }

    public Store.ValueHolder<V> computeIfAbsentAndFault(K key, Function<? super K, ? extends V> mappingFunction) throws StoreAccessException {
        return this.internalComputeIfAbsent(key, mappingFunction, true, true);
    }

    public boolean flush(K key, Store.ValueHolder<V> valueFlushed) {
        this.checkKey(key);
        this.flushObserver.begin();
        StoreEventSink eventSink = this.eventDispatcher.eventSink();
        try {
            boolean result = this.backingMap().computeIfPinned(key, (k, valuePresent) -> {
                if (valuePresent.getId() == valueFlushed.getId()) {
                    if (valueFlushed.isExpired(this.timeSource.getTimeMillis())) {
                        this.onExpiration((K)k, (Store.ValueHolder<V>)valuePresent, (StoreEventSink<K, V>)eventSink);
                        return null;
                    }
                    valuePresent.updateMetadata(valueFlushed);
                    valuePresent.writeBack();
                }
                return valuePresent;
            }, valuePresent -> valuePresent.getId() == valueFlushed.getId());
            this.eventDispatcher.releaseEventSink(eventSink);
            if (result) {
                this.flushObserver.end((Enum)AuthoritativeTierOperationOutcomes.FlushOutcome.HIT);
                return true;
            }
            this.flushObserver.end((Enum)AuthoritativeTierOperationOutcomes.FlushOutcome.MISS);
            return false;
        }
        catch (RuntimeException re) {
            this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            throw re;
        }
    }

    public void setInvalidationValve(AuthoritativeTier.InvalidationValve valve) {
        this.valve = valve;
    }

    public void setInvalidationListener(CachingTier.InvalidationListener<K, V> invalidationListener) {
        this.invalidationListener = invalidationListener;
        this.mapEvictionListener.setInvalidationListener(invalidationListener);
    }

    public void invalidate(K key) throws StoreAccessException {
        this.invalidateObserver.begin();
        AtomicBoolean removed = new AtomicBoolean(false);
        try {
            this.backingMap().computeIfPresent(key, (k, present) -> {
                removed.set(true);
                this.notifyInvalidation(key, (Store.ValueHolder<V>)present);
                return null;
            });
            if (removed.get()) {
                this.invalidateObserver.end((Enum)LowerCachingTierOperationsOutcome.InvalidateOutcome.REMOVED);
            } else {
                this.invalidateObserver.end((Enum)LowerCachingTierOperationsOutcome.InvalidateOutcome.MISS);
            }
        }
        catch (RuntimeException re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    public void invalidateAll() throws StoreAccessException {
        this.invalidateAllObserver.begin();
        StoreAccessException exception = null;
        long errorCount = 0L;
        for (Object k : this.backingMap().keySet()) {
            try {
                this.invalidate(k);
            }
            catch (StoreAccessException e) {
                ++errorCount;
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            this.invalidateAllObserver.end((Enum)LowerCachingTierOperationsOutcome.InvalidateAllOutcome.FAILURE);
            throw new StoreAccessException("invalidateAll failed - error count: " + errorCount, (Throwable)exception);
        }
        this.invalidateAllObserver.end((Enum)LowerCachingTierOperationsOutcome.InvalidateAllOutcome.SUCCESS);
    }

    public void invalidateAllWithHash(long hash) {
        this.invalidateAllWithHashObserver.begin();
        int intHash = HashUtils.longHashToInt(hash);
        Map<K, OffHeapValueHolder<V>> removed = this.backingMap().removeAllWithHash(intHash);
        for (Map.Entry<K, OffHeapValueHolder<V>> entry : removed.entrySet()) {
            this.notifyInvalidation(entry.getKey(), (Store.ValueHolder)entry.getValue());
        }
        this.invalidateAllWithHashObserver.end((Enum)LowerCachingTierOperationsOutcome.InvalidateAllWithHashOutcome.SUCCESS);
    }

    private void notifyInvalidation(K key, Store.ValueHolder<V> p) {
        CachingTier.InvalidationListener<K, V> invalidationListener = this.invalidationListener;
        if (invalidationListener != null) {
            invalidationListener.onInvalidation(key, p);
        }
    }

    public Store.ValueHolder<V> getAndRemove(K key) throws StoreAccessException {
        this.checkKey(key);
        this.getAndRemoveObserver.begin();
        AtomicReference valueHolderAtomicReference = new AtomicReference();
        BiFunction<Object, OffHeapValueHolder, OffHeapValueHolder> computeFunction = (mappedKey, mappedValue) -> {
            long now = this.timeSource.getTimeMillis();
            if (mappedValue == null || mappedValue.isExpired(now)) {
                if (mappedValue != null) {
                    this.onExpirationInCachingTier((Store.ValueHolder<V>)mappedValue, key);
                }
                return null;
            }
            mappedValue.detach();
            valueHolderAtomicReference.set(mappedValue);
            return null;
        };
        try {
            this.backingMap().compute(key, computeFunction, false);
            Store.ValueHolder result = (Store.ValueHolder)valueHolderAtomicReference.get();
            if (result == null) {
                this.getAndRemoveObserver.end((Enum)LowerCachingTierOperationsOutcome.GetAndRemoveOutcome.MISS);
            } else {
                this.getAndRemoveObserver.end((Enum)LowerCachingTierOperationsOutcome.GetAndRemoveOutcome.HIT_REMOVED);
            }
            return result;
        }
        catch (RuntimeException re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    public Store.ValueHolder<V> installMapping(K key, Function<K, Store.ValueHolder<V>> source) throws StoreAccessException {
        this.installMappingObserver.begin();
        BiFunction<Object, OffHeapValueHolder, OffHeapValueHolder> computeFunction = (k, offHeapValueHolder) -> {
            if (offHeapValueHolder != null) {
                throw new AssertionError();
            }
            Store.ValueHolder valueHolder = (Store.ValueHolder)source.apply(k);
            if (valueHolder != null) {
                if (valueHolder.isExpired(this.timeSource.getTimeMillis())) {
                    this.onExpirationInCachingTier(valueHolder, key);
                    return null;
                }
                return this.newTransferValueHolder(valueHolder);
            }
            return null;
        };
        try {
            OffHeapValueHolder<V> computeResult = this.computeWithRetry(key, computeFunction, false);
            if (computeResult != null) {
                this.installMappingObserver.end((Enum)LowerCachingTierOperationsOutcome.InstallMappingOutcome.PUT);
            } else {
                this.installMappingObserver.end((Enum)LowerCachingTierOperationsOutcome.InstallMappingOutcome.NOOP);
            }
            return computeResult;
        }
        catch (RuntimeException re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    private OffHeapValueHolder<V> computeWithRetry(K key, BiFunction<K, OffHeapValueHolder<V>, OffHeapValueHolder<V>> computeFunction, boolean fault) throws StoreAccessException {
        OffHeapValueHolder<V> computeResult;
        try {
            computeResult = this.backingMap().compute(key, computeFunction, fault);
        }
        catch (OversizeMappingException ex) {
            try {
                this.evictionAdvisor().setSwitchedOn(false);
                this.invokeValve();
                computeResult = this.backingMap().compute(key, computeFunction, fault);
            }
            catch (OversizeMappingException e) {
                throw new StoreAccessException("The element with key '" + key + "' is too large to be stored in this offheap store.", (Throwable)e);
            }
            catch (RuntimeException e) {
                throw StorePassThroughException.handleException((Exception)e);
            }
            finally {
                this.evictionAdvisor().setSwitchedOn(true);
            }
        }
        catch (RuntimeException re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
        return computeResult;
    }

    private boolean safeEquals(V existingValue, V computedValue) {
        return existingValue == computedValue || existingValue != null && existingValue.equals(computedValue);
    }

    private OffHeapValueHolder<V> setAccessTimeAndExpiryThenReturnMapping(K key, OffHeapValueHolder<V> valueHolder, long now, StoreEventSink<K, V> eventSink) {
        Duration duration = Duration.ZERO;
        try {
            duration = this.expiry.getExpiryForAccess(key, valueHolder);
            if (duration != null && duration.isNegative()) {
                duration = Duration.ZERO;
            }
        }
        catch (RuntimeException re) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
        }
        if (Duration.ZERO.equals(duration)) {
            this.onExpiration(key, (Store.ValueHolder<V>)valueHolder, eventSink);
            return null;
        }
        valueHolder.accessed(now, duration);
        valueHolder.writeBack();
        return valueHolder;
    }

    private OffHeapValueHolder<V> newUpdatedValueHolder(K key, V value, OffHeapValueHolder<V> existing, long now, StoreEventSink<K, V> eventSink) {
        eventSink.updated(key, existing, value);
        Duration duration = Duration.ZERO;
        try {
            duration = this.expiry.getExpiryForUpdate(key, existing, value);
            if (duration != null && duration.isNegative()) {
                duration = Duration.ZERO;
            }
        }
        catch (RuntimeException re) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
        }
        if (Duration.ZERO.equals(duration)) {
            eventSink.expired(key, () -> value);
            return null;
        }
        if (duration == null) {
            return new BasicOffHeapValueHolder<V>(this.backingMap().nextIdFor(key), value, now, existing.expirationTime());
        }
        if (ExpiryUtils.isExpiryDurationInfinite((Duration)duration)) {
            return new BasicOffHeapValueHolder<V>(this.backingMap().nextIdFor(key), value, now, -1L);
        }
        return new BasicOffHeapValueHolder<V>(this.backingMap().nextIdFor(key), value, now, ExpiryUtils.getExpirationMillis((long)now, (Duration)duration));
    }

    private OffHeapValueHolder<V> newCreateValueHolder(K key, V value, long now, StoreEventSink<K, V> eventSink) {
        Objects.requireNonNull(value);
        Duration duration = ExpiryUtils.getExpiryForCreation(key, value, this.expiry);
        if (duration.isZero()) {
            return null;
        }
        eventSink.created(key, value);
        long expirationTime = ExpiryUtils.isExpiryDurationInfinite((Duration)duration) ? -1L : ExpiryUtils.getExpirationMillis((long)now, (Duration)duration);
        return new BasicOffHeapValueHolder<V>(this.backingMap().nextIdFor(key), value, now, expirationTime);
    }

    private OffHeapValueHolder<V> newTransferValueHolder(Store.ValueHolder<V> valueHolder) {
        if (valueHolder instanceof BinaryValueHolder && ((BinaryValueHolder)valueHolder).isBinaryValueAvailable()) {
            return new BinaryOffHeapValueHolder<Object>(valueHolder.getId(), valueHolder.get(), ((BinaryValueHolder)valueHolder).getBinaryValue(), valueHolder.creationTime(), valueHolder.expirationTime(), valueHolder.lastAccessTime());
        }
        return new BasicOffHeapValueHolder<Object>(valueHolder.getId(), valueHolder.get(), valueHolder.creationTime(), valueHolder.expirationTime(), valueHolder.lastAccessTime());
    }

    private void invokeValve() throws StoreAccessException {
        AuthoritativeTier.InvalidationValve valve = this.valve;
        if (valve != null) {
            valve.invalidateAll();
        }
    }

    private void onExpirationInCachingTier(Store.ValueHolder<V> mappedValue, K key) {
        this.expirationObserver.begin();
        this.invalidationListener.onInvalidation(key, mappedValue);
        this.expirationObserver.end((Enum)StoreOperationOutcomes.ExpirationOutcome.SUCCESS);
    }

    private void onExpiration(K mappedKey, Store.ValueHolder<V> mappedValue, StoreEventSink<K, V> eventSink) {
        this.expirationObserver.begin();
        eventSink.expired(mappedKey, mappedValue);
        this.invalidationListener.onInvalidation(mappedKey, mappedValue);
        this.expirationObserver.end((Enum)StoreOperationOutcomes.ExpirationOutcome.SUCCESS);
    }

    protected abstract EhcacheOffHeapBackingMap<K, OffHeapValueHolder<V>> backingMap();

    protected abstract SwitchableEvictionAdvisor<K, OffHeapValueHolder<V>> evictionAdvisor();

    protected static <K, V> SwitchableEvictionAdvisor<K, OffHeapValueHolder<V>> wrap(EvictionAdvisor<? super K, ? super V> delegate) {
        return new OffHeapEvictionAdvisorWrapper(delegate);
    }

    static class BackingMapEvictionListener<K, V>
    implements EhcacheSegmentFactory.EhcacheSegment.EvictionListener<K, OffHeapValueHolder<V>> {
        private final StoreEventDispatcher<K, V> eventDispatcher;
        private final OperationObserver<StoreOperationOutcomes.EvictionOutcome> evictionObserver;
        private volatile CachingTier.InvalidationListener<K, V> invalidationListener;

        private BackingMapEvictionListener(StoreEventDispatcher<K, V> eventDispatcher, OperationObserver<StoreOperationOutcomes.EvictionOutcome> evictionObserver) {
            CachingTier.InvalidationListener nullInvalidationListener;
            this.eventDispatcher = eventDispatcher;
            this.evictionObserver = evictionObserver;
            this.invalidationListener = nullInvalidationListener = NULL_INVALIDATION_LISTENER;
        }

        public void setInvalidationListener(CachingTier.InvalidationListener<K, V> invalidationListener) {
            if (invalidationListener == null) {
                throw new NullPointerException("invalidation listener cannot be null");
            }
            this.invalidationListener = invalidationListener;
        }

        @Override
        public void onEviction(K key, OffHeapValueHolder<V> value) {
            this.evictionObserver.begin();
            StoreEventSink eventSink = this.eventDispatcher.eventSink();
            try {
                eventSink.evicted(key, value);
                this.eventDispatcher.releaseEventSink(eventSink);
            }
            catch (RuntimeException re) {
                this.eventDispatcher.releaseEventSinkAfterFailure(eventSink, (Throwable)re);
            }
            this.invalidationListener.onInvalidation(key, value);
            this.evictionObserver.end((Enum)StoreOperationOutcomes.EvictionOutcome.SUCCESS);
        }
    }

    private static class OffHeapEvictionAdvisorWrapper<K, V>
    implements SwitchableEvictionAdvisor<K, OffHeapValueHolder<V>> {
        private final EvictionAdvisor<? super K, ? super V> delegate;
        private volatile boolean adviceEnabled;

        private OffHeapEvictionAdvisorWrapper(EvictionAdvisor<? super K, ? super V> delegate) {
            this.delegate = delegate;
        }

        public boolean adviseAgainstEviction(K key, OffHeapValueHolder<V> value) {
            try {
                return this.delegate.adviseAgainstEviction(key, value.get());
            }
            catch (Exception e) {
                LOG.error("Exception raised while running eviction advisor - Eviction will assume entry is NOT advised against eviction", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean isSwitchedOn() {
            return this.adviceEnabled;
        }

        @Override
        public void setSwitchedOn(boolean switchedOn) {
            this.adviceEnabled = switchedOn;
        }
    }
}

