/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.events;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.ehcache.Cache;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.CacheConfigurationProperty;
import org.ehcache.core.events.CacheEventDispatcher;
import org.ehcache.core.events.CacheEvents;
import org.ehcache.core.internal.events.EventListenerWrapper;
import org.ehcache.core.spi.store.events.StoreEvent;
import org.ehcache.core.spi.store.events.StoreEventListener;
import org.ehcache.core.spi.store.events.StoreEventSource;
import org.ehcache.event.CacheEvent;
import org.ehcache.event.CacheEventListener;
import org.ehcache.event.EventFiring;
import org.ehcache.event.EventOrdering;
import org.ehcache.event.EventType;
import org.ehcache.impl.events.EventDispatchTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheEventDispatcherImpl<K, V>
implements CacheEventDispatcher<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheEventDispatcherImpl.class);
    private final ExecutorService unOrderedExectuor;
    private final ExecutorService orderedExecutor;
    private int listenersCount = 0;
    private int orderedListenerCount = 0;
    private final List<EventListenerWrapper<K, V>> syncListenersList = new CopyOnWriteArrayList<EventListenerWrapper<K, V>>();
    private final List<EventListenerWrapper<K, V>> aSyncListenersList = new CopyOnWriteArrayList<EventListenerWrapper<K, V>>();
    private final StoreEventListener<K, V> eventListener = new StoreListener();
    private volatile Cache<K, V> listenerSource;
    private volatile StoreEventSource<K, V> storeEventSource;

    public CacheEventDispatcherImpl(ExecutorService unOrderedExecutor, ExecutorService orderedExecutor) {
        this.unOrderedExectuor = unOrderedExecutor;
        this.orderedExecutor = orderedExecutor;
    }

    public void registerCacheEventListener(CacheEventListener<? super K, ? super V> listener, EventOrdering ordering, EventFiring firing, EnumSet<EventType> forEventTypes) {
        EventListenerWrapper wrapper = new EventListenerWrapper(listener, firing, ordering, forEventTypes);
        this.registerCacheEventListener(wrapper);
    }

    private synchronized void registerCacheEventListener(EventListenerWrapper<K, V> wrapper) {
        if (this.aSyncListenersList.contains(wrapper) || this.syncListenersList.contains(wrapper)) {
            throw new IllegalStateException("Cache Event Listener already registered: " + wrapper.getListener());
        }
        if (wrapper.isOrdered() && this.orderedListenerCount++ == 0) {
            this.storeEventSource.setEventOrdering(true);
        }
        switch (wrapper.getFiringMode()) {
            case ASYNCHRONOUS: {
                this.aSyncListenersList.add(wrapper);
                break;
            }
            case SYNCHRONOUS: {
                this.syncListenersList.add(wrapper);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled EventFiring value: " + wrapper.getFiringMode()));
            }
        }
        if (this.listenersCount++ == 0) {
            this.storeEventSource.addEventListener(this.eventListener);
        }
    }

    public void deregisterCacheEventListener(CacheEventListener<? super K, ? super V> listener) {
        EventListenerWrapper wrapper = new EventListenerWrapper(listener);
        if (!this.removeWrapperFromList(wrapper, this.aSyncListenersList) && !this.removeWrapperFromList(wrapper, this.syncListenersList)) {
            throw new IllegalStateException("Unknown cache event listener: " + listener);
        }
    }

    private synchronized boolean removeWrapperFromList(EventListenerWrapper wrapper, List<EventListenerWrapper<K, V>> listenersList) {
        int index = listenersList.indexOf(wrapper);
        if (index != -1) {
            EventListenerWrapper<K, V> containedWrapper = listenersList.remove(index);
            if (containedWrapper.isOrdered() && --this.orderedListenerCount == 0) {
                this.storeEventSource.setEventOrdering(false);
            }
            if (--this.listenersCount == 0) {
                this.storeEventSource.removeEventListener(this.eventListener);
            }
            return true;
        }
        return false;
    }

    public synchronized void shutdown() {
        this.storeEventSource.removeEventListener(this.eventListener);
        this.storeEventSource.setEventOrdering(false);
        this.syncListenersList.clear();
        this.aSyncListenersList.clear();
        this.unOrderedExectuor.shutdown();
        this.orderedExecutor.shutdown();
    }

    public synchronized void setListenerSource(Cache<K, V> source) {
        this.listenerSource = source;
    }

    void onEvent(CacheEvent<K, V> event) {
        ExecutorService executor = this.storeEventSource.isEventOrdering() ? this.orderedExecutor : this.unOrderedExectuor;
        if (!this.aSyncListenersList.isEmpty()) {
            executor.submit(new EventDispatchTask<K, V>(event, this.aSyncListenersList));
        }
        if (!this.syncListenersList.isEmpty()) {
            Future<?> future = executor.submit(new EventDispatchTask<K, V>(event, this.syncListenersList));
            try {
                future.get();
            }
            catch (Exception e) {
                LOGGER.error("Exception received as result from synchronous listeners", (Throwable)e);
            }
        }
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        ArrayList<CacheConfigurationChangeListener> configurationChangeListenerList = new ArrayList<CacheConfigurationChangeListener>();
        configurationChangeListenerList.add(event -> {
            if (event.getProperty().equals((Object)CacheConfigurationProperty.ADD_LISTENER)) {
                this.registerCacheEventListener((EventListenerWrapper)event.getNewValue());
            } else if (event.getProperty().equals((Object)CacheConfigurationProperty.REMOVE_LISTENER)) {
                CacheEventListener oldListener = (CacheEventListener)event.getOldValue();
                this.deregisterCacheEventListener(oldListener);
            }
        });
        return configurationChangeListenerList;
    }

    public synchronized void setStoreEventSource(StoreEventSource<K, V> eventSource) {
        this.storeEventSource = eventSource;
    }

    private final class StoreListener
    implements StoreEventListener<K, V> {
        private StoreListener() {
        }

        public void onEvent(StoreEvent<K, V> event) {
            switch (event.getType()) {
                case CREATED: {
                    CacheEventDispatcherImpl.this.onEvent(CacheEvents.creation((Object)event.getKey(), (Object)event.getNewValue(), (Cache)CacheEventDispatcherImpl.this.listenerSource));
                    break;
                }
                case UPDATED: {
                    CacheEventDispatcherImpl.this.onEvent(CacheEvents.update((Object)event.getKey(), (Object)event.getOldValue(), (Object)event.getNewValue(), (Cache)CacheEventDispatcherImpl.this.listenerSource));
                    break;
                }
                case REMOVED: {
                    CacheEventDispatcherImpl.this.onEvent(CacheEvents.removal((Object)event.getKey(), (Object)event.getOldValue(), (Cache)CacheEventDispatcherImpl.this.listenerSource));
                    break;
                }
                case EXPIRED: {
                    CacheEventDispatcherImpl.this.onEvent(CacheEvents.expiry((Object)event.getKey(), (Object)event.getOldValue(), (Cache)CacheEventDispatcherImpl.this.listenerSource));
                    break;
                }
                case EVICTED: {
                    CacheEventDispatcherImpl.this.onEvent(CacheEvents.eviction((Object)event.getKey(), (Object)event.getOldValue(), (Cache)CacheEventDispatcherImpl.this.listenerSource));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected StoreEvent value: " + event.getType()));
                }
            }
        }
    }
}

