/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.statistics;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ehcache.Cache;
import org.ehcache.core.InternalCache;
import org.ehcache.core.spi.service.StatisticsServiceConfiguration;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.statistics.BulkOps;
import org.ehcache.core.statistics.CacheOperationOutcomes;
import org.ehcache.core.statistics.CacheStatistics;
import org.ehcache.core.statistics.TierStatistics;
import org.ehcache.impl.internal.statistics.DefaultTierStatistics;
import org.ehcache.impl.internal.statistics.StatsUtils;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.ValueStatistic;
import org.terracotta.statistics.ValueStatistics;
import org.terracotta.statistics.derived.OperationResultFilter;
import org.terracotta.statistics.derived.latency.DefaultLatencyHistogramStatistic;
import org.terracotta.statistics.derived.latency.Jsr107LatencyMonitor;
import org.terracotta.statistics.derived.latency.LatencyHistogramStatistic;
import org.terracotta.statistics.observer.ChainedEventObserver;
import org.terracotta.statistics.observer.ChainedObserver;

class DefaultCacheStatistics
implements CacheStatistics {
    private volatile CompensatingCounters compensatingCounters = CompensatingCounters.empty();
    private final OperationStatistic<CacheOperationOutcomes.GetOutcome> get;
    private final OperationStatistic<CacheOperationOutcomes.PutOutcome> put;
    private final OperationStatistic<CacheOperationOutcomes.RemoveOutcome> remove;
    private final OperationStatistic<CacheOperationOutcomes.ClearOutcome> clear;
    private final OperationStatistic<CacheOperationOutcomes.PutIfAbsentOutcome> putIfAbsent;
    private final OperationStatistic<CacheOperationOutcomes.ReplaceOutcome> replace;
    private final OperationStatistic<CacheOperationOutcomes.ConditionalRemoveOutcome> conditionalRemove;
    private final Map<BulkOps, LongAdder> bulkMethodEntries;
    private final Jsr107LatencyMonitor<CacheOperationOutcomes.GetOutcome> averageGetTime;
    private final Jsr107LatencyMonitor<CacheOperationOutcomes.PutOutcome> averagePutTime;
    private final Jsr107LatencyMonitor<CacheOperationOutcomes.RemoveOutcome> averageRemoveTime;
    private final Map<String, TierStatistics> tierStatistics;
    private final TierStatistics lowestTier;
    private final Map<String, ValueStatistic<?>> knownStatistics;
    private final Map<String, DefaultLatencyHistogramStatistic> cacheLatencies;

    public DefaultCacheStatistics(InternalCache<?, ?> cache, StatisticsServiceConfiguration configuration, TimeSource timeSource) {
        this.bulkMethodEntries = cache.getBulkMethodEntries();
        this.get = StatsUtils.findOperationStatisticOnChildren(cache, CacheOperationOutcomes.GetOutcome.class, "get");
        this.put = StatsUtils.findOperationStatisticOnChildren(cache, CacheOperationOutcomes.PutOutcome.class, "put");
        this.remove = StatsUtils.findOperationStatisticOnChildren(cache, CacheOperationOutcomes.RemoveOutcome.class, "remove");
        this.clear = StatsUtils.findOperationStatisticOnChildren(cache, CacheOperationOutcomes.ClearOutcome.class, "clear");
        this.putIfAbsent = StatsUtils.findOperationStatisticOnChildren(cache, CacheOperationOutcomes.PutIfAbsentOutcome.class, "putIfAbsent");
        this.replace = StatsUtils.findOperationStatisticOnChildren(cache, CacheOperationOutcomes.ReplaceOutcome.class, "replace");
        this.conditionalRemove = StatsUtils.findOperationStatisticOnChildren(cache, CacheOperationOutcomes.ConditionalRemoveOutcome.class, "conditionalRemove");
        this.averageGetTime = new Jsr107LatencyMonitor(EnumSet.allOf(CacheOperationOutcomes.GetOutcome.class), 1.0);
        this.get.addDerivedStatistic(this.averageGetTime);
        this.averagePutTime = new Jsr107LatencyMonitor(EnumSet.allOf(CacheOperationOutcomes.PutOutcome.class), 1.0);
        this.put.addDerivedStatistic(this.averagePutTime);
        this.averageRemoveTime = new Jsr107LatencyMonitor(EnumSet.allOf(CacheOperationOutcomes.RemoveOutcome.class), 1.0);
        this.remove.addDerivedStatistic(this.averageRemoveTime);
        String[] tierNames = StatsUtils.findTiers(cache);
        String lowestTierName = StatsUtils.findLowestTier(tierNames);
        DefaultTierStatistics lowestTier = null;
        this.cacheLatencies = Stream.of("Cache:GetHitLatency", "Cache:GetMissLatency", "Cache:PutLatency", "Cache:RemoveLatency", "Cache:ClearLatency").collect(Collectors.toMap(Function.identity(), name -> new DefaultLatencyHistogramStatistic(0.63, 20, configuration.getDefaultHistogramWindow())));
        this.get.addDerivedStatistic((ChainedObserver)new OperationResultFilter(EnumSet.of(CacheOperationOutcomes.GetOutcome.HIT), new ChainedEventObserver[]{(ChainedEventObserver)this.cacheLatencies.get("Cache:GetHitLatency")}));
        this.get.addDerivedStatistic((ChainedObserver)new OperationResultFilter(EnumSet.of(CacheOperationOutcomes.GetOutcome.MISS), new ChainedEventObserver[]{(ChainedEventObserver)this.cacheLatencies.get("Cache:GetMissLatency")}));
        this.put.addDerivedStatistic((ChainedObserver)new OperationResultFilter(EnumSet.of(CacheOperationOutcomes.PutOutcome.PUT), new ChainedEventObserver[]{(ChainedEventObserver)this.cacheLatencies.get("Cache:PutLatency")}));
        this.remove.addDerivedStatistic((ChainedObserver)new OperationResultFilter(EnumSet.of(CacheOperationOutcomes.RemoveOutcome.SUCCESS), new ChainedEventObserver[]{(ChainedEventObserver)this.cacheLatencies.get("Cache:RemoveLatency")}));
        this.clear.addDerivedStatistic((ChainedObserver)new OperationResultFilter(EnumSet.of(CacheOperationOutcomes.ClearOutcome.SUCCESS), new ChainedEventObserver[]{(ChainedEventObserver)this.cacheLatencies.get("Cache:ClearLatency")}));
        this.tierStatistics = new HashMap<String, TierStatistics>(tierNames.length);
        for (String tierName : tierNames) {
            DefaultTierStatistics tierStatistics = new DefaultTierStatistics((Cache<?, ?>)cache, tierName);
            this.tierStatistics.put(tierName, tierStatistics);
            if (!lowestTierName.equals(tierName)) continue;
            lowestTier = tierStatistics;
        }
        this.lowestTier = lowestTier;
        this.knownStatistics = this.createKnownStatistics();
    }

    private Map<String, ValueStatistic<?>> createKnownStatistics() {
        HashMap<String, ValueStatistic> knownStatistics = new HashMap<String, ValueStatistic>(30);
        knownStatistics.put("Cache:HitCount", ValueStatistics.counter(this::getCacheHits));
        knownStatistics.put("Cache:MissCount", ValueStatistics.counter(this::getCacheMisses));
        knownStatistics.put("Cache:PutCount", ValueStatistics.counter(this::getCachePuts));
        knownStatistics.put("Cache:RemovalCount", ValueStatistics.counter(this::getCacheRemovals));
        knownStatistics.put("Cache:EvictionCount", ValueStatistics.counter(this::getCacheEvictions));
        knownStatistics.put("Cache:ExpirationCount", ValueStatistics.counter(this::getCacheExpirations));
        this.cacheLatencies.forEach((name, histogram) -> {
            knownStatistics.put(name + "#50", histogram.medianStatistic());
            knownStatistics.put(name + "#95", histogram.percentileStatistic(0.95));
            knownStatistics.put(name + "#99", histogram.percentileStatistic(0.99));
            knownStatistics.put(name + "#100", histogram.maximumStatistic());
        });
        for (TierStatistics tier : this.tierStatistics.values()) {
            knownStatistics.putAll(tier.getKnownStatistics());
        }
        return Collections.unmodifiableMap(knownStatistics);
    }

    public Map<String, ValueStatistic<?>> getKnownStatistics() {
        return this.knownStatistics;
    }

    public Map<String, TierStatistics> getTierStatistics() {
        return Collections.unmodifiableMap(this.tierStatistics);
    }

    public void clear() {
        this.compensatingCounters = this.compensatingCounters.snapshot(this);
        this.averageGetTime.clear();
        this.averagePutTime.clear();
        this.averageRemoveTime.clear();
        for (TierStatistics t : this.tierStatistics.values()) {
            t.clear();
        }
    }

    public long getCacheHits() {
        return DefaultCacheStatistics.normalize(this.getHits() - this.compensatingCounters.cacheHits);
    }

    public float getCacheHitPercentage() {
        long cacheHits = this.getCacheHits();
        return DefaultCacheStatistics.normalize((float)cacheHits / (float)(cacheHits + this.getCacheMisses())) * 100.0f;
    }

    public long getCacheMisses() {
        return DefaultCacheStatistics.normalize(this.getMisses() - this.compensatingCounters.cacheMisses);
    }

    public float getCacheMissPercentage() {
        long cacheMisses = this.getCacheMisses();
        return DefaultCacheStatistics.normalize((float)cacheMisses / (float)(this.getCacheHits() + cacheMisses)) * 100.0f;
    }

    public long getCacheGets() {
        return DefaultCacheStatistics.normalize(this.getHits() + this.getMisses() - this.compensatingCounters.cacheGets);
    }

    public long getCachePuts() {
        return DefaultCacheStatistics.normalize(this.getBulkCount(BulkOps.PUT_ALL) + this.put.sum(EnumSet.of(CacheOperationOutcomes.PutOutcome.PUT)) + this.putIfAbsent.sum(EnumSet.of(CacheOperationOutcomes.PutIfAbsentOutcome.PUT)) + this.replace.sum(EnumSet.of(CacheOperationOutcomes.ReplaceOutcome.HIT)) - this.compensatingCounters.cachePuts);
    }

    public long getCacheRemovals() {
        return DefaultCacheStatistics.normalize(this.getBulkCount(BulkOps.REMOVE_ALL) + this.remove.sum(EnumSet.of(CacheOperationOutcomes.RemoveOutcome.SUCCESS)) + this.conditionalRemove.sum(EnumSet.of(CacheOperationOutcomes.ConditionalRemoveOutcome.SUCCESS)) - this.compensatingCounters.cacheRemovals);
    }

    public long getCacheEvictions() {
        return DefaultCacheStatistics.normalize(this.lowestTier.getEvictions());
    }

    public long getCacheExpirations() {
        return DefaultCacheStatistics.normalize(this.lowestTier.getExpirations());
    }

    public float getCacheAverageGetTime() {
        return (float)this.averageGetTime.average();
    }

    public float getCacheAveragePutTime() {
        return (float)this.averagePutTime.average();
    }

    public float getCacheAverageRemoveTime() {
        return (float)this.averageRemoveTime.average();
    }

    public LatencyHistogramStatistic getCacheGetHitLatencies() {
        return (LatencyHistogramStatistic)this.cacheLatencies.get("Cache:GetHitLatency");
    }

    public LatencyHistogramStatistic getCacheGetMissLatencies() {
        return (LatencyHistogramStatistic)this.cacheLatencies.get("Cache:GetMissLatency");
    }

    public LatencyHistogramStatistic getCachePutLatencies() {
        return (LatencyHistogramStatistic)this.cacheLatencies.get("Cache:PutLatency");
    }

    public LatencyHistogramStatistic getCacheRemoveLatencies() {
        return (LatencyHistogramStatistic)this.cacheLatencies.get("Cache:RemoveLatency");
    }

    public LatencyHistogramStatistic getCacheClearLatencies() {
        return (LatencyHistogramStatistic)this.cacheLatencies.get("Cache:ClearLatency");
    }

    private long getMisses() {
        return this.getBulkCount(BulkOps.GET_ALL_MISS) + this.get.sum(EnumSet.of(CacheOperationOutcomes.GetOutcome.MISS)) + this.putIfAbsent.sum(EnumSet.of(CacheOperationOutcomes.PutIfAbsentOutcome.PUT)) + this.replace.sum(EnumSet.of(CacheOperationOutcomes.ReplaceOutcome.MISS_NOT_PRESENT)) + this.conditionalRemove.sum(EnumSet.of(CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE_KEY_MISSING));
    }

    private long getHits() {
        return this.getBulkCount(BulkOps.GET_ALL_HITS) + this.get.sum(EnumSet.of(CacheOperationOutcomes.GetOutcome.HIT)) + this.putIfAbsent.sum(EnumSet.of(CacheOperationOutcomes.PutIfAbsentOutcome.HIT)) + this.replace.sum(EnumSet.of(CacheOperationOutcomes.ReplaceOutcome.HIT, CacheOperationOutcomes.ReplaceOutcome.MISS_PRESENT)) + this.conditionalRemove.sum(EnumSet.of(CacheOperationOutcomes.ConditionalRemoveOutcome.SUCCESS, CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE_KEY_PRESENT));
    }

    private long getBulkCount(BulkOps bulkOps) {
        return this.bulkMethodEntries.get(bulkOps).longValue();
    }

    private static long normalize(long value) {
        return Math.max(0L, value);
    }

    private static float normalize(float value) {
        if (Float.isNaN(value)) {
            return 0.0f;
        }
        return Math.min(1.0f, Math.max(0.0f, value));
    }

    private static class CompensatingCounters {
        final long cacheHits;
        final long cacheMisses;
        final long cacheGets;
        final long cachePuts;
        final long cacheRemovals;

        private CompensatingCounters(long cacheHits, long cacheMisses, long cacheGets, long cachePuts, long cacheRemovals) {
            this.cacheHits = cacheHits;
            this.cacheMisses = cacheMisses;
            this.cacheGets = cacheGets;
            this.cachePuts = cachePuts;
            this.cacheRemovals = cacheRemovals;
        }

        static CompensatingCounters empty() {
            return new CompensatingCounters(0L, 0L, 0L, 0L, 0L);
        }

        CompensatingCounters snapshot(DefaultCacheStatistics statistics) {
            return new CompensatingCounters(this.cacheHits + statistics.getHits(), this.cacheMisses + statistics.getMisses(), this.cacheGets + statistics.getCacheGets(), this.cachePuts + statistics.getCachePuts(), this.cacheRemovals + statistics.getCacheRemovals());
        }
    }
}

