/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.config.BaseCacheConfiguration;
import org.ehcache.core.config.ExpiryUtils;
import org.ehcache.expiry.Expiry;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.impl.config.copy.DefaultCopierConfiguration;
import org.ehcache.impl.config.event.DefaultCacheEventDispatcherConfiguration;
import org.ehcache.impl.config.event.DefaultCacheEventListenerConfiguration;
import org.ehcache.impl.config.event.DefaultEventSourceConfiguration;
import org.ehcache.impl.config.loaderwriter.DefaultCacheLoaderWriterConfiguration;
import org.ehcache.impl.config.resilience.DefaultResilienceStrategyConfiguration;
import org.ehcache.impl.config.serializer.DefaultSerializerConfiguration;
import org.ehcache.impl.config.store.disk.OffHeapDiskStoreConfiguration;
import org.ehcache.impl.config.store.heap.DefaultSizeOfEngineConfiguration;
import org.ehcache.impl.copy.SerializingCopier;
import org.ehcache.spi.copy.Copier;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.resilience.ResilienceStrategy;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.ServiceConfiguration;

public class CacheConfigurationBuilder<K, V>
implements Builder<CacheConfiguration<K, V>> {
    private final Collection<ServiceConfiguration<?>> serviceConfigurations = new HashSet();
    private ExpiryPolicy<? super K, ? super V> expiry;
    private ClassLoader classLoader = null;
    private EvictionAdvisor<? super K, ? super V> evictionAdvisor;
    private ResourcePools resourcePools;
    private final Class<K> keyType;
    private final Class<V> valueType;

    public static <K, V> CacheConfigurationBuilder<K, V> newCacheConfigurationBuilder(Class<K> keyType, Class<V> valueType, ResourcePools resourcePools) {
        return new CacheConfigurationBuilder<K, V>(keyType, valueType, resourcePools);
    }

    public static <K, V> CacheConfigurationBuilder<K, V> newCacheConfigurationBuilder(Class<K> keyType, Class<V> valueType, Builder<? extends ResourcePools> resourcePoolsBuilder) {
        return new CacheConfigurationBuilder<K, V>(keyType, valueType, (ResourcePools)resourcePoolsBuilder.build());
    }

    public static <K, V> CacheConfigurationBuilder<K, V> newCacheConfigurationBuilder(CacheConfiguration<K, V> configuration) {
        CacheConfigurationBuilder<K, V> builder = CacheConfigurationBuilder.newCacheConfigurationBuilder(configuration.getKeyType(), configuration.getValueType(), configuration.getResourcePools()).withClassLoader(configuration.getClassLoader()).withEvictionAdvisor(configuration.getEvictionAdvisor()).withExpiry(configuration.getExpiryPolicy());
        for (ServiceConfiguration serviceConfig : configuration.getServiceConfigurations()) {
            builder = builder.add(serviceConfig);
        }
        return builder;
    }

    private CacheConfigurationBuilder(Class<K> keyType, Class<V> valueType, ResourcePools resourcePools) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.resourcePools = resourcePools;
    }

    private CacheConfigurationBuilder(CacheConfigurationBuilder<K, V> other) {
        this.keyType = other.keyType;
        this.valueType = other.valueType;
        this.expiry = other.expiry;
        this.classLoader = other.classLoader;
        this.evictionAdvisor = other.evictionAdvisor;
        this.resourcePools = other.resourcePools;
        this.serviceConfigurations.addAll(other.serviceConfigurations);
    }

    public CacheConfigurationBuilder<K, V> add(ServiceConfiguration<?> configuration) {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        if (this.getExistingServiceConfiguration(configuration.getClass()) != null) {
            if (configuration instanceof DefaultCopierConfiguration) {
                DefaultCopierConfiguration copierConfiguration = (DefaultCopierConfiguration)configuration;
                super.removeExistingCopierConfigFor(copierConfiguration.getType());
            } else if (configuration instanceof DefaultSerializerConfiguration) {
                DefaultSerializerConfiguration serializerConfiguration = (DefaultSerializerConfiguration)configuration;
                super.removeExistingSerializerConfigFor(serializerConfiguration.getType());
            } else if (!(configuration instanceof DefaultCacheEventListenerConfiguration)) {
                throw new IllegalStateException("Cannot add a generic service configuration when another one already exists. Rely on specific with* methods or make sure your remove other configuration first.");
            }
        }
        otherBuilder.serviceConfigurations.add(configuration);
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> add(Builder<? extends ServiceConfiguration<?>> configurationBuilder) {
        return this.add((ServiceConfiguration)configurationBuilder.build());
    }

    public CacheConfigurationBuilder<K, V> withEvictionAdvisor(EvictionAdvisor<? super K, ? super V> evictionAdvisor) {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.evictionAdvisor = evictionAdvisor;
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> remove(ServiceConfiguration<?> configuration) {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.serviceConfigurations.remove(configuration);
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> clearAllServiceConfig() {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.serviceConfigurations.clear();
        return otherBuilder;
    }

    public <T extends ServiceConfiguration<?>> T getExistingServiceConfiguration(Class<T> clazz) {
        for (ServiceConfiguration<?> serviceConfiguration : this.serviceConfigurations) {
            if (!clazz.equals(serviceConfiguration.getClass())) continue;
            return (T)((ServiceConfiguration)clazz.cast(serviceConfiguration));
        }
        return null;
    }

    public <T extends ServiceConfiguration<?>> List<T> getExistingServiceConfigurations(Class<T> clazz) {
        ArrayList<T> results = new ArrayList<T>();
        for (ServiceConfiguration<?> serviceConfiguration : this.serviceConfigurations) {
            if (!clazz.equals(serviceConfiguration.getClass())) continue;
            results.add(clazz.cast(serviceConfiguration));
        }
        return results;
    }

    public CacheConfigurationBuilder<K, V> withClassLoader(ClassLoader classLoader) {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.classLoader = classLoader;
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> withResourcePools(ResourcePools resourcePools) {
        if (resourcePools == null) {
            throw new NullPointerException("Null resource pools");
        }
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.resourcePools = resourcePools;
        return otherBuilder;
    }

    public CacheConfigurationBuilder<K, V> withResourcePools(ResourcePoolsBuilder resourcePoolsBuilder) {
        return this.withResourcePools(Objects.requireNonNull(resourcePoolsBuilder, "Null resource pools builder").build());
    }

    @Deprecated
    public CacheConfigurationBuilder<K, V> withExpiry(Expiry<? super K, ? super V> expiry) {
        return this.withExpiry(ExpiryUtils.convertToExpiryPolicy(Objects.requireNonNull(expiry, "Null expiry")));
    }

    public CacheConfigurationBuilder<K, V> withExpiry(ExpiryPolicy<? super K, ? super V> expiry) {
        if (expiry == null) {
            throw new NullPointerException("Null expiry");
        }
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        otherBuilder.expiry = expiry;
        return otherBuilder;
    }

    public boolean hasConfiguredExpiry() {
        return this.expiry != null;
    }

    public CacheConfigurationBuilder<K, V> withLoaderWriter(CacheLoaderWriter<K, V> loaderWriter) {
        return this.addOrReplaceConfiguration(new DefaultCacheLoaderWriterConfiguration(Objects.requireNonNull(loaderWriter, "Null loaderWriter")));
    }

    public CacheConfigurationBuilder<K, V> withLoaderWriter(Class<CacheLoaderWriter<K, V>> loaderWriterClass, Object ... arguments) {
        return this.addOrReplaceConfiguration(new DefaultCacheLoaderWriterConfiguration((Class<? extends CacheLoaderWriter<?, ?>>)Objects.requireNonNull(loaderWriterClass, "Null loaderWriterClass"), arguments));
    }

    public CacheConfigurationBuilder<K, V> withResilienceStrategy(ResilienceStrategy<K, V> resilienceStrategy) {
        return this.addOrReplaceConfiguration(new DefaultResilienceStrategyConfiguration(Objects.requireNonNull(resilienceStrategy, "Null resilienceStrategy")));
    }

    public CacheConfigurationBuilder<K, V> withResilienceStrategy(Class<? extends ResilienceStrategy> resilienceStrategyClass, Object ... arguments) {
        return this.addOrReplaceConfiguration(new DefaultResilienceStrategyConfiguration(Objects.requireNonNull(resilienceStrategyClass, "Null resilienceStrategyClass"), arguments));
    }

    public CacheConfigurationBuilder<K, V> withKeySerializingCopier() {
        return this.withKeyCopier(SerializingCopier.asCopierClass());
    }

    public CacheConfigurationBuilder<K, V> withValueSerializingCopier() {
        return this.withValueCopier(SerializingCopier.asCopierClass());
    }

    public CacheConfigurationBuilder<K, V> withKeyCopier(Copier<K> keyCopier) {
        return this.withCopier(new DefaultCopierConfiguration<K>(Objects.requireNonNull(keyCopier, "Null key copier"), DefaultCopierConfiguration.Type.KEY));
    }

    public CacheConfigurationBuilder<K, V> withKeyCopier(Class<? extends Copier<K>> keyCopierClass) {
        return this.withCopier(new DefaultCopierConfiguration(Objects.requireNonNull(keyCopierClass, "Null key copier class"), DefaultCopierConfiguration.Type.KEY));
    }

    public CacheConfigurationBuilder<K, V> withValueCopier(Copier<V> valueCopier) {
        return this.withCopier(new DefaultCopierConfiguration<V>(Objects.requireNonNull(valueCopier, "Null value copier"), DefaultCopierConfiguration.Type.VALUE));
    }

    public CacheConfigurationBuilder<K, V> withValueCopier(Class<? extends Copier<V>> valueCopierClass) {
        return this.withCopier(new DefaultCopierConfiguration(Objects.requireNonNull(valueCopierClass, "Null value copier class"), DefaultCopierConfiguration.Type.VALUE));
    }

    public CacheConfigurationBuilder<K, V> withKeySerializer(Serializer<K> keySerializer) {
        return this.withSerializer(new DefaultSerializerConfiguration<K>(Objects.requireNonNull(keySerializer, "Null key serializer"), DefaultSerializerConfiguration.Type.KEY));
    }

    public CacheConfigurationBuilder<K, V> withKeySerializer(Class<? extends Serializer<K>> keySerializerClass) {
        return this.withSerializer(new DefaultSerializerConfiguration(Objects.requireNonNull(keySerializerClass, "Null key serializer class"), DefaultSerializerConfiguration.Type.KEY));
    }

    public CacheConfigurationBuilder<K, V> withValueSerializer(Serializer<V> valueSerializer) {
        return this.withSerializer(new DefaultSerializerConfiguration<V>(Objects.requireNonNull(valueSerializer, "Null value serializer"), DefaultSerializerConfiguration.Type.VALUE));
    }

    public CacheConfigurationBuilder<K, V> withValueSerializer(Class<? extends Serializer<V>> valueSerializerClass) {
        return this.withSerializer(new DefaultSerializerConfiguration(Objects.requireNonNull(valueSerializerClass, "Null value serializer class"), DefaultSerializerConfiguration.Type.VALUE));
    }

    public CacheConfigurationBuilder<K, V> withDispatcherConcurrency(int dispatcherConcurrency) {
        return this.addOrReplaceConfiguration(new DefaultEventSourceConfiguration(dispatcherConcurrency));
    }

    public CacheConfigurationBuilder<K, V> withEventListenersThreadPool(String threadPoolAlias) {
        return this.addOrReplaceConfiguration(new DefaultCacheEventDispatcherConfiguration(threadPoolAlias));
    }

    public CacheConfigurationBuilder<K, V> withDiskStoreThreadPool(String threadPoolAlias, int concurrency) {
        return this.addOrReplaceConfiguration(new OffHeapDiskStoreConfiguration(threadPoolAlias, concurrency));
    }

    public CacheConfigurationBuilder<K, V> withSizeOfMaxObjectGraph(long size) {
        return this.mapServiceConfiguration(DefaultSizeOfEngineConfiguration.class, existing -> Optional.ofNullable(existing).map(e -> new DefaultSizeOfEngineConfiguration(e.getMaxObjectSize(), e.getUnit(), size)).orElse(new DefaultSizeOfEngineConfiguration(Long.MAX_VALUE, DefaultSizeOfEngineConfiguration.DEFAULT_UNIT, size)));
    }

    public CacheConfigurationBuilder<K, V> withSizeOfMaxObjectSize(long size, MemoryUnit unit) {
        return this.mapServiceConfiguration(DefaultSizeOfEngineConfiguration.class, existing -> Optional.ofNullable(existing).map(e -> new DefaultSizeOfEngineConfiguration(size, unit, e.getMaxObjectGraphSize())).orElse(new DefaultSizeOfEngineConfiguration(size, unit, 1000L)));
    }

    public CacheConfiguration<K, V> build() {
        return new BaseCacheConfiguration(this.keyType, this.valueType, this.evictionAdvisor, this.classLoader, this.expiry, this.resourcePools, this.serviceConfigurations.toArray(new ServiceConfiguration[this.serviceConfigurations.size()]));
    }

    private CacheConfigurationBuilder<K, V> withSerializer(DefaultSerializerConfiguration configuration) {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        super.removeExistingSerializerConfigFor(configuration.getType());
        otherBuilder.serviceConfigurations.add(configuration);
        return otherBuilder;
    }

    private void removeExistingSerializerConfigFor(DefaultSerializerConfiguration.Type type) {
        List<DefaultSerializerConfiguration> existingServiceConfigurations = this.getExistingServiceConfigurations(DefaultSerializerConfiguration.class);
        for (DefaultSerializerConfiguration configuration : existingServiceConfigurations) {
            if (!configuration.getType().equals((Object)type)) continue;
            this.serviceConfigurations.remove(configuration);
        }
    }

    private <T> CacheConfigurationBuilder<K, V> withCopier(DefaultCopierConfiguration<T> configuration) {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        super.removeExistingCopierConfigFor(configuration.getType());
        otherBuilder.serviceConfigurations.add(configuration);
        return otherBuilder;
    }

    private void removeExistingCopierConfigFor(DefaultCopierConfiguration.Type type) {
        List<DefaultCopierConfiguration> existingServiceConfigurations = this.getExistingServiceConfigurations(DefaultCopierConfiguration.class);
        for (DefaultCopierConfiguration configuration : existingServiceConfigurations) {
            if (!configuration.getType().equals((Object)type)) continue;
            this.serviceConfigurations.remove(configuration);
        }
    }

    private <T extends ServiceConfiguration<?>> CacheConfigurationBuilder<K, V> addOrReplaceConfiguration(T configuration) {
        return this.addOrReplaceConfiguration(configuration.getClass(), configuration);
    }

    private <T extends ServiceConfiguration<?>> CacheConfigurationBuilder<K, V> addOrReplaceConfiguration(Class<T> configurationType, T configuration) {
        return this.mapServiceConfiguration(configurationType, e -> configuration);
    }

    private <T extends ServiceConfiguration<?>> CacheConfigurationBuilder<K, V> mapServiceConfiguration(Class<T> configurationType, UnaryOperator<T> mapper) {
        CacheConfigurationBuilder<K, V> otherBuilder = new CacheConfigurationBuilder<K, V>(this);
        T existingServiceConfiguration = otherBuilder.getExistingServiceConfiguration(configurationType);
        if (existingServiceConfiguration != null) {
            otherBuilder.serviceConfigurations.remove(existingServiceConfiguration);
        }
        otherBuilder.serviceConfigurations.add((ServiceConfiguration<?>)mapper.apply(existingServiceConfiguration));
        return otherBuilder;
    }
}

