/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.statistics;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.ehcache.Cache;
import org.ehcache.core.statistics.StoreOperationOutcomes;
import org.ehcache.core.statistics.TierOperationOutcomes;
import org.ehcache.core.statistics.TierStatistics;
import org.ehcache.impl.internal.statistics.StatsUtils;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.ValueStatistic;
import org.terracotta.statistics.ValueStatistics;
import org.terracotta.statistics.ZeroOperationStatistic;

class DefaultTierStatistics
implements TierStatistics {
    private volatile CompensatingCounters compensatingCounters = CompensatingCounters.empty();
    private final Map<String, ValueStatistic<?>> knownStatistics;
    private final OperationStatistic<TierOperationOutcomes.GetOutcome> get;
    private final OperationStatistic<StoreOperationOutcomes.PutOutcome> put;
    private final OperationStatistic<StoreOperationOutcomes.PutIfAbsentOutcome> putIfAbsent;
    private final OperationStatistic<StoreOperationOutcomes.ReplaceOutcome> replace;
    private final OperationStatistic<StoreOperationOutcomes.ConditionalReplaceOutcome> conditionalReplace;
    private final OperationStatistic<StoreOperationOutcomes.RemoveOutcome> remove;
    private final OperationStatistic<StoreOperationOutcomes.ConditionalRemoveOutcome> conditionalRemove;
    private final OperationStatistic<TierOperationOutcomes.EvictionOutcome> eviction;
    private final OperationStatistic<StoreOperationOutcomes.ExpirationOutcome> expiration;
    private final OperationStatistic<StoreOperationOutcomes.ComputeOutcome> compute;
    private final OperationStatistic<StoreOperationOutcomes.ComputeIfAbsentOutcome> computeIfAbsent;
    private final Optional<ValueStatistic<Long>> mapping;
    private final Optional<ValueStatistic<Long>> allocatedMemory;
    private final Optional<ValueStatistic<Long>> occupiedMemory;

    public DefaultTierStatistics(Cache<?, ?> cache, String tierName) {
        this.get = this.findOperationStatistic(cache, tierName, "tier", "get");
        this.put = this.findOperationStatistic(cache, tierName, "put");
        this.putIfAbsent = this.findOperationStatistic(cache, tierName, "putIfAbsent");
        this.replace = this.findOperationStatistic(cache, tierName, "replace");
        this.conditionalReplace = this.findOperationStatistic(cache, tierName, "conditionalReplace");
        this.remove = this.findOperationStatistic(cache, tierName, "remove");
        this.conditionalRemove = this.findOperationStatistic(cache, tierName, "conditionalRemove");
        this.eviction = this.findOperationStatistic(cache, tierName, "tier", "eviction");
        this.expiration = this.findOperationStatistic(cache, tierName, "expiration");
        this.compute = this.findOperationStatistic(cache, tierName, "compute");
        this.computeIfAbsent = this.findOperationStatistic(cache, tierName, "computeIfAbsent");
        this.mapping = this.findValueStatistics(cache, tierName, "mappings");
        this.allocatedMemory = this.findValueStatistics(cache, tierName, "allocatedMemory");
        this.occupiedMemory = this.findValueStatistics(cache, tierName, "occupiedMemory");
        Map<String, ValueStatistic<?>> knownStatistics = this.createKnownStatistics(tierName);
        this.knownStatistics = Collections.unmodifiableMap(knownStatistics);
    }

    private Map<String, ValueStatistic<?>> createKnownStatistics(String tierName) {
        HashMap knownStatistics = new HashMap(7);
        knownStatistics.put(tierName + ":HitCount", ValueStatistics.counter(this::getHits));
        knownStatistics.put(tierName + ":MissCount", ValueStatistics.counter(this::getMisses));
        knownStatistics.put(tierName + ":PutCount", ValueStatistics.counter(this::getPuts));
        knownStatistics.put(tierName + ":RemovalCount", ValueStatistics.counter(this::getRemovals));
        knownStatistics.put(tierName + ":EvictionCount", ValueStatistics.counter(this::getEvictions));
        knownStatistics.put(tierName + ":ExpirationCount", ValueStatistics.counter(this::getExpirations));
        this.mapping.ifPresent(longValueStatistic -> knownStatistics.put(tierName + ":MappingCount", ValueStatistics.counter(this::getMappings)));
        this.allocatedMemory.ifPresent(longValueStatistic -> knownStatistics.put(tierName + ":AllocatedByteSize", ValueStatistics.gauge(this::getAllocatedByteSize)));
        this.occupiedMemory.ifPresent(longValueStatistic -> knownStatistics.put(tierName + ":OccupiedByteSize", ValueStatistics.gauge(this::getOccupiedByteSize)));
        return knownStatistics;
    }

    public Map<String, ValueStatistic<?>> getKnownStatistics() {
        return this.knownStatistics;
    }

    private <T extends Enum<T>> OperationStatistic<T> findOperationStatistic(Cache<?, ?> cache, String tierName, String tag, String stat) {
        return StatsUtils.findStatisticOnDescendants(cache, tierName, tag, stat).orElse(ZeroOperationStatistic.get());
    }

    private <T extends Enum<T>> OperationStatistic<T> findOperationStatistic(Cache<?, ?> cache, String tierName, String stat) {
        return StatsUtils.findStatisticOnDescendants(cache, tierName, stat).orElse(ZeroOperationStatistic.get());
    }

    private Optional<ValueStatistic<Long>> findValueStatistics(Cache<?, ?> cache, String tierName, String statName) {
        return StatsUtils.findStatisticOnDescendants(cache, tierName, statName);
    }

    public void clear() {
        this.compensatingCounters = this.compensatingCounters.snapshot(this);
    }

    public long getHits() {
        return this.get.sum(EnumSet.of(TierOperationOutcomes.GetOutcome.HIT)) + this.putIfAbsent.sum(EnumSet.of(StoreOperationOutcomes.PutIfAbsentOutcome.HIT)) + this.replace.sum(EnumSet.of(StoreOperationOutcomes.ReplaceOutcome.REPLACED)) + this.compute.sum(EnumSet.of(StoreOperationOutcomes.ComputeOutcome.HIT)) + this.computeIfAbsent.sum(EnumSet.of(StoreOperationOutcomes.ComputeIfAbsentOutcome.HIT)) + this.conditionalReplace.sum(EnumSet.of(StoreOperationOutcomes.ConditionalReplaceOutcome.REPLACED)) + this.conditionalRemove.sum(EnumSet.of(StoreOperationOutcomes.ConditionalRemoveOutcome.REMOVED)) - this.compensatingCounters.hits;
    }

    public long getMisses() {
        return this.get.sum(EnumSet.of(TierOperationOutcomes.GetOutcome.MISS)) + this.putIfAbsent.sum(EnumSet.of(StoreOperationOutcomes.PutIfAbsentOutcome.PUT)) + this.replace.sum(EnumSet.of(StoreOperationOutcomes.ReplaceOutcome.MISS)) + this.computeIfAbsent.sum(EnumSet.of(StoreOperationOutcomes.ComputeIfAbsentOutcome.NOOP)) + this.conditionalReplace.sum(EnumSet.of(StoreOperationOutcomes.ConditionalReplaceOutcome.MISS)) + this.conditionalRemove.sum(EnumSet.of(StoreOperationOutcomes.ConditionalRemoveOutcome.MISS)) - this.compensatingCounters.misses;
    }

    public long getPuts() {
        return this.put.sum(EnumSet.of(StoreOperationOutcomes.PutOutcome.PUT)) + this.putIfAbsent.sum(EnumSet.of(StoreOperationOutcomes.PutIfAbsentOutcome.PUT)) + this.compute.sum(EnumSet.of(StoreOperationOutcomes.ComputeOutcome.PUT)) + this.computeIfAbsent.sum(EnumSet.of(StoreOperationOutcomes.ComputeIfAbsentOutcome.PUT)) + this.replace.sum(EnumSet.of(StoreOperationOutcomes.ReplaceOutcome.REPLACED)) + this.conditionalReplace.sum(EnumSet.of(StoreOperationOutcomes.ConditionalReplaceOutcome.REPLACED)) - this.compensatingCounters.puts;
    }

    public long getRemovals() {
        return this.remove.sum(EnumSet.of(StoreOperationOutcomes.RemoveOutcome.REMOVED)) + this.compute.sum(EnumSet.of(StoreOperationOutcomes.ComputeOutcome.REMOVED)) + this.conditionalRemove.sum(EnumSet.of(StoreOperationOutcomes.ConditionalRemoveOutcome.REMOVED)) - this.compensatingCounters.removals;
    }

    public long getEvictions() {
        return this.eviction.sum(EnumSet.of(TierOperationOutcomes.EvictionOutcome.SUCCESS)) - this.compensatingCounters.evictions;
    }

    public long getExpirations() {
        return this.expiration.sum() - this.compensatingCounters.expirations;
    }

    public long getMappings() {
        return this.mapping.map(ValueStatistic::value).orElse(-1L);
    }

    public long getAllocatedByteSize() {
        return this.allocatedMemory.map(ValueStatistic::value).orElse(-1L);
    }

    public long getOccupiedByteSize() {
        return this.occupiedMemory.map(ValueStatistic::value).orElse(-1L);
    }

    private static class CompensatingCounters {
        final long hits;
        final long misses;
        final long puts;
        final long removals;
        final long evictions;
        final long expirations;

        private CompensatingCounters(long hits, long misses, long puts, long removals, long evictions, long expirations) {
            this.hits = hits;
            this.misses = misses;
            this.puts = puts;
            this.removals = removals;
            this.evictions = evictions;
            this.expirations = expirations;
        }

        static CompensatingCounters empty() {
            return new CompensatingCounters(0L, 0L, 0L, 0L, 0L, 0L);
        }

        CompensatingCounters snapshot(DefaultTierStatistics statistics) {
            return new CompensatingCounters(statistics.getHits() + this.hits, statistics.getMisses() + this.misses, statistics.getPuts() + this.puts, statistics.getRemovals() + this.removals, statistics.getEvictions() + this.evictions, statistics.getExpirations() + this.expirations);
        }
    }
}

