/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.persistence;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.ehcache.CachePersistenceException;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;
import org.ehcache.impl.persistence.FileUtils;
import org.ehcache.impl.serialization.TransientStateHolder;
import org.ehcache.spi.persistence.StateHolder;
import org.ehcache.spi.persistence.StateRepository;

class FileBasedStateRepository
implements StateRepository,
Closeable {
    private static final String HOLDER_FILE_PREFIX = "holder-";
    private static final String HOLDER_FILE_SUFFIX = ".bin";
    private final File dataDirectory;
    private final ConcurrentMap<String, Tuple> knownHolders;
    private final AtomicInteger nextIndex = new AtomicInteger();

    FileBasedStateRepository(File directory) throws CachePersistenceException {
        if (directory == null) {
            throw new NullPointerException("directory must be non null");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory + " is not a directory");
        }
        this.dataDirectory = directory;
        this.knownHolders = new ConcurrentHashMap<String, Tuple>();
        this.loadMaps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void loadMaps() throws CachePersistenceException {
        try {
            for (File file : this.dataDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(FileBasedStateRepository.HOLDER_FILE_SUFFIX);
                }
            })) {
                FileInputStream fis = new FileInputStream(file);
                try {
                    ObjectInputStream oin = new ObjectInputStream(fis);
                    try {
                        String name = (String)oin.readObject();
                        Tuple tuple = (Tuple)oin.readObject();
                        if (this.nextIndex.get() <= tuple.index) {
                            this.nextIndex.set(tuple.index + 1);
                        }
                        this.knownHolders.put(name, tuple);
                    }
                    finally {
                        oin.close();
                    }
                }
                finally {
                    fis.close();
                }
            }
        }
        catch (Exception e) {
            this.knownHolders.clear();
            throw new CachePersistenceException("Failed to load existing StateRepository data", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMaps() throws IOException {
        for (Map.Entry<String, Tuple> entry : this.knownHolders.entrySet()) {
            File outFile = new File(this.dataDirectory, this.createFileName(entry));
            FileOutputStream fos = new FileOutputStream(outFile);
            try {
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                try {
                    oos.writeObject(entry.getKey());
                    oos.writeObject(entry.getValue());
                }
                finally {
                    oos.close();
                }
            }
            finally {
                fos.close();
            }
        }
    }

    private String createFileName(Map.Entry<String, Tuple> entry) {
        return HOLDER_FILE_PREFIX + entry.getValue().index + "-" + FileUtils.safeIdentifier(entry.getKey(), false) + HOLDER_FILE_SUFFIX;
    }

    public <K extends Serializable, V extends Serializable> StateHolder<K, V> getPersistentStateHolder(String name, Class<K> keyClass, Class<V> valueClass) {
        Tuple result = (Tuple)this.knownHolders.get(name);
        if (result == null) {
            TransientStateHolder holder = new TransientStateHolder();
            result = this.knownHolders.putIfAbsent(name, new Tuple(this.nextIndex.getAndIncrement(), holder));
            if (result == null) {
                return holder;
            }
        }
        return result.holder;
    }

    @Override
    public void close() throws IOException {
        this.saveMaps();
    }

    static class Tuple
    implements Serializable {
        final int index;
        final StateHolder<?, ?> holder;

        Tuple(int index, StateHolder<?, ?> holder) {
            this.index = index;
            this.holder = holder;
        }
    }
}

