/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.events;

import org.ehcache.core.spi.store.events.StoreEvent;
import org.ehcache.event.EventType;

public class StoreEventImpl<K, V>
implements StoreEvent<K, V> {
    private final EventType type;
    private final K key;
    private final V oldValue;
    private final V newValue;

    public StoreEventImpl(EventType type, K key, V oldValue, V newValue) {
        this.type = type;
        this.key = key;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public EventType getType() {
        return this.type;
    }

    public K getKey() {
        return this.key;
    }

    public V getNewValue() {
        return this.newValue;
    }

    public V getOldValue() {
        return this.oldValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreEventImpl that = (StoreEventImpl)o;
        if (this.type != that.type) {
            return false;
        }
        if (!this.key.equals(that.key)) {
            return false;
        }
        if (this.oldValue != null ? !this.oldValue.equals(that.oldValue) : that.oldValue != null) {
            return false;
        }
        return this.newValue != null ? this.newValue.equals(that.newValue) : that.newValue == null;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.key.hashCode();
        result = 31 * result + (this.oldValue != null ? this.oldValue.hashCode() : 0);
        result = 31 * result + (this.newValue != null ? this.newValue.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("Event of type %s for key %s", this.type, this.key);
    }
}

