/*
 * Copyright Terracotta, Inc.
 * Copyright IBM Corp. 2024, 2025
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ehcache.impl.internal.loaderwriter.writebehind.operations;

import org.ehcache.spi.loaderwriter.CacheLoaderWriter;

/**
 * Implements the delete operation for write behind
 *
 * @author Geert Bevin
 * @author Tim wu
 *
 */
public class DeleteOperation<K, V> implements SingleOperation<K, V> {

  private final K key;
  private final long creationTime;

  /**
   * Create a new delete operation for a particular entry
   *
   */
  public DeleteOperation(K key) {
    this(key, System.nanoTime());
  }

  /**
   * Create a new delete operation for a particular entry and creation time
   *
   */
  public DeleteOperation(K key, long creationTime) {
    this.key = key;
    this.creationTime = creationTime;
  }

  public void performOperation(CacheLoaderWriter<K, V> cacheLoaderWriter) throws Exception {
    cacheLoaderWriter.delete(key);
  }

  @Override
  public K getKey() {
    return this.key;
  }

  @Override
  public long getCreationTime() {
    return creationTime;
  }

  @Override
  public int hashCode() {
    return getKey().hashCode();
  }

  @Override
  public boolean equals(Object other) {
    if (other instanceof DeleteOperation) {
      return getCreationTime() == ((DeleteOperation<?, ?>) other).getCreationTime() && getKey().equals(((DeleteOperation<?, ?>) other).getKey());
    } else {
      return false;
    }
  }

}
