/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.loaderwriter.writebehind;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.ehcache.core.spi.service.ExecutionService;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;
import org.ehcache.impl.internal.executor.ExecutorUtil;
import org.ehcache.impl.internal.loaderwriter.writebehind.AbstractWriteBehind;
import org.ehcache.impl.internal.loaderwriter.writebehind.operations.BatchOperation;
import org.ehcache.impl.internal.loaderwriter.writebehind.operations.DeleteAllOperation;
import org.ehcache.impl.internal.loaderwriter.writebehind.operations.DeleteOperation;
import org.ehcache.impl.internal.loaderwriter.writebehind.operations.SingleOperation;
import org.ehcache.impl.internal.loaderwriter.writebehind.operations.WriteAllOperation;
import org.ehcache.impl.internal.loaderwriter.writebehind.operations.WriteOperation;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.loaderwriter.WriteBehindConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchingLocalHeapWriteBehindQueue<K, V>
extends AbstractWriteBehind<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchingLocalHeapWriteBehindQueue.class);
    private final CacheLoaderWriter<K, V> cacheLoaderWriter;
    private final ConcurrentMap<K, SingleOperation<K, V>> latest = new ConcurrentHashMap<K, SingleOperation<K, V>>();
    private final BlockingQueue executorQueue;
    private final ExecutorService executor;
    private final ScheduledExecutorService scheduledExecutor;
    private final long maxWriteDelayMs;
    private final int batchSize;
    private final boolean coalescing;
    private volatile Batch openBatch;

    public BatchingLocalHeapWriteBehindQueue(ExecutionService executionService, String defaultThreadPool, WriteBehindConfiguration config, CacheLoaderWriter<K, V> cacheLoaderWriter) {
        super(cacheLoaderWriter);
        this.cacheLoaderWriter = cacheLoaderWriter;
        WriteBehindConfiguration.BatchingConfiguration batchingConfig = config.getBatchingConfiguration();
        this.maxWriteDelayMs = batchingConfig.getMaxDelayUnit().toMillis(batchingConfig.getMaxDelay());
        this.batchSize = batchingConfig.getBatchSize();
        this.coalescing = batchingConfig.isCoalescing();
        this.executorQueue = new LinkedBlockingQueue(config.getMaxQueueSize() / this.batchSize);
        this.executor = config.getThreadPoolAlias() == null ? executionService.getOrderedExecutor(defaultThreadPool, this.executorQueue) : executionService.getOrderedExecutor(config.getThreadPoolAlias(), this.executorQueue);
        this.scheduledExecutor = config.getThreadPoolAlias() == null ? executionService.getScheduledExecutor(defaultThreadPool) : executionService.getScheduledExecutor(config.getThreadPoolAlias());
    }

    @Override
    protected SingleOperation<K, V> getOperation(K key) {
        return (SingleOperation)this.latest.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addOperation(SingleOperation<K, V> operation) {
        this.latest.put(operation.getKey(), operation);
        BatchingLocalHeapWriteBehindQueue batchingLocalHeapWriteBehindQueue = this;
        synchronized (batchingLocalHeapWriteBehindQueue) {
            if (this.openBatch == null) {
                this.openBatch = this.newBatch();
            }
            if (this.openBatch.add(operation)) {
                this.submit(this.openBatch);
                this.openBatch = null;
            }
        }
    }

    @Override
    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            BatchingLocalHeapWriteBehindQueue batchingLocalHeapWriteBehindQueue = this;
            synchronized (batchingLocalHeapWriteBehindQueue) {
                if (this.openBatch != null) {
                    ExecutorUtil.waitFor(this.submit(this.openBatch));
                    this.openBatch = null;
                }
            }
        }
        catch (ExecutionException e) {
            LOGGER.error("Exception running batch on shutdown", (Throwable)e);
        }
        finally {
            ExecutorUtil.shutdownNow(this.scheduledExecutor);
            ExecutorUtil.shutdown(this.executor);
        }
    }

    private Batch newBatch() {
        if (this.coalescing) {
            return new CoalescingBatch(this.batchSize);
        }
        return new SimpleBatch(this.batchSize);
    }

    private Future<?> submit(Batch batch) {
        return this.executor.submit(batch);
    }

    @Override
    public long getQueueSize() {
        Batch snapshot = this.openBatch;
        return this.executorQueue.size() * this.batchSize + (snapshot == null ? 0 : snapshot.size());
    }

    private static <K, V> List<BatchOperation<K, V>> createMonomorphicBatches(Iterable<SingleOperation<K, V>> batch) {
        ArrayList<BatchOperation<K, V>> closedBatches = new ArrayList<BatchOperation<K, V>>();
        HashSet activeDeleteKeys = new HashSet();
        HashSet activeWrittenKeys = new HashSet();
        ArrayList activeDeleteBatch = new ArrayList();
        ArrayList activeWriteBatch = new ArrayList();
        for (SingleOperation<K, V> item : batch) {
            if (item instanceof WriteOperation) {
                if (activeDeleteKeys.contains(item.getKey())) {
                    closedBatches.add(new DeleteAllOperation(activeDeleteBatch));
                    activeDeleteBatch = new ArrayList();
                    activeDeleteKeys = new HashSet();
                }
                activeWriteBatch.add(new AbstractMap.SimpleEntry(item.getKey(), ((WriteOperation)item).getValue()));
                activeWrittenKeys.add(item.getKey());
                continue;
            }
            if (item instanceof DeleteOperation) {
                if (activeWrittenKeys.contains(item.getKey())) {
                    closedBatches.add(new WriteAllOperation(activeWriteBatch));
                    activeWriteBatch = new ArrayList();
                    activeWrittenKeys = new HashSet();
                }
                activeDeleteBatch.add(item.getKey());
                activeDeleteKeys.add(item.getKey());
                continue;
            }
            throw new AssertionError();
        }
        if (!activeWriteBatch.isEmpty()) {
            closedBatches.add(new WriteAllOperation(activeWriteBatch));
        }
        if (!activeDeleteBatch.isEmpty()) {
            closedBatches.add(new DeleteAllOperation(activeDeleteBatch));
        }
        return closedBatches;
    }

    private class CoalescingBatch
    extends Batch {
        private final LinkedHashMap<K, SingleOperation<K, V>> operations;

        public CoalescingBatch(int size) {
            super(size);
            this.operations = new LinkedHashMap(size);
        }

        @Override
        public void internalAdd(SingleOperation<K, V> operation) {
            this.operations.put(operation.getKey(), operation);
        }

        @Override
        protected Iterable<SingleOperation<K, V>> operations() {
            return this.operations.values();
        }

        @Override
        protected int size() {
            return this.operations.size();
        }
    }

    private class SimpleBatch
    extends Batch {
        private final List<SingleOperation<K, V>> operations;

        SimpleBatch(int size) {
            super(size);
            this.operations = new ArrayList(size);
        }

        @Override
        public void internalAdd(SingleOperation<K, V> operation) {
            this.operations.add(operation);
        }

        protected List<SingleOperation<K, V>> operations() {
            return this.operations;
        }

        @Override
        protected int size() {
            return this.operations.size();
        }
    }

    abstract class Batch
    implements Runnable {
        private final int batchSize;
        private final ScheduledFuture<?> expireTask;

        Batch(int size) {
            this.batchSize = size;
            this.expireTask = BatchingLocalHeapWriteBehindQueue.this.scheduledExecutor.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BatchingLocalHeapWriteBehindQueue batchingLocalHeapWriteBehindQueue = BatchingLocalHeapWriteBehindQueue.this;
                    synchronized (batchingLocalHeapWriteBehindQueue) {
                        if (BatchingLocalHeapWriteBehindQueue.this.openBatch == Batch.this) {
                            BatchingLocalHeapWriteBehindQueue.this.submit(BatchingLocalHeapWriteBehindQueue.this.openBatch);
                            BatchingLocalHeapWriteBehindQueue.this.openBatch = null;
                        }
                    }
                }
            }, BatchingLocalHeapWriteBehindQueue.this.maxWriteDelayMs, TimeUnit.MILLISECONDS);
        }

        public boolean add(SingleOperation<K, V> operation) {
            this.internalAdd(operation);
            return this.size() >= this.batchSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                List batches = BatchingLocalHeapWriteBehindQueue.createMonomorphicBatches(this.operations());
                for (BatchOperation batch : batches) {
                    try {
                        batch.performBatchOperation(BatchingLocalHeapWriteBehindQueue.this.cacheLoaderWriter);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Exception while bulk processing in write behind queue", (Throwable)e);
                    }
                }
            }
            finally {
                try {
                    for (SingleOperation op : this.operations()) {
                        BatchingLocalHeapWriteBehindQueue.this.latest.remove(op.getKey(), op);
                    }
                }
                finally {
                    LOGGER.debug("Cancelling batch expiry task");
                    this.expireTask.cancel(false);
                }
            }
        }

        protected abstract void internalAdd(SingleOperation<K, V> var1);

        protected abstract Iterable<SingleOperation<K, V>> operations();

        protected abstract int size();
    }
}

