/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.disk.factories;

import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.impl.internal.store.offheap.factories.EhcacheSegmentFactory;
import org.terracotta.offheapstore.disk.paging.MappedPageSource;
import org.terracotta.offheapstore.disk.persistent.PersistentReadWriteLockedOffHeapClockCache;
import org.terracotta.offheapstore.disk.persistent.PersistentStorageEngine;
import org.terracotta.offheapstore.pinning.PinnableSegment;
import org.terracotta.offheapstore.util.Factory;

public class EhcachePersistentSegmentFactory<K, V>
implements Factory<PinnableSegment<K, V>> {
    private final Factory<? extends PersistentStorageEngine<? super K, ? super V>> storageEngineFactory;
    private final MappedPageSource tableSource;
    private final int tableSize;
    private final EvictionAdvisor<? super K, ? super V> evictionAdvisor;
    private final EhcacheSegmentFactory.EhcacheSegment.EvictionListener<K, V> evictionListener;
    private final boolean bootstrap;

    public EhcachePersistentSegmentFactory(MappedPageSource source, Factory<? extends PersistentStorageEngine<? super K, ? super V>> storageEngineFactory, int initialTableSize, EvictionAdvisor<? super K, ? super V> evictionAdvisor, EhcacheSegmentFactory.EhcacheSegment.EvictionListener<K, V> evictionListener, boolean bootstrap) {
        this.storageEngineFactory = storageEngineFactory;
        this.tableSource = source;
        this.tableSize = initialTableSize;
        this.evictionAdvisor = evictionAdvisor;
        this.evictionListener = evictionListener;
        this.bootstrap = bootstrap;
    }

    public EhcachePersistentSegment<K, V> newInstance() {
        PersistentStorageEngine storageEngine = (PersistentStorageEngine)this.storageEngineFactory.newInstance();
        try {
            return new EhcachePersistentSegment<K, V>(this.tableSource, storageEngine, this.tableSize, this.bootstrap, this.evictionAdvisor, this.evictionListener);
        }
        catch (RuntimeException e) {
            storageEngine.destroy();
            throw e;
        }
    }

    public static class EhcachePersistentSegment<K, V>
    extends PersistentReadWriteLockedOffHeapClockCache<K, V> {
        private final EvictionAdvisor<? super K, ? super V> evictionAdvisor;
        private final EhcacheSegmentFactory.EhcacheSegment.EvictionListener<K, V> evictionListener;

        EhcachePersistentSegment(MappedPageSource source, PersistentStorageEngine<? super K, ? super V> storageEngine, int tableSize, boolean bootstrap, EvictionAdvisor<? super K, ? super V> evictionAdvisor, EhcacheSegmentFactory.EhcacheSegment.EvictionListener<K, V> evictionListener) {
            super(source, storageEngine, tableSize, bootstrap);
            this.evictionAdvisor = evictionAdvisor;
            this.evictionListener = evictionListener;
        }

        public V put(K key, V value) {
            int metadata = this.getEvictionAdviceStatus(key, value);
            return (V)this.put(key, value, metadata);
        }

        private int getEvictionAdviceStatus(K key, V value) {
            return this.evictionAdvisor.adviseAgainstEviction(key, value) ? 0x20000000 : 0;
        }

        public V putPinned(K key, V value) {
            int metadata = this.getEvictionAdviceStatus(key, value) | 0x40000000;
            return (V)this.put(key, value, metadata);
        }

        protected boolean evictable(int status) {
            return super.evictable(status) && (status & 0x20000000) == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean evict(int index, boolean shrink) {
            Lock lock = this.writeLock();
            lock.lock();
            try {
                Map.Entry entry = this.getEntryAtTableOffset(index);
                boolean evicted = super.evict(index, shrink);
                if (evicted) {
                    this.evictionListener.onEviction(entry.getKey(), entry.getValue());
                }
                boolean bl = evicted;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
    }
}

