/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.config.serializer;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ehcache.core.spi.service.FileBasedPersistenceContext;
import org.ehcache.spi.serialization.SerializationProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.ServiceCreationConfiguration;

public class DefaultSerializationProviderConfiguration
implements ServiceCreationConfiguration<SerializationProvider> {
    private final Map<Class<?>, Class<? extends Serializer<?>>> transientSerializers = new LinkedHashMap();
    private final Map<Class<?>, Class<? extends Serializer<?>>> persistentSerializers = new LinkedHashMap();

    public DefaultSerializationProviderConfiguration() {
    }

    public DefaultSerializationProviderConfiguration(DefaultSerializationProviderConfiguration other) {
        this.transientSerializers.putAll(other.transientSerializers);
        this.persistentSerializers.putAll(other.persistentSerializers);
    }

    public Class<SerializationProvider> getServiceType() {
        return SerializationProvider.class;
    }

    public <T> DefaultSerializationProviderConfiguration addSerializerFor(Class<T> serializableClass, Class<? extends Serializer<T>> serializerClass) {
        return this.addSerializerFor(serializableClass, serializerClass, false);
    }

    public <T> DefaultSerializationProviderConfiguration addSerializerFor(Class<T> serializableClass, Class<? extends Serializer<T>> serializerClass, boolean overwrite) {
        boolean persistentConstructorPresent;
        if (serializableClass == null) {
            throw new NullPointerException("Serializable class cannot be null");
        }
        if (serializerClass == null) {
            throw new NullPointerException("Serializer class cannot be null");
        }
        boolean transientConstructorPresent = DefaultSerializationProviderConfiguration.isConstructorPresent(serializerClass, ClassLoader.class);
        if (transientConstructorPresent) {
            if (!overwrite && this.transientSerializers.containsKey(serializableClass)) {
                throw new IllegalArgumentException("Duplicate transient serializer for class : " + serializableClass.getName());
            }
            this.transientSerializers.put(serializableClass, serializerClass);
        }
        if (persistentConstructorPresent = DefaultSerializationProviderConfiguration.isConstructorPresent(serializerClass, ClassLoader.class, FileBasedPersistenceContext.class)) {
            if (!overwrite && this.persistentSerializers.containsKey(serializableClass)) {
                throw new IllegalArgumentException("Duplicate persistent serializer for class : " + serializableClass.getName());
            }
            this.persistentSerializers.put(serializableClass, serializerClass);
        }
        if (!transientConstructorPresent && !persistentConstructorPresent) {
            throw new IllegalArgumentException("The serializer: " + serializerClass.getName() + " does not meet the constructor requirements for either transient or persistent caches.");
        }
        return this;
    }

    private static boolean isConstructorPresent(Class<?> clazz, Class<?> ... args) {
        try {
            clazz.getConstructor(args);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public Map<Class<?>, Class<? extends Serializer<?>>> getTransientSerializers() {
        return Collections.unmodifiableMap(this.transientSerializers);
    }

    public Map<Class<?>, Class<? extends Serializer<?>>> getPersistentSerializers() {
        return Collections.unmodifiableMap(this.persistentSerializers);
    }
}

