/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.classes;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.core.internal.service.ServiceLocator;
import org.ehcache.core.internal.util.ConcurrentWeakIdentityHashMap;
import org.ehcache.impl.internal.classes.ClassInstanceConfiguration;
import org.ehcache.impl.internal.classes.ClassInstanceProviderConfiguration;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;

public class ClassInstanceProvider<K, T> {
    protected final Map<K, ClassInstanceConfiguration<T>> preconfigured = Collections.synchronizedMap(new LinkedHashMap());
    protected final ConcurrentWeakIdentityHashMap<T, AtomicInteger> providedVsCount = new ConcurrentWeakIdentityHashMap();
    private final Class<? extends ClassInstanceConfiguration<T>> cacheLevelConfig;
    private final boolean uniqueClassLevelConfig;

    protected ClassInstanceProvider(ClassInstanceProviderConfiguration<K, T> factoryConfig, Class<? extends ClassInstanceConfiguration<T>> cacheLevelConfig) {
        this(factoryConfig, cacheLevelConfig, false);
    }

    protected ClassInstanceProvider(ClassInstanceProviderConfiguration<K, T> factoryConfig, Class<? extends ClassInstanceConfiguration<T>> cacheLevelConfig, boolean uniqueClassLevelConfig) {
        this.uniqueClassLevelConfig = uniqueClassLevelConfig;
        if (factoryConfig != null) {
            this.preconfigured.putAll(factoryConfig.getDefaults());
        }
        this.cacheLevelConfig = cacheLevelConfig;
    }

    protected ClassInstanceConfiguration<T> getPreconfigured(K alias) {
        return this.preconfigured.get(alias);
    }

    protected T newInstance(K alias, CacheConfiguration<?, ?> cacheConfiguration) {
        ClassInstanceConfiguration config = null;
        if (this.uniqueClassLevelConfig) {
            config = (ClassInstanceConfiguration)ServiceLocator.findSingletonAmongst(this.cacheLevelConfig, (Collection)cacheConfiguration.getServiceConfigurations());
        } else {
            Iterator iterator = ServiceLocator.findAmongst(this.cacheLevelConfig, (Collection)cacheConfiguration.getServiceConfigurations()).iterator();
            if (iterator.hasNext()) {
                config = (ClassInstanceConfiguration)iterator.next();
            }
        }
        return this.newInstance(alias, config);
    }

    protected T newInstance(K alias, ServiceConfiguration<?> serviceConfiguration) {
        ClassInstanceConfiguration<T> config = null;
        if (serviceConfiguration != null && this.cacheLevelConfig.isAssignableFrom(serviceConfiguration.getClass())) {
            config = this.cacheLevelConfig.cast(serviceConfiguration);
        }
        return this.newInstance(alias, config);
    }

    /*
     * Exception decompiling
     */
    private T newInstance(K alias, ClassInstanceConfiguration<T> config) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.getBindingFor(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "res" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.getGtbNullFiltered(GenericInferer.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.inferGenericObjectInfoFromCalls(GenericInferer.java:139)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:484)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void releaseInstance(T instance) throws IOException {
        AtomicInteger currentCount = (AtomicInteger)this.providedVsCount.get(instance);
        if (currentCount != null) {
            if (currentCount.decrementAndGet() < 0) {
                currentCount.incrementAndGet();
                throw new IllegalArgumentException("Given instance of " + instance.getClass().getName() + " is not managed by this provider");
            }
        } else {
            throw new IllegalArgumentException("Given instance of " + instance.getClass().getName() + " is not managed by this provider");
        }
        if (instance instanceof Closeable) {
            ((Closeable)instance).close();
        }
    }

    public void start(ServiceProvider<Service> serviceProvider) {
    }

    public void stop() {
    }
}

