/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.offheap.portability;

import java.nio.ByteBuffer;
import org.ehcache.exceptions.SerializerException;
import org.ehcache.spi.serialization.Serializer;
import org.terracotta.offheapstore.storage.portability.Portability;

public class SerializerPortability<T>
implements Portability<T> {
    private final Serializer<T> serializer;

    public SerializerPortability(Serializer<T> serializer) {
        this.serializer = serializer;
    }

    public ByteBuffer encode(T t) {
        return this.serializer.serialize(t);
    }

    public T decode(ByteBuffer byteBuffer) {
        try {
            return (T)this.serializer.read(byteBuffer);
        }
        catch (ClassNotFoundException e) {
            throw new SerializerException((Throwable)e);
        }
    }

    public boolean equals(Object o, ByteBuffer byteBuffer) {
        try {
            return this.serializer.equals(o, byteBuffer);
        }
        catch (ClassNotFoundException e) {
            throw new SerializerException((Throwable)e);
        }
    }
}

