/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.offheap;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.ehcache.config.Eviction;
import org.ehcache.config.EvictionVeto;
import org.ehcache.config.ResourcePool;
import org.ehcache.config.ResourceType;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.events.StoreEventDispatcher;
import org.ehcache.core.internal.util.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.spi.cache.Store;
import org.ehcache.core.spi.cache.tiering.AuthoritativeTier;
import org.ehcache.core.spi.cache.tiering.LowerCachingTier;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.spi.time.TimeSourceService;
import org.ehcache.exceptions.CacheAccessException;
import org.ehcache.impl.internal.events.ThreadLocalStoreEventDispatcher;
import org.ehcache.impl.internal.store.offheap.AbstractOffHeapStore;
import org.ehcache.impl.internal.store.offheap.EhcacheConcurrentOffHeapClockCache;
import org.ehcache.impl.internal.store.offheap.EhcacheOffHeapBackingMap;
import org.ehcache.impl.internal.store.offheap.HeuristicConfiguration;
import org.ehcache.impl.internal.store.offheap.OffHeapStoreUtils;
import org.ehcache.impl.internal.store.offheap.OffHeapValueHolder;
import org.ehcache.impl.internal.store.offheap.factories.EhcacheSegmentFactory;
import org.ehcache.impl.internal.store.offheap.portability.OffHeapValueHolderPortability;
import org.ehcache.impl.internal.store.offheap.portability.SerializerPortability;
import org.ehcache.spi.ServiceProvider;
import org.ehcache.spi.serialization.SerializationProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.offheapstore.paging.PageSource;
import org.terracotta.offheapstore.paging.UpfrontAllocatingPageSource;
import org.terracotta.offheapstore.storage.OffHeapBufferStorageEngine;
import org.terracotta.offheapstore.storage.PointerSize;
import org.terracotta.offheapstore.util.Factory;

public class OffHeapStore<K, V>
extends AbstractOffHeapStore<K, V> {
    private final EvictionVeto<K, OffHeapValueHolder<V>> evictionVeto;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private final long sizeInBytes;
    private volatile EhcacheConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> map;

    public OffHeapStore(Store.Configuration<K, V> config, TimeSource timeSource, StoreEventDispatcher<K, V> eventDispatcher, long sizeInBytes) {
        super("local-offheap", config, timeSource, eventDispatcher);
        EvictionVeto veto = config.getEvictionVeto();
        this.evictionVeto = veto != null ? OffHeapStore.wrap(veto) : Eviction.none();
        this.keySerializer = config.getKeySerializer();
        this.valueSerializer = config.getValueSerializer();
        this.sizeInBytes = sizeInBytes;
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        return Collections.emptyList();
    }

    private EhcacheConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> createBackingMap(long size, Serializer<K> keySerializer, Serializer<V> valueSerializer, EvictionVeto<K, OffHeapValueHolder<V>> evictionVeto) {
        HeuristicConfiguration config = new HeuristicConfiguration(size);
        UpfrontAllocatingPageSource source = new UpfrontAllocatingPageSource(OffHeapStoreUtils.getBufferSource(), config.getMaximumSize(), config.getMaximumChunkSize(), config.getMinimumChunkSize());
        SerializerPortability<K> keyPortability = new SerializerPortability<K>(keySerializer);
        OffHeapValueHolderPortability<V> elementPortability = new OffHeapValueHolderPortability<V>(valueSerializer);
        Factory storageEngineFactory = OffHeapBufferStorageEngine.createFactory((PointerSize)PointerSize.INT, (PageSource)source, (int)config.getSegmentDataPageSize(), keyPortability, elementPortability, (boolean)false, (boolean)true);
        EhcacheSegmentFactory<K, OffHeapValueHolder<V>> segmentFactory = new EhcacheSegmentFactory<K, OffHeapValueHolder<V>>((PageSource)source, storageEngineFactory, config.getInitialSegmentTableSize(), evictionVeto, this.mapEvictionListener);
        return new EhcacheConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>>(evictionVeto, segmentFactory, config.getConcurrency());
    }

    @Override
    protected EhcacheOffHeapBackingMap<K, OffHeapValueHolder<V>> backingMap() {
        return this.map;
    }

    @ServiceDependencies(value={TimeSourceService.class, SerializationProvider.class})
    public static class Provider
    implements Store.Provider,
    AuthoritativeTier.Provider,
    LowerCachingTier.Provider {
        private static final Logger LOGGER = LoggerFactory.getLogger(Provider.class);
        private volatile ServiceProvider<Service> serviceProvider;
        private final Set<Store<?, ?>> createdStores = Collections.newSetFromMap(new ConcurrentWeakIdentityHashMap());

        public <K, V> OffHeapStore<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            return this.createStoreInternal(storeConfig, new ThreadLocalStoreEventDispatcher(storeConfig.getOrderedEventParallelism()), serviceConfigs);
        }

        private <K, V> OffHeapStore<K, V> createStoreInternal(Store.Configuration<K, V> storeConfig, StoreEventDispatcher<K, V> eventDispatcher, ServiceConfiguration<?> ... serviceConfigs) {
            if (this.serviceProvider == null) {
                throw new NullPointerException("ServiceProvider is null in OffHeapStore.Provider.");
            }
            TimeSource timeSource = ((TimeSourceService)this.serviceProvider.getService(TimeSourceService.class)).getTimeSource();
            ResourcePool offHeapPool = storeConfig.getResourcePools().getPoolForResource((ResourceType)ResourceType.Core.OFFHEAP);
            if (!(offHeapPool.getUnit() instanceof MemoryUnit)) {
                throw new IllegalArgumentException("OffHeapStore only supports resources with memory unit");
            }
            MemoryUnit unit = (MemoryUnit)offHeapPool.getUnit();
            OffHeapStore<K, V> offHeapStore = new OffHeapStore<K, V>(storeConfig, timeSource, eventDispatcher, unit.toBytes(offHeapPool.getSize()));
            this.createdStores.add((Store<?, ?>)offHeapStore);
            return offHeapStore;
        }

        public void releaseStore(Store<?, ?> resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            Provider.close((OffHeapStore)resource);
        }

        static void close(OffHeapStore resource) {
            EhcacheConcurrentOffHeapClockCache localMap = resource.map;
            if (localMap != null) {
                resource.map = null;
                localMap.destroy();
            }
        }

        public void initStore(Store<?, ?> resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            Provider.init((OffHeapStore)resource);
        }

        static <K, V> void init(OffHeapStore<K, V> resource) {
            ((OffHeapStore)resource).map = ((OffHeapStore)resource).createBackingMap(((OffHeapStore)resource).sizeInBytes, ((OffHeapStore)resource).keySerializer, ((OffHeapStore)resource).valueSerializer, ((OffHeapStore)resource).evictionVeto);
        }

        public void start(ServiceProvider<Service> serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        public void stop() {
            this.serviceProvider = null;
            this.createdStores.clear();
        }

        public <K, V> AuthoritativeTier<K, V> createAuthoritativeTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            return this.createStore(storeConfig, serviceConfigs);
        }

        public void releaseAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.releaseStore((Store<?, ?>)resource);
        }

        public void initAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.initStore((Store<?, ?>)resource);
        }

        /*
         * Exception decompiling
         */
        public <K, V> LowerCachingTier<K, V> createCachingTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
             *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void releaseCachingTier(LowerCachingTier<?, ?> resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given caching tier is not managed by this provider : " + resource);
            }
            this.flushToLowerTier((OffHeapStore)resource);
            this.releaseStore((Store)resource);
        }

        private void flushToLowerTier(OffHeapStore<Object, ?> resource) {
            CacheAccessException lastFailure = null;
            int failureCount = 0;
            OffHeapStore<Object, ?> offheapStore = resource;
            Set keys = offheapStore.backingMap().keySet();
            for (Object key : keys) {
                try {
                    offheapStore.invalidate(key);
                }
                catch (CacheAccessException cae) {
                    lastFailure = cae;
                    ++failureCount;
                    LOGGER.warn("Error flushing '{}' to lower tier", key, (Object)cae);
                }
            }
            if (lastFailure != null) {
                throw new RuntimeException("Failed to flush some mappings to lower tier, " + failureCount + " could not be flushed. This error represents the last failure.", lastFailure);
            }
        }

        public void initCachingTier(LowerCachingTier<?, ?> resource) {
            if (!this.createdStores.contains(resource)) {
                throw new IllegalArgumentException("Given caching tier is not managed by this provider : " + resource);
            }
            this.initStore((Store)resource);
        }
    }
}

