/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.offheap;

import java.util.concurrent.TimeUnit;
import org.ehcache.core.spi.cache.AbstractValueHolder;
import org.ehcache.core.spi.cache.Store;
import org.terracotta.offheapstore.storage.portability.WriteContext;

public final class OffHeapValueHolder<V>
extends AbstractValueHolder<V> {
    public static final TimeUnit TIME_UNIT = TimeUnit.MILLISECONDS;
    private final V value;
    private final WriteContext writeContext;

    public OffHeapValueHolder(long id, V value, long creationTime, long expireTime) {
        this(id, value, creationTime, expireTime, 0L, 0L, null);
    }

    public OffHeapValueHolder(long id, V value, long creationTime, long expireTime, long lastAccessTime, long hits, WriteContext writeContext) {
        super(id, creationTime, expireTime);
        this.setLastAccessTime(lastAccessTime, TIME_UNIT);
        this.value = value;
        this.setHits(hits);
        this.writeContext = writeContext;
    }

    public V value() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        OffHeapValueHolder that = (OffHeapValueHolder)((Object)other);
        if (!super.equals((Object)that)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    protected final TimeUnit nativeTimeUnit() {
        return TIME_UNIT;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.value.hashCode();
        result = 31 * result + super.hashCode();
        return result;
    }

    public void writeBack() {
        this.writeContext.setLong(16, this.lastAccessTime(TimeUnit.MILLISECONDS));
        this.writeContext.setLong(24, this.expirationTime(TimeUnit.MILLISECONDS));
        this.writeContext.setLong(32, this.hits());
        this.writeContext.flush();
    }

    public void updateMetadata(Store.ValueHolder<V> valueFlushed) {
        if (this.getId() != valueFlushed.getId()) {
            throw new IllegalArgumentException("Wrong id passed in [this.id != id] : " + this.getId() + " != " + valueFlushed.getId());
        }
        this.setLastAccessTime(valueFlushed.lastAccessTime(TIME_UNIT), TIME_UNIT);
        this.setExpirationTime(valueFlushed.expirationTime(TIME_UNIT), TIME_UNIT);
        this.setHits(valueFlushed.hits());
    }
}

