/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.executor;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.ehcache.core.spi.service.ExecutionService;
import org.ehcache.impl.internal.util.ThreadFactoryUtil;
import org.ehcache.spi.ServiceProvider;

public class OnDemandExecutionService
implements ExecutionService {
    private static final RejectedExecutionHandler WAIT_FOR_SPACE = new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor tpe) {
            boolean interrupted = false;
            while (true) {
                try {
                    tpe.getQueue().put(r);
                    return;
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    };

    public ScheduledExecutorService getScheduledExecutor(String poolAlias) {
        return Executors.unconfigurableScheduledExecutorService(Executors.newSingleThreadScheduledExecutor(ThreadFactoryUtil.threadFactory(poolAlias)));
    }

    public ExecutorService getOrderedExecutor(String poolAlias, BlockingQueue<Runnable> queue) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, queue, ThreadFactoryUtil.threadFactory(poolAlias), WAIT_FOR_SPACE);
        executor.allowCoreThreadTimeOut(true);
        return Executors.unconfigurableExecutorService(executor);
    }

    public ExecutorService getUnorderedExecutor(String poolAlias, BlockingQueue<Runnable> queue) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, Runtime.getRuntime().availableProcessors(), 30L, TimeUnit.SECONDS, queue, ThreadFactoryUtil.threadFactory(poolAlias), WAIT_FOR_SPACE);
        executor.allowCoreThreadTimeOut(true);
        return Executors.unconfigurableExecutorService(executor);
    }

    public void start(ServiceProvider serviceProvider) {
    }

    public void stop() {
    }
}

